/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Calendar;
import java.util.TimeZone;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.protocol.Gt06ProtocolDecoder;

public class TopinProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 1;
    public static final int MSG_GPS_2 = 8;
    public static final int MSG_GPS_OFFLINE_2 = 9;
    public static final int MSG_GPS = 16;
    public static final int MSG_GPS_OFFLINE = 17;
    public static final int MSG_STATUS = 19;
    public static final int MSG_WIFI_OFFLINE = 23;
    public static final int MSG_TIME_UPDATE = 48;
    public static final int MSG_WIFI = 105;

    public TopinProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, int length, int type, ByteBuf content) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(30840);
            response.writeByte(length);
            response.writeByte(type);
            response.writeBytes(content);
            response.writeByte(13);
            response.writeByte(10);
            content.release();
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private void updateTime(Channel channel, int type) {
        ByteBuf dateBuffer = Unpooled.buffer();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        dateBuffer.writeShort(calendar.get(1));
        dateBuffer.writeByte(calendar.get(2) + 1);
        dateBuffer.writeByte(calendar.get(5));
        dateBuffer.writeByte(calendar.get(11));
        dateBuffer.writeByte(calendar.get(12));
        dateBuffer.writeByte(calendar.get(13));
        this.sendResponse(channel, dateBuffer.readableBytes(), type, dateBuffer);
    }

    private double readCoordinate(ByteBuf buf) {
        short degrees = buf.readUnsignedByte();
        boolean negative = (buf.getUnsignedByte(buf.readerIndex()) & 0xF0) > 0;
        int decimal = buf.readUnsignedMedium() & 0xFFFFF;
        double result = (double)degrees + (double)decimal * 1.0E-6;
        return negative ? -result : result;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        int length = buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        if (type == 1) {
            String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
            ByteBuf content = Unpooled.buffer();
            content.writeByte(deviceSession != null ? 1 : 68);
            this.sendResponse(channel, length, type, content);
            this.updateTime(channel, 48);
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        if (type == 8 || type == 9) {
            if (buf.readableBytes() <= 2) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
            position.setTime(dateBuilder.getDate());
            position.setValid(type == 8);
            position.setLatitude(this.readCoordinate(buf));
            position.setLongitude(this.readCoordinate(buf));
            buf.skipBytes(8);
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
            position.setCourse(buf.readUnsignedByte() * 2);
            position.set("sat", buf.readUnsignedByte());
            return position;
        }
        if (type == 16 || type == 17) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            ByteBuf time = buf.slice(buf.readerIndex(), 6);
            Gt06ProtocolDecoder.decodeGps(position, buf, false, TimeZone.getTimeZone("UTC"));
            ByteBuf content = Unpooled.buffer();
            content.writeBytes(time);
            this.sendResponse(channel, length, type, content);
            return position;
        }
        if (type == 48) {
            this.updateTime(channel, type);
            return null;
        }
        if (type == 19) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.getLastLocation(position, null);
            position.set("batteryLevel", buf.readUnsignedByte());
            position.set("versionFw", buf.readUnsignedByte());
            buf.readUnsignedByte();
            short interval = buf.readUnsignedByte();
            if (length >= 7) {
                position.set("rssi", buf.readUnsignedByte());
            }
            ByteBuf content = Unpooled.buffer();
            content.writeByte((int)interval);
            this.sendResponse(channel, length, type, content);
            return position;
        }
        if (type == 105 || type == 23) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            ByteBuf time = buf.readSlice(6);
            DateBuilder dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(time, 2)).setMonth(BcdUtil.readInteger(time, 2)).setDay(BcdUtil.readInteger(time, 2)).setHour(BcdUtil.readInteger(time, 2)).setMinute(BcdUtil.readInteger(time, 2)).setSecond(BcdUtil.readInteger(time, 2));
            time.resetReaderIndex();
            this.getLastLocation(position, dateBuilder.getDate());
            Network network = new Network();
            for (int i = 0; i < length; ++i) {
                String mac = String.format("%02x:%02x:%02x:%02x:%02x:%02x", buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                network.addWifiAccessPoint(WifiAccessPoint.from(mac, buf.readUnsignedByte()));
            }
            int cellCount = buf.readUnsignedByte();
            int mcc = buf.readUnsignedShort();
            short mnc = buf.readUnsignedByte();
            for (int i = 0; i < cellCount; ++i) {
                network.addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedByte()));
            }
            position.setNetwork(network);
            ByteBuf content = Unpooled.buffer();
            content.writeBytes(time);
            this.sendResponse(channel, length, type, content);
            return position;
        }
        return null;
    }
}

