/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.OffsetLimitTokenFilter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.QueryTermScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.lucene.search.highlight.WeightedSpanTermExtractor;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.util.AttributeSource;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.HighlightComponent;
import org.apache.solr.highlight.DefaultEncoder;
import org.apache.solr.highlight.GapFragmenter;
import org.apache.solr.highlight.HtmlFormatter;
import org.apache.solr.highlight.ScoreOrderFragmentsBuilder;
import org.apache.solr.highlight.SimpleBoundaryScanner;
import org.apache.solr.highlight.SimpleFragListBuilder;
import org.apache.solr.highlight.SolrBoundaryScanner;
import org.apache.solr.highlight.SolrEncoder;
import org.apache.solr.highlight.SolrFormatter;
import org.apache.solr.highlight.SolrFragListBuilder;
import org.apache.solr.highlight.SolrFragmenter;
import org.apache.solr.highlight.SolrFragmentsBuilder;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSolrHighlighter
extends SolrHighlighter
implements PluginInfoInitialized {
    private static final String USE_FVH = "hl.useFastVectorHighlighter";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrCore solrCore;
    protected final Map<String, SolrFormatter> formatters = new HashMap<String, SolrFormatter>();
    protected final Map<String, SolrEncoder> encoders = new HashMap<String, SolrEncoder>();
    protected final Map<String, SolrFragmenter> fragmenters = new HashMap<String, SolrFragmenter>();
    protected final Map<String, SolrFragListBuilder> fragListBuilders = new HashMap<String, SolrFragListBuilder>();
    protected final Map<String, SolrFragmentsBuilder> fragmentsBuilders = new HashMap<String, SolrFragmentsBuilder>();
    protected final Map<String, SolrBoundaryScanner> boundaryScanners = new HashMap<String, SolrBoundaryScanner>();

    public DefaultSolrHighlighter(SolrCore solrCore) {
        this.solrCore = solrCore;
    }

    @Override
    public void init(PluginInfo info) {
        this.formatters.clear();
        this.encoders.clear();
        this.fragmenters.clear();
        this.fragListBuilders.clear();
        this.fragmentsBuilders.clear();
        this.boundaryScanners.clear();
        SolrFragmenter frag = this.solrCore.initPlugins(info.getChildren("fragmenter"), this.fragmenters, SolrFragmenter.class, null);
        if (frag == null) {
            frag = new GapFragmenter();
            this.solrCore.initDefaultPlugin(frag, SolrFragmenter.class);
        }
        this.fragmenters.put("", frag);
        this.fragmenters.put(null, frag);
        SolrFormatter fmt = this.solrCore.initPlugins(info.getChildren("formatter"), this.formatters, SolrFormatter.class, null);
        if (fmt == null) {
            fmt = new HtmlFormatter();
            this.solrCore.initDefaultPlugin(fmt, SolrFormatter.class);
        }
        this.formatters.put("", fmt);
        this.formatters.put(null, fmt);
        SolrEncoder enc = this.solrCore.initPlugins(info.getChildren("encoder"), this.encoders, SolrEncoder.class, null);
        if (enc == null) {
            enc = new DefaultEncoder();
            this.solrCore.initDefaultPlugin(enc, SolrEncoder.class);
        }
        this.encoders.put("", enc);
        this.encoders.put(null, enc);
        SolrFragListBuilder fragListBuilder = this.solrCore.initPlugins(info.getChildren("fragListBuilder"), this.fragListBuilders, SolrFragListBuilder.class, null);
        if (fragListBuilder == null) {
            fragListBuilder = new SimpleFragListBuilder();
            this.solrCore.initDefaultPlugin(fragListBuilder, SolrFragListBuilder.class);
        }
        this.fragListBuilders.put("", fragListBuilder);
        this.fragListBuilders.put(null, fragListBuilder);
        SolrFragmentsBuilder fragsBuilder = this.solrCore.initPlugins(info.getChildren("fragmentsBuilder"), this.fragmentsBuilders, SolrFragmentsBuilder.class, null);
        if (fragsBuilder == null) {
            fragsBuilder = new ScoreOrderFragmentsBuilder();
            this.solrCore.initDefaultPlugin(fragsBuilder, SolrFragmentsBuilder.class);
        }
        this.fragmentsBuilders.put("", fragsBuilder);
        this.fragmentsBuilders.put(null, fragsBuilder);
        SolrBoundaryScanner boundaryScanner = this.solrCore.initPlugins(info.getChildren("boundaryScanner"), this.boundaryScanners, SolrBoundaryScanner.class, null);
        if (boundaryScanner == null) {
            boundaryScanner = new SimpleBoundaryScanner();
            this.solrCore.initDefaultPlugin(boundaryScanner, SolrBoundaryScanner.class);
        }
        this.boundaryScanners.put("", boundaryScanner);
        this.boundaryScanners.put(null, boundaryScanner);
    }

    protected Highlighter getPhraseHighlighter(Query query, String fieldName, SolrQueryRequest request, TokenStream tokenStream) throws IOException {
        SolrParams params = request.getParams();
        Highlighter highlighter = new Highlighter(this.getFormatter(fieldName, params), this.getEncoder(fieldName, params), (Scorer)this.getSpanQueryScorer(query, fieldName, tokenStream, request));
        highlighter.setTextFragmenter(this.getFragmenter(fieldName, params));
        return highlighter;
    }

    protected Highlighter getHighlighter(Query query, String fieldName, SolrQueryRequest request) {
        SolrParams params = request.getParams();
        Highlighter highlighter = new Highlighter(this.getFormatter(fieldName, params), this.getEncoder(fieldName, params), this.getQueryScorer(query, fieldName, request));
        highlighter.setTextFragmenter(this.getFragmenter(fieldName, params));
        return highlighter;
    }

    protected QueryScorer getSpanQueryScorer(Query query, String fieldName, TokenStream tokenStream, SolrQueryRequest request) {
        QueryScorer scorer = new QueryScorer(query, request.getParams().getFieldBool(fieldName, "hl.requireFieldMatch", false) ? fieldName : null){

            protected WeightedSpanTermExtractor newTermExtractor(String defaultField) {
                return new CustomSpanTermExtractor(defaultField);
            }
        };
        scorer.setExpandMultiTermQuery(request.getParams().getBool("hl.highlightMultiTerm", true));
        boolean defaultPayloads = true;
        try {
            Terms terms = request.getSearcher().getSlowAtomicReader().terms(fieldName);
            if (terms != null) {
                defaultPayloads = terms.hasPayloads();
            }
        }
        catch (IOException e) {
            log.error("Couldn't check for existence of payloads", (Throwable)e);
        }
        scorer.setUsePayloads(request.getParams().getFieldBool(fieldName, "hl.payloads", defaultPayloads));
        return scorer;
    }

    protected Scorer getQueryScorer(Query query, String fieldName, SolrQueryRequest request) {
        boolean reqFieldMatch = request.getParams().getFieldBool(fieldName, "hl.requireFieldMatch", false);
        if (reqFieldMatch) {
            return new QueryTermScorer(query, (IndexReader)request.getSearcher().getIndexReader(), fieldName);
        }
        return new QueryTermScorer(query);
    }

    protected int getMaxSnippets(String fieldName, SolrParams params) {
        return params.getFieldInt(fieldName, "hl.snippets", 1);
    }

    protected boolean isMergeContiguousFragments(String fieldName, SolrParams params) {
        return params.getFieldBool(fieldName, "hl.mergeContiguous", false);
    }

    protected Formatter getFormatter(String fieldName, SolrParams params) {
        String str = params.getFieldParam(fieldName, "hl.formatter");
        SolrFormatter formatter = this.formatters.get(str);
        if (formatter == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown formatter: " + str);
        }
        return formatter.getFormatter(fieldName, params);
    }

    protected Encoder getEncoder(String fieldName, SolrParams params) {
        String str = params.getFieldParam(fieldName, "hl.encoder");
        SolrEncoder encoder = this.encoders.get(str);
        if (encoder == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown encoder: " + str);
        }
        return encoder.getEncoder(fieldName, params);
    }

    protected Fragmenter getFragmenter(String fieldName, SolrParams params) {
        String fmt = params.getFieldParam(fieldName, "hl.fragmenter");
        SolrFragmenter frag = this.fragmenters.get(fmt);
        if (frag == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fragmenter: " + fmt);
        }
        return frag.getFragmenter(fieldName, params);
    }

    protected FragListBuilder getFragListBuilder(String fieldName, SolrParams params) {
        String flb = params.getFieldParam(fieldName, "hl.fragListBuilder");
        SolrFragListBuilder solrFlb = this.fragListBuilders.get(flb);
        if (solrFlb == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fragListBuilder: " + flb);
        }
        return solrFlb.getFragListBuilder(params);
    }

    protected FragmentsBuilder getFragmentsBuilder(String fieldName, SolrParams params) {
        BoundaryScanner bs = this.getBoundaryScanner(fieldName, params);
        return this.getSolrFragmentsBuilder(fieldName, params).getFragmentsBuilder(params, bs);
    }

    protected SolrFragmentsBuilder getSolrFragmentsBuilder(String fieldName, SolrParams params) {
        String fb = params.getFieldParam(fieldName, "hl.fragmentsBuilder");
        SolrFragmentsBuilder solrFb = this.fragmentsBuilders.get(fb);
        if (solrFb == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fragmentsBuilder: " + fb);
        }
        return solrFb;
    }

    protected BoundaryScanner getBoundaryScanner(String fieldName, SolrParams params) {
        String bs = params.getFieldParam(fieldName, "hl.boundaryScanner");
        SolrBoundaryScanner solrBs = this.boundaryScanners.get(bs);
        if (solrBs == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown boundaryScanner: " + bs);
        }
        return solrBs.getBoundaryScanner(fieldName, params);
    }

    @Override
    public NamedList<Object> doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] defaultFields) throws IOException {
        SolrReturnFields returnFields;
        SolrIndexSearcher searcher;
        IndexSchema schema;
        SchemaField keyField;
        boolean rewrite;
        SolrParams params = req.getParams();
        if (!this.isHighlightingEnabled(params)) {
            return null;
        }
        boolean bl = rewrite = query != null && (Boolean.valueOf(params.get("hl.usePhraseHighlighter", "true")) == false || Boolean.valueOf(params.get("hl.highlightMultiTerm", "true")) == false);
        if (rewrite) {
            query = query.rewrite((IndexReader)req.getSearcher().getIndexReader());
        }
        if ((keyField = (schema = (searcher = req.getSearcher()).getSchema()).getUniqueKeyField()) == null) {
            return null;
        }
        String[] fieldNames = this.getHighlightFields(query, req, defaultFields);
        Set<String> preFetchFieldNames = this.getDocPrefetchFieldNames(fieldNames, req);
        if (preFetchFieldNames != null) {
            preFetchFieldNames.add(keyField.getName());
            returnFields = new SolrReturnFields(preFetchFieldNames.toArray(new String[0]), req);
        } else {
            returnFields = new SolrReturnFields(new String[0], req);
        }
        FvhContainer fvhContainer = new FvhContainer(null, null);
        TermVectorReusingLeafReader reader = new TermVectorReusingLeafReader(req.getSearcher().getSlowAtomicReader());
        SimpleOrderedMap fragments = new SimpleOrderedMap();
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docs.size(); ++i) {
            int docId = iterator.nextDoc();
            SolrDocument doc = searcher.getDocFetcher().solrDoc(docId, returnFields);
            SimpleOrderedMap docHighlights = new SimpleOrderedMap();
            for (String fieldName : fieldNames) {
                SchemaField schemaField = schema.getFieldOrNull(fieldName);
                Object fieldHighlights = this.doHighlightingOfField(doc, docId, schemaField, fvhContainer, query, (IndexReader)reader, req, params);
                if (fieldHighlights == null) {
                    fieldHighlights = this.alternateField(doc, docId, fieldName, fvhContainer, query, (IndexReader)reader, req);
                }
                if (fieldHighlights == null) continue;
                docHighlights.add(fieldName, fieldHighlights);
            }
            fragments.add(schema.printableUniqueKey(doc), (Object)docHighlights);
        }
        return fragments;
    }

    protected Object doHighlightingOfField(SolrDocument doc, int docId, SchemaField schemaField, FvhContainer fvhContainer, Query query, IndexReader reader, SolrQueryRequest req, SolrParams params) throws IOException {
        Object fieldHighlights;
        if (schemaField == null) {
            fieldHighlights = null;
        } else if (schemaField.getType() instanceof TrieField) {
            fieldHighlights = null;
        } else if (this.useFastVectorHighlighter(params, schemaField)) {
            if (fvhContainer.fieldQuery == null) {
                FastVectorHighlighter fvh = new FastVectorHighlighter(params.getBool("hl.usePhraseHighlighter", true), params.getBool("hl.requireFieldMatch", false)){

                    public FieldQuery getFieldQuery(Query query, IndexReader reader) throws IOException {
                        return new FieldQuery(query, reader, this.phraseHighlight, this.fieldMatch){

                            protected void flatten(Query sourceQuery, IndexReader reader, Collection<Query> flatQueries, float boost) throws IOException {
                                if (sourceQuery instanceof ToParentBlockJoinQuery) {
                                    Query childQuery = ((ToParentBlockJoinQuery)sourceQuery).getChildQuery();
                                    if (childQuery != null) {
                                        this.flatten(childQuery, reader, flatQueries, boost);
                                    }
                                } else {
                                    super.flatten(sourceQuery, reader, flatQueries, boost);
                                }
                            }
                        };
                    }
                };
                fvh.setPhraseLimit(params.getInt("hl.phraseLimit", SolrHighlighter.DEFAULT_PHRASE_LIMIT));
                fvhContainer.fvh = fvh;
                fvhContainer.fieldQuery = fvh.getFieldQuery(query, reader);
            }
            fieldHighlights = this.doHighlightingByFastVectorHighlighter(doc, docId, schemaField, fvhContainer, reader, req);
        } else {
            fieldHighlights = this.doHighlightingByHighlighter(doc, docId, schemaField, query, reader, req);
        }
        return fieldHighlights;
    }

    protected Set<String> getDocPrefetchFieldNames(String[] hlFieldNames, SolrQueryRequest req) {
        HashSet<String> preFetchFieldNames = new HashSet<String>(hlFieldNames.length + 1);
        Collections.addAll(preFetchFieldNames, hlFieldNames);
        for (String hlFieldName : hlFieldNames) {
            String alternateField = req.getParams().getFieldParam(hlFieldName, "hl.alternateField");
            if (alternateField == null) continue;
            preFetchFieldNames.add(alternateField);
        }
        return preFetchFieldNames;
    }

    protected boolean useFastVectorHighlighter(SolrParams params, SchemaField schemaField) {
        boolean termPosOff;
        boolean methodFvh;
        boolean bl = methodFvh = HighlightComponent.HighlightMethod.FAST_VECTOR.getMethodName().equals(params.getFieldParam(schemaField.getName(), "hl.method")) || params.getFieldBool(schemaField.getName(), USE_FVH, false);
        if (!methodFvh) {
            return false;
        }
        boolean bl2 = termPosOff = schemaField.storeTermPositions() && schemaField.storeTermOffsets();
        if (!termPosOff) {
            log.warn("Solr will use the standard Highlighter instead of FastVectorHighlighter because the {} field {}", (Object)"does not store TermVectors with TermPositions and TermOffsets.", (Object)schemaField.getName());
        }
        return termPosOff;
    }

    protected Object doHighlightingByFastVectorHighlighter(SolrDocument doc, int docId, SchemaField schemaField, FvhContainer fvhContainer, IndexReader reader, SolrQueryRequest req) throws IOException {
        SolrParams params = req.getParams();
        String fieldName = schemaField.getName();
        SolrFragmentsBuilder solrFb = this.getSolrFragmentsBuilder(fieldName, params);
        String[] snippets = fvhContainer.fvh.getBestFragments(fvhContainer.fieldQuery, reader, docId, fieldName, params.getFieldInt(fieldName, "hl.fragsize", 100), params.getFieldInt(fieldName, "hl.snippets", 1), this.getFragListBuilder(fieldName, params), this.getFragmentsBuilder(fieldName, params), solrFb.getPreTags(params, fieldName), solrFb.getPostTags(params, fieldName), this.getEncoder(fieldName, params));
        if (snippets != null && snippets.length > 0) {
            return snippets;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doHighlightingByHighlighter(SolrDocument doc, int docId, SchemaField schemaField, Query query, IndexReader reader, SolrQueryRequest req) throws IOException {
        List<String> fieldValues;
        SolrParams params = req.getParams();
        String fieldName = schemaField.getName();
        int mvToExamine = params.getFieldInt(fieldName, "hl.maxMultiValuedToExamine", schemaField.multiValued() ? Integer.MAX_VALUE : 1);
        int mvToMatch = params.getFieldInt(fieldName, "hl.maxMultiValuedToMatch", Integer.MAX_VALUE);
        if (mvToExamine <= 0 || mvToMatch <= 0) {
            return null;
        }
        int maxCharsToAnalyze = params.getFieldInt(fieldName, "hl.maxAnalyzedChars", DEFAULT_MAX_CHARS);
        if (maxCharsToAnalyze < 0) {
            maxCharsToAnalyze = Integer.MAX_VALUE;
        }
        if ((fieldValues = this.getFieldValues(doc, fieldName, mvToExamine, maxCharsToAnalyze, req)).isEmpty()) {
            return null;
        }
        boolean preserveMulti = params.getFieldBool(fieldName, "hl.preserveMulti", false);
        int numFragments = this.getMaxSnippets(fieldName, params);
        boolean mergeContiguousFragments = this.isMergeContiguousFragments(fieldName, params);
        List<Object> frags = new ArrayList<TextFragment>();
        Fields tvFields = schemaField.storeTermOffsets() ? reader.getTermVectors(docId) : null;
        TokenStream tvStream = TokenSources.getTermVectorTokenStreamOrNull((String)fieldName, (Fields)tvFields, (int)(maxCharsToAnalyze - 1));
        try (OffsetWindowTokenFilter tvWindowStream = tvStream != null && fieldValues.size() > 1 ? new OffsetWindowTokenFilter(tvStream) : null;){
            for (String thisText : fieldValues) {
                Highlighter highlighter;
                if (mvToMatch <= 0 || maxCharsToAnalyze <= 0) break;
                Object tstream = tvWindowStream != null ? tvWindowStream.advanceToNextWindowOfLength(thisText.length()) : (tvStream != null ? tvStream : this.createAnalyzerTStream(schemaField, thisText));
                if (params.getFieldBool(fieldName, "hl.usePhraseHighlighter", true)) {
                    Object tempTokenStream = tstream != tvStream ? (maxCharsToAnalyze >= thisText.length() ? new CachingTokenFilter(tstream) : new CachingTokenFilter((TokenStream)new OffsetLimitTokenFilter(tstream, maxCharsToAnalyze))) : tstream;
                    highlighter = this.getPhraseHighlighter(query, fieldName, req, (TokenStream)tempTokenStream);
                    if (tempTokenStream instanceof CachingTokenFilter && ((CachingTokenFilter)tempTokenStream).isCached()) {
                        tstream = tempTokenStream;
                    }
                } else {
                    highlighter = this.getHighlighter(query, fieldName, req);
                }
                highlighter.setMaxDocCharsToAnalyze(maxCharsToAnalyze);
                maxCharsToAnalyze -= thisText.length();
                try {
                    TextFragment[] bestTextFragments;
                    for (TextFragment bestTextFragment : bestTextFragments = highlighter.getBestTextFragments(tstream, thisText, mergeContiguousFragments, numFragments)) {
                        if (bestTextFragment == null || !(bestTextFragment.getScore() > 0.0f) && !preserveMulti) continue;
                        frags.add(bestTextFragment);
                        if (!(bestTextFragment.getScore() > 0.0f)) continue;
                        --mvToMatch;
                    }
                }
                catch (InvalidTokenOffsetsException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                }
            }
        }
        if (frags.size() <= 0) {
            return null;
        }
        if (!preserveMulti) {
            Collections.sort(frags, (arg0, arg1) -> Float.compare(arg1.getScore(), arg0.getScore()));
        }
        if (frags.size() > numFragments && !preserveMulti) {
            frags = frags.subList(0, numFragments);
        }
        return this.getResponseForFragments(frags, req);
    }

    protected List<String> getFieldValues(SolrDocument doc, String fieldName, int maxValues, int maxCharsToAnalyze, SolrQueryRequest req) {
        Collection fieldValues = doc.getFieldValues(fieldName);
        if (fieldValues == null) {
            return Collections.emptyList();
        }
        FieldType fieldType = req.getSchema().getFieldType(fieldName);
        ArrayList<String> result = new ArrayList<String>();
        for (Object value : fieldValues) {
            String strValue = value instanceof IndexableField ? fieldType.toExternal((IndexableField)value) : value.toString();
            result.add(strValue);
            if (--maxValues > 0 && (maxCharsToAnalyze -= strValue.length()) > 0) continue;
            break;
        }
        return result;
    }

    protected Object getResponseForFragments(List<TextFragment> frags, SolrQueryRequest req) {
        ArrayList<String> fragTexts = new ArrayList<String>();
        for (TextFragment fragment : frags) {
            fragTexts.add(fragment.toString());
        }
        return fragTexts.toArray(new String[fragTexts.size()]);
    }

    protected Object alternateField(SolrDocument doc, int docId, String fieldName, FvhContainer fvhContainer, Query query, IndexReader reader, SolrQueryRequest req) throws IOException {
        List<String> listFields;
        IndexSchema schema = req.getSearcher().getSchema();
        SolrParams params = req.getParams();
        String alternateField = params.getFieldParam(fieldName, "hl.alternateField");
        int alternateFieldLen = params.getFieldInt(fieldName, "hl.maxAlternateFieldLength", 0);
        if (alternateField == null || alternateField.length() == 0) {
            return null;
        }
        if (params.getFieldBool(fieldName, "hl.highlightAlternate", true) && !alternateField.equals(fieldName)) {
            Object fieldHighlights = null;
            SchemaField schemaField = schema.getFieldOrNull(alternateField);
            if (schemaField != null) {
                HashMap<String, String> invariants = new HashMap<String, String>();
                invariants.put("f." + alternateField + "." + "hl.snippets", "1");
                invariants.put("f." + alternateField + "." + "hl.fragsize", alternateFieldLen > 0 ? String.valueOf(Math.max(18, alternateFieldLen)) : String.valueOf(Integer.MAX_VALUE));
                SolrParams origParams = req.getParams();
                req.setParams(SolrParams.wrapDefaults((SolrParams)new MapSolrParams(invariants), (SolrParams)origParams));
                fieldHighlights = this.doHighlightingOfField(doc, docId, schemaField, fvhContainer, query, reader, req, params);
                req.setParams(origParams);
                if (fieldHighlights != null) {
                    return fieldHighlights;
                }
            }
        }
        if ((listFields = this.getFieldValues(doc, alternateField, Integer.MAX_VALUE, Integer.MAX_VALUE, req)).isEmpty() && (listFields = this.getFieldValues(doc, fieldName, Integer.MAX_VALUE, Integer.MAX_VALUE, req)).isEmpty()) {
            return null;
        }
        String[] altTexts = listFields.toArray(new String[listFields.size()]);
        Encoder encoder = this.getEncoder(fieldName, params);
        ArrayList<String> altList = new ArrayList<String>();
        int len = 0;
        for (String altText : altTexts) {
            if (alternateFieldLen <= 0) {
                altList.add(encoder.encodeText(altText));
                continue;
            }
            altList.add(len + altText.length() > alternateFieldLen ? encoder.encodeText(altText.substring(0, alternateFieldLen - len)) : encoder.encodeText(altText));
            if ((len += altText.length()) >= alternateFieldLen) break;
        }
        return altList;
    }

    protected TokenStream createAnalyzerTStream(SchemaField schemaField, String docText) throws IOException {
        TokenStream tStream = schemaField.getType().getIndexAnalyzer().tokenStream(schemaField.getName(), docText);
        return new TokenOrderingFilter(tStream, 10);
    }

    static class TermVectorReusingLeafReader
    extends FilterLeafReader {
        private int lastDocId = -1;
        private Fields tvFields;

        public TermVectorReusingLeafReader(LeafReader in) {
            super(in);
        }

        public Fields getTermVectors(int docID) throws IOException {
            if (docID != this.lastDocId) {
                this.lastDocId = docID;
                this.tvFields = this.in.getTermVectors(docID);
            }
            return this.tvFields;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return null;
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }

    static final class OffsetWindowTokenFilter
    extends TokenFilter {
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private int windowStartOffset;
        private int windowEndOffset = -1;
        private boolean windowTokenIncremented = false;
        private boolean inputWasReset = false;
        private AttributeSource.State capturedState;

        OffsetWindowTokenFilter(TokenStream input) {
            super(input);
        }

        OffsetWindowTokenFilter advanceToNextWindowOfLength(int length) {
            this.windowStartOffset = this.windowEndOffset + 1;
            this.windowEndOffset = this.windowStartOffset + length;
            this.windowTokenIncremented = false;
            return this;
        }

        public void reset() throws IOException {
            if (this.windowTokenIncremented) {
                throw new IllegalStateException("This TokenStream does not support being subsequently reset()");
            }
            if (!this.inputWasReset) {
                super.reset();
                this.inputWasReset = true;
            }
        }

        public boolean incrementToken() throws IOException {
            int endOffset;
            int startOffset;
            assert (this.inputWasReset);
            this.windowTokenIncremented = true;
            do {
                if (this.capturedState == null) {
                    if (!this.input.incrementToken()) {
                        return false;
                    }
                } else {
                    this.restoreState(this.capturedState);
                    this.capturedState = null;
                    this.posIncAtt.setPositionIncrement(1);
                }
                startOffset = this.offsetAtt.startOffset();
                endOffset = this.offsetAtt.endOffset();
                if (startOffset < this.windowEndOffset) continue;
                this.capturedState = this.captureState();
                return false;
            } while (startOffset < this.windowStartOffset);
            this.offsetAtt.setOffset(startOffset - this.windowStartOffset, endOffset - this.windowStartOffset);
            return true;
        }
    }

    static class OrderedToken {
        AttributeSource.State state;
        int startOffset;

        OrderedToken() {
        }
    }

    static final class TokenOrderingFilter
    extends TokenFilter {
        private final int windowSize;
        private final LinkedList<OrderedToken> queue = new LinkedList();
        private boolean done = false;
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);

        protected TokenOrderingFilter(TokenStream input, int windowSize) {
            super(input);
            this.windowSize = windowSize;
        }

        public void reset() throws IOException {
            super.reset();
            this.queue.clear();
            this.done = false;
        }

        public boolean incrementToken() throws IOException {
            while (!this.done && this.queue.size() < this.windowSize) {
                if (!this.input.incrementToken()) {
                    this.done = true;
                    break;
                }
                ListIterator<OrderedToken> iter = this.queue.listIterator(this.queue.size());
                while (iter.hasPrevious()) {
                    if (this.offsetAtt.startOffset() < iter.previous().startOffset) continue;
                    iter.next();
                    break;
                }
                OrderedToken ot = new OrderedToken();
                ot.state = this.captureState();
                ot.startOffset = this.offsetAtt.startOffset();
                iter.add(ot);
            }
            if (this.queue.isEmpty()) {
                return false;
            }
            this.restoreState(this.queue.removeFirst().state);
            return true;
        }
    }

    public static class FvhContainer {
        FastVectorHighlighter fvh;
        FieldQuery fieldQuery;

        public FvhContainer(FastVectorHighlighter fvh, FieldQuery fieldQuery) {
            this.fvh = fvh;
            this.fieldQuery = fieldQuery;
        }
    }

    private static class CustomSpanTermExtractor
    extends WeightedSpanTermExtractor {
        public CustomSpanTermExtractor(String defaultField) {
            super(defaultField);
        }

        protected void extract(Query query, float boost, Map<String, WeightedSpanTerm> terms) throws IOException {
            if (query instanceof ToParentBlockJoinQuery) {
                this.extract(((ToParentBlockJoinQuery)query).getChildQuery(), boost, terms);
            } else if (query instanceof ToChildBlockJoinQuery) {
                this.extract(((ToChildBlockJoinQuery)query).getParentQuery(), boost, terms);
            } else {
                super.extract(query, boost, terms);
            }
        }
    }
}

