"use strict";
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadConfiguration = void 0;
const utils_1 = require("./utils");
const config_1 = require("./config");
/**
 * Load the APM configuration.
 *
 * @param argv the `process.argv` arguments
 * @param rootDir The root directory of kibana (where the sources and the `package.json` file are)
 * @param production true for production builds, false otherwise
 */
exports.loadConfiguration = (argv, rootDir, isDistributable) => {
    const configPaths = utils_1.getConfigurationFilePaths(argv);
    const rawConfiguration = utils_1.getConfigFromFiles(configPaths);
    utils_1.applyConfigOverrides(rawConfiguration, argv);
    return new config_1.ApmConfiguration(rootDir, rawConfiguration, isDistributable);
};
