"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var arc_1 = require("./primitives/arc");
var point_1 = require("./styles/point");
function renderPoints(ctx, points, themeStyle, geometryStateStyle) {
    points
        .map(function (point) {
        var x = point.x, y = point.y, color = point.color, pointRadius = point.radius, transform = point.transform, styleOverrides = point.styleOverrides;
        var _a = point_1.buildPointStyles(color, themeStyle, geometryStateStyle, pointRadius, styleOverrides), fill = _a.fill, stroke = _a.stroke, radius = _a.radius;
        var circle = {
            x: x + transform.x,
            y: y,
            radius: radius,
        };
        return [circle, fill, stroke];
    })
        .sort(function (_a, _b) {
        var _c = __read(_a, 1), a = _c[0].radius;
        var _d = __read(_b, 1), b = _d[0].radius;
        return b - a;
    })
        .forEach(function (args) { return arc_1.renderCircle.apply(void 0, __spread([ctx], args)); });
}
exports.renderPoints = renderPoints;
function renderPointGroup(ctx, points, themeStyles, geometryStateStyles) {
    points
        .map(function (point) {
        var x = point.x, y = point.y, color = point.color, pointRadius = point.radius, transform = point.transform, styleOverrides = point.styleOverrides, key = point.seriesIdentifier.key;
        var _a = point_1.buildPointStyles(color, themeStyles[key], geometryStateStyles[key], pointRadius, styleOverrides), fill = _a.fill, stroke = _a.stroke, radius = _a.radius;
        var circle = {
            x: x + transform.x,
            y: y,
            radius: radius,
        };
        return [circle, fill, stroke];
    })
        .sort(function (_a, _b) {
        var _c = __read(_a, 1), a = _c[0].radius;
        var _d = __read(_b, 1), b = _d[0].radius;
        return b - a;
    })
        .forEach(function (args) { return arc_1.renderCircle.apply(void 0, __spread([ctx], args)); });
}
exports.renderPointGroup = renderPointGroup;
//# sourceMappingURL=points.js.map