/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.controller;

import java.awt.Point;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.controller.SelectLocationController;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.net.UriUtil;
import org.jd.gui.view.OpenTypeView;

public class OpenTypeController
implements IndexesChangeListener {
    protected static final int CACHE_MAX_ENTRIES = 100;
    protected API api;
    protected ScheduledExecutorService executor;
    protected Collection<Future<Indexes>> collectionOfFutureIndexes;
    protected Consumer<URI> openCallback;
    protected JFrame mainFrame;
    protected OpenTypeView openTypeView;
    protected SelectLocationController selectLocationController;
    protected long indexesHashCode = 0L;
    protected Map<String, Map<String, Collection>> cache;

    public OpenTypeController(API api, ScheduledExecutorService executor, JFrame mainFrame) {
        this.api = api;
        this.executor = executor;
        this.mainFrame = mainFrame;
        this.openTypeView = new OpenTypeView(api, mainFrame, this::updateList, this::onTypeSelected);
        this.selectLocationController = new SelectLocationController(api, mainFrame);
        this.cache = new LinkedHashMap<String, Map<String, Collection>>(150, 0.7f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Map<String, Collection>> eldest) {
                return this.size() > 100;
            }
        };
    }

    public void show(Collection<Future<Indexes>> collectionOfFutureIndexes, Consumer<URI> openCallback) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        this.openCallback = openCallback;
        long hashCode = collectionOfFutureIndexes.hashCode();
        if (hashCode != this.indexesHashCode) {
            this.updateList(this.openTypeView.getPattern());
            this.indexesHashCode = hashCode;
        }
        this.openTypeView.show();
    }

    protected void updateList(String pattern) {
        int patternLength = pattern.length();
        if (patternLength == 0) {
            this.openTypeView.updateList(Collections.emptyMap());
        } else {
            this.executor.execute(() -> {
                HashMap result;
                block12: {
                    this.openTypeView.showWaitCursor();
                    Pattern regExpPattern = OpenTypeController.createRegExpPattern(pattern);
                    result = new HashMap();
                    try {
                        for (Future<Indexes> futureIndexes : this.collectionOfFutureIndexes) {
                            if (!futureIndexes.isDone()) continue;
                            Indexes indexes = futureIndexes.get();
                            String key = String.valueOf(indexes.hashCode()) + "***" + pattern;
                            Map<String, Collection> matchingEntries = this.cache.get(key);
                            if (matchingEntries != null) {
                                for (Map.Entry<String, Collection> mapEntry : matchingEntries.entrySet()) {
                                    HashSet collection = (HashSet)result.get(mapEntry.getKey());
                                    if (collection == null) {
                                        collection = new HashSet();
                                        result.put(mapEntry.getKey(), collection);
                                    }
                                    collection.addAll(mapEntry.getValue());
                                }
                                continue;
                            }
                            Map<String, Collection> index = indexes.getIndex("typeDeclarations");
                            if (index == null || index.isEmpty()) continue;
                            matchingEntries = new HashMap<String, Collection>();
                            if (patternLength == 1) {
                                OpenTypeController.match(pattern.charAt(0), index, matchingEntries);
                            } else {
                                String lastKey = key.substring(0, patternLength - 1);
                                Map<String, Collection> lastResult = this.cache.get(lastKey);
                                if (lastResult != null) {
                                    OpenTypeController.match(regExpPattern, lastResult, matchingEntries);
                                } else {
                                    OpenTypeController.match(regExpPattern, index, matchingEntries);
                                }
                            }
                            this.cache.put(key, matchingEntries);
                            for (Map.Entry<String, Collection> mapEntry : matchingEntries.entrySet()) {
                                HashSet collection = (HashSet)result.get(mapEntry.getKey());
                                if (collection == null) {
                                    collection = new HashSet();
                                    result.put(mapEntry.getKey(), collection);
                                }
                                collection.addAll(mapEntry.getValue());
                            }
                        }
                    }
                    catch (Exception e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block12;
                        throw new AssertionError();
                    }
                }
                SwingUtilities.invokeLater(() -> {
                    this.openTypeView.hideWaitCursor();
                    this.openTypeView.updateList(result);
                });
            });
        }
    }

    protected static void match(char c, Map<String, Collection> index, Map<String, Collection> result) {
        if (Character.isLowerCase(c)) {
            char upperCase = Character.toUpperCase(c);
            for (Map.Entry<String, Collection> mapEntry : index.entrySet()) {
                char first;
                int lastTypeNameSeparatorIndex;
                String typeName = mapEntry.getKey();
                Collection entries = mapEntry.getValue();
                int lastPackageSeparatorIndex = typeName.lastIndexOf(47) + 1;
                int lastIndex = Math.max(lastPackageSeparatorIndex, lastTypeNameSeparatorIndex = typeName.lastIndexOf(36) + 1);
                if (lastIndex >= typeName.length() || (first = typeName.charAt(lastIndex)) != c && first != upperCase) continue;
                OpenTypeController.add(result, typeName, entries);
            }
        } else {
            for (Map.Entry<String, Collection> mapEntry : index.entrySet()) {
                int lastTypeNameSeparatorIndex;
                String typeName = mapEntry.getKey();
                Collection entries = mapEntry.getValue();
                int lastPackageSeparatorIndex = typeName.lastIndexOf(47) + 1;
                int lastIndex = Math.max(lastPackageSeparatorIndex, lastTypeNameSeparatorIndex = typeName.lastIndexOf(36) + 1);
                if (lastIndex >= typeName.length() || typeName.charAt(lastIndex) != c) continue;
                OpenTypeController.add(result, typeName, entries);
            }
        }
    }

    protected static Pattern createRegExpPattern(String pattern) {
        int patternLength = pattern.length();
        StringBuilder sbPattern = new StringBuilder(patternLength * 4);
        for (int i = 0; i < patternLength; ++i) {
            char c = pattern.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 1) {
                    sbPattern.append(".*");
                }
                sbPattern.append(c);
                continue;
            }
            if (Character.isLowerCase(c)) {
                sbPattern.append('[').append(c).append(Character.toUpperCase(c)).append(']');
                continue;
            }
            if (c == '*') {
                sbPattern.append(".*");
                continue;
            }
            if (c == '?') {
                sbPattern.append(".");
                continue;
            }
            sbPattern.append(c);
        }
        sbPattern.append(".*");
        return Pattern.compile(sbPattern.toString());
    }

    protected static void match(Pattern regExpPattern, Map<String, Collection> index, Map<String, Collection> result) {
        for (Map.Entry<String, Collection> mapEntry : index.entrySet()) {
            int lastTypeNameSeparatorIndex;
            String typeName = mapEntry.getKey();
            Collection entries = mapEntry.getValue();
            int lastPackageSeparatorIndex = typeName.lastIndexOf(47) + 1;
            int lastIndex = Math.max(lastPackageSeparatorIndex, lastTypeNameSeparatorIndex = typeName.lastIndexOf(36) + 1);
            if (!regExpPattern.matcher(typeName.substring(lastIndex)).matches()) continue;
            OpenTypeController.add(result, typeName, entries);
        }
    }

    protected static void add(Map<String, Collection> map, String key, Collection value) {
        HashSet collection = map.get(key);
        if (collection == null) {
            collection = new HashSet();
            map.put(key, collection);
        }
        collection.addAll(value);
    }

    protected void onTypeSelected(Point leftBottom, Collection<Container.Entry> entries, String typeName) {
        if (entries.size() == 1) {
            this.openCallback.accept(UriUtil.createURI(this.api, this.collectionOfFutureIndexes, entries.iterator().next(), null, typeName));
        } else {
            this.selectLocationController.show(new Point(leftBottom.x + 18, leftBottom.y + 2), entries, entry -> this.openCallback.accept(UriUtil.createURI(this.api, this.collectionOfFutureIndexes, entry, null, typeName)), () -> this.openTypeView.focus());
        }
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        if (this.openTypeView.isVisible()) {
            this.collectionOfFutureIndexes = collectionOfFutureIndexes;
            this.updateList(this.openTypeView.getPattern());
        }
    }
}

