import{SDKModel as e,ResourceTreeModel as t,NetworkManager as i}from"../sdk/sdk.js";import{UIString as s,ResourceType as r,ParsedURL as n,EventTarget as o}from"../common/common.js";import{InspectorFrontendHost as c}from"../host/host.js";import{NetworkLogView as a,NetworkPanel as l}from"../network/network.js";import{Panel as u,UIUtils as d,ARIAUtils as h,TreeOutline as S,Widget as y}from"../ui/ui.js";class p extends e.SDKModel{constructor(e){super(e),this._dispatcher=new b(this),this._securityAgent=e.securityAgent(),e.registerSecurityDispatcher(this._dispatcher),this._securityAgent.invoke_enable()}resourceTreeModel(){return this.target().model(t.ResourceTreeModel)}networkManager(){return this.target().model(i.NetworkManager)}static SecurityStateComparator(e,t){const i=m();return(e&&i.get(e)||0)-(t&&i.get(t)||0)}}let g=null;const m=()=>{if(!g){g=new Map;const e=[Protocol.Security.SecurityState.Info,Protocol.Security.SecurityState.InsecureBroken,Protocol.Security.SecurityState.Insecure,Protocol.Security.SecurityState.Neutral,Protocol.Security.SecurityState.Secure,Protocol.Security.SecurityState.Unknown];for(let t=0;t<e.length;t++)g.set(e[t],t+1)}return g};e.SDKModel.register(p,e.Capability.Security,!1);const w={SecurityStateChanged:Symbol("SecurityStateChanged"),VisibleSecurityStateChanged:Symbol("VisibleSecurityStateChanged")},C={[Protocol.Security.SecurityState.Unknown]:ls`The security of this page is unknown.`,[Protocol.Security.SecurityState.Insecure]:ls`This page is not secure.`,[Protocol.Security.SecurityState.Neutral]:ls`This page is not secure.`,[Protocol.Security.SecurityState.Secure]:ls`This page is secure (valid HTTPS).`,[Protocol.Security.SecurityState.InsecureBroken]:ls`This page is not secure (broken HTTPS).`};class f{constructor(e,t,i){this.securityState=e,this.explanations=t,this.summary=i}}class _{constructor(e,t,i,s){this.securityState=e,this.certificateSecurityState=t?new v(t):null,this.safetyTipInfo=i?new x(i):null,this.securityStateIssueIds=s}}class v{constructor(e){this.protocol=e.protocol,this.keyExchange=e.keyExchange,this.keyExchangeGroup=e.keyExchangeGroup||null,this.cipher=e.cipher,this.mac=e.mac||null,this.certificate=e.certificate,this.subjectName=e.subjectName,this.issuer=e.issuer,this.validFrom=e.validFrom,this.validTo=e.validTo,this.certificateNetworkError=e.certificateNetworkError||null,this.certificateHasWeakSignature=e.certificateHasWeakSignature,this.certificateHasSha1Signature=e.certificateHasSha1Signature,this.modernSSL=e.modernSSL,this.obsoleteSslProtocol=e.obsoleteSslProtocol,this.obsoleteSslKeyExchange=e.obsoleteSslKeyExchange,this.obsoleteSslCipher=e.obsoleteSslCipher,this.obsoleteSslSignature=e.obsoleteSslSignature}isCertificateExpiringSoon(){const e=new Date(1e3*this.validTo).getTime();return e<new Date(Date.now()).setHours(48)&&e>Date.now()}getKeyExchangeName(){return this.keyExchangeGroup?this.keyExchange?ls`${this.keyExchange} with ${this.keyExchangeGroup}`:this.keyExchangeGroup:this.keyExchange}getCipherFullName(){return this.mac?ls`${this.cipher} with ${this.mac}`:this.cipher}}class x{constructor(e){this.safetyTipStatus=e.safetyTipStatus,this.safeUrl=e.safeUrl||null}}class k{constructor(e,t,i,s,r=[],n=Protocol.Security.MixedContentType.None,o=[]){this.securityState=e,this.title=t,this.summary=i,this.description=s,this.certificate=r,this.mixedContentType=n,this.recommendations=o}}class b{constructor(e){this._model=e}securityStateChanged({securityState:e,schemeIsCryptographic:t,explanations:i,insecureContentStatus:s,summary:r}){const n=new f(e,i,r||null);this._model.dispatchEventToListeners(w.SecurityStateChanged,n)}visibleSecurityStateChanged({visibleSecurityState:e}){const t=new _(e.securityState,e.certificateSecurityState||null,e.safetyTipInfo||null,e.securityStateIssueIds);this._model.dispatchEventToListeners(w.VisibleSecurityStateChanged,t)}certificateError({eventId:e,errorType:t,requestURL:i}){}}var T=Object.freeze({__proto__:null,SecurityModel:p,Events:w,SummaryMessages:C,PageSecurityState:f,PageVisibleSecurityState:_,CertificateSecurityState:v,SecurityStyleExplanation:k});let I;class P extends u.PanelWithSidebar{constructor(){super("security"),this._mainView=new V(this);const t=document.createElement("span");t.classList.add("title"),t.textContent=s.UIString("Overview"),this._sidebarMainViewElement=new M(t,this._setVisibleView.bind(this,this._mainView),"security-main-view-sidebar-tree-item","lock-icon"),this._sidebarMainViewElement.tooltip=t.textContent,this._sidebarTree=new E(this._sidebarMainViewElement,this.showOrigin.bind(this)),this.panelSidebarElement().appendChild(this._sidebarTree.element),this._lastResponseReceivedForLoaderId=new Map,this._origins=new Map,this._filterRequestCounts=new Map,e.TargetManager.instance().observeModels(p,this),this._visibleView=null,this._eventListeners=[],this._securityModel=null}static instance(e={forceNew:null}){const{forceNew:t}=e;return I&&!t||(I=new P),I}static _instance(){return P.instance()}static createCertificateViewerButtonForOrigin(e,t){const s=d.createTextButton(e,async e=>{e.consume();const s=await i.MultitargetNetworkManager.instance().getCertificate(t);s.length>0&&c.InspectorFrontendHostInstance.showCertificateViewer(s)},"origin-button");return h.markAsButton(s),s}static createCertificateViewerButtonForCert(e,t){const i=d.createTextButton(e,e=>{e.consume(),c.InspectorFrontendHostInstance.showCertificateViewer(t)},"origin-button");return h.markAsButton(i),i}static createHighlightedUrl(e,t){const i=e.indexOf("://");if(-1===i){const t=document.createElement("span");return t.textContent=e,t}const s=document.createElement("span"),r=e.substr(0,i),n=e.substr(i+"://".length);return s.createChild("span","url-scheme-"+t).textContent=r,s.createChild("span","url-scheme-separator").textContent="://",s.createChild("span").textContent=n,s}_updateSecurityState(e,t,i){this._sidebarMainViewElement.setSecurityState(e),this._mainView.updateSecurityState(e,t,i)}_onSecurityStateChanged(e){const t=e.data,i=t.securityState,s=t.explanations,r=t.summary;this._updateSecurityState(i,s,r)}_updateVisibleSecurityState(e){this._sidebarMainViewElement.setSecurityState(e.securityState),this._mainView.updateVisibleSecurityState(e)}_onVisibleSecurityStateChanged(e){const t=e.data;this._updateVisibleSecurityState(t)}selectAndSwitchToMainView(){this._sidebarMainViewElement.select(!0)}showOrigin(e){const t=this._origins.get(e);t&&(t.originView||(t.originView=new N(this,e,t)),this._setVisibleView(t.originView))}wasShown(){super.wasShown(),this._visibleView||this.selectAndSwitchToMainView()}focus(){this._sidebarTree.focus()}_setVisibleView(e){this._visibleView!==e&&(this._visibleView&&this._visibleView.detach(),this._visibleView=e,e&&this.splitWidget().setMainWidget(e))}_onResponseReceived(e){const t=e.data.request;t.resourceType()===r.resourceTypes.Document&&this._lastResponseReceivedForLoaderId.set(t.loaderId,t)}_processRequest(e){const t=n.ParsedURL.extractOrigin(e.url());if(!t)return;let i=e.securityState();e.mixedContentType!==Protocol.Security.MixedContentType.Blockable&&e.mixedContentType!==Protocol.Security.MixedContentType.OptionallyBlockable||(i=Protocol.Security.SecurityState.Insecure);const s=this._origins.get(t);if(s){const r=s.securityState;if(s.securityState=this._securityStateMin(r,i),r!==s.securityState){const r=e.securityDetails();r&&(s.securityDetails=r),this._sidebarTree.updateOrigin(t,i),s.originView&&s.originView.setSecurityState(i)}}else{const s={securityState:i,securityDetails:e.securityDetails(),loadedFromCache:e.cached(),originView:void 0};this._origins.set(t,s),this._sidebarTree.addOrigin(t,i)}}_onRequestFinished(e){const t=e.data;this._updateFilterRequestCounts(t),this._processRequest(t)}_updateFilterRequestCounts(e){if(e.mixedContentType===Protocol.Security.MixedContentType.None)return;let t=a.MixedContentFilterValues.All;e.wasBlocked()?t=a.MixedContentFilterValues.Blocked:e.mixedContentType===Protocol.Security.MixedContentType.Blockable?t=a.MixedContentFilterValues.BlockOverridden:e.mixedContentType===Protocol.Security.MixedContentType.OptionallyBlockable&&(t=a.MixedContentFilterValues.Displayed);const i=this._filterRequestCounts.get(t);i?this._filterRequestCounts.set(t,i+1):this._filterRequestCounts.set(t,1),this._mainView.refreshExplanations()}filterRequestCount(e){return this._filterRequestCounts.get(e)||0}_securityStateMin(e,t){return p.SecurityStateComparator(e,t)<0?e:t}modelAdded(e){if(this._securityModel)return;this._securityModel=e;const s=e.resourceTreeModel(),r=e.networkManager();this._eventListeners=[e.addEventListener(w.VisibleSecurityStateChanged,this._onVisibleSecurityStateChanged,this),s.addEventListener(t.Events.MainFrameNavigated,this._onMainFrameNavigated,this),s.addEventListener(t.Events.InterstitialShown,this._onInterstitialShown,this),s.addEventListener(t.Events.InterstitialHidden,this._onInterstitialHidden,this),r.addEventListener(i.Events.ResponseReceived,this._onResponseReceived,this),r.addEventListener(i.Events.RequestFinished,this._onRequestFinished,this)],s.isInterstitialShowing()&&this._onInterstitialShown()}modelRemoved(e){this._securityModel===e&&(this._securityModel=null,o.EventTarget.removeEventListeners(this._eventListeners))}_onMainFrameNavigated(e){const t=e.data,i=this._lastResponseReceivedForLoaderId.get(t.loaderId);this.selectAndSwitchToMainView(),this._sidebarTree.clearOrigins(),this._origins.clear(),this._lastResponseReceivedForLoaderId.clear(),this._filterRequestCounts.clear(),this._mainView.refreshExplanations();const s=n.ParsedURL.extractOrigin(i?i.url():t.url);this._sidebarTree.setMainOrigin(s),i&&this._processRequest(i)}_onInterstitialShown(){this.selectAndSwitchToMainView(),this._sidebarTree.toggleOriginsList(!0)}_onInterstitialHidden(){this._sidebarTree.toggleOriginsList(!1)}}class E extends S.TreeOutlineInShadow{constructor(e,t){super(),this.registerRequiredCSS("security/sidebar.css",{enableLegacyPatching:!0}),this.registerRequiredCSS("security/lockIcon.css",{enableLegacyPatching:!0}),this.appendChild(e),this._showOriginInPanel=t,this._mainOrigin=null,this._originGroupTitles=new Map([[L.MainOrigin,ls`Main origin`],[L.NonSecure,ls`Non-secure origins`],[L.Secure,ls`Secure origins`],[L.Unknown,ls`Unknown / canceled`]]),this._originGroups=new Map;for(const e of Object.values(L)){const t=this._createOriginGroupElement(this._originGroupTitles.get(e));this._originGroups.set(e,t),this.appendChild(t)}this._clearOriginGroups();const i=new S.TreeElement(s.UIString("Reload to view details"));i.selectable=!1,i.listItemElement.classList.add("security-main-view-reload-message");this._originGroups.get(L.MainOrigin).appendChild(i),this._elementsByOrigin=new Map}_originGroupTitle(e){return this._originGroupTitles.get(e)}_originGroupElement(e){return this._originGroups.get(e)}_createOriginGroupElement(e){const t=new S.TreeElement(e,!0);return t.selectable=!1,t.setCollapsible(!1),t.expand(),t.listItemElement.classList.add("security-sidebar-origins"),h.setAccessibleName(t.childrenListElement,e),t}toggleOriginsList(e){for(const t of this._originGroups.values())t.hidden=e}addOrigin(e,t){const i=new M(P.createHighlightedUrl(e,t),this._showOriginInPanel.bind(this,e),"security-sidebar-tree-item","security-property");i.tooltip=e,this._elementsByOrigin.set(e,i),this.updateOrigin(e,t)}setMainOrigin(e){this._mainOrigin=e}updateOrigin(e,t){const i=this._elementsByOrigin.get(e);let s;if(i.setSecurityState(t),e===this._mainOrigin)s=this._originGroups.get(L.MainOrigin),t===Protocol.Security.SecurityState.Secure?s.title=ls`Main origin (secure)`:s.title=ls`Main origin (non-secure)`,h.setAccessibleName(s.childrenListElement,s.title);else switch(t){case Protocol.Security.SecurityState.Secure:s=this._originGroupElement(L.Secure);break;case Protocol.Security.SecurityState.Unknown:s=this._originGroupElement(L.Unknown);break;default:s=this._originGroupElement(L.NonSecure)}const r=i.parent;r!==s&&(r&&(r.removeChild(i),0===r.childCount()&&(r.hidden=!0)),s.appendChild(i),s.hidden=!1)}_clearOriginGroups(){for(const e of this._originGroups.values())e.removeChildren(),e.hidden=!0;const e=this._originGroupElement(L.MainOrigin);e.title=this._originGroupTitle(L.MainOrigin),e.hidden=!1}clearOrigins(){this._clearOriginGroups(),this._elementsByOrigin.clear()}}const L={MainOrigin:Symbol("MainOrigin"),NonSecure:Symbol("NonSecure"),Secure:Symbol("Secure"),Unknown:Symbol("Unknown")};class M extends S.TreeElement{constructor(e,t,i,s){super("",!1),this._selectCallback=t,this._cssPrefix=s,this.listItemElement.classList.add(i),this._iconElement=this.listItemElement.createChild("div","icon"),this._iconElement.classList.add(this._cssPrefix),this.listItemElement.appendChild(e),this._securityState=null,this.setSecurityState(Protocol.Security.SecurityState.Unknown)}static SecurityStateComparator(e,t){return p.SecurityStateComparator(e.securityState(),t.securityState())}setSecurityState(e){this._securityState&&this._iconElement.classList.remove(this._cssPrefix+"-"+this._securityState),this._securityState=e,this._iconElement.classList.add(this._cssPrefix+"-"+e)}securityState(){return this._securityState}onselect(){return this._selectCallback(),!0}}class V extends y.VBox{constructor(e){super(!0),this.registerRequiredCSS("security/mainView.css",{enableLegacyPatching:!0}),this.registerRequiredCSS("security/lockIcon.css",{enableLegacyPatching:!0}),this.setMinimumSize(200,100),this.contentElement.classList.add("security-main-view"),this._panel=e,this._summarySection=this.contentElement.createChild("div","security-summary"),this._securityExplanationsMain=this.contentElement.createChild("div","security-explanation-list security-explanations-main"),this._securityExplanationsExtra=this.contentElement.createChild("div","security-explanation-list security-explanations-extra");const t=this._summarySection.createChild("div","security-summary-section-title");t.textContent=ls`Security overview`,h.markAsHeading(t,1);const i=this._summarySection.createChild("div","lock-spectrum");this._lockSpectrum=new Map([[Protocol.Security.SecurityState.Secure,i.createChild("div","lock-icon lock-icon-secure")],[Protocol.Security.SecurityState.Neutral,i.createChild("div","lock-icon lock-icon-neutral")],[Protocol.Security.SecurityState.Insecure,i.createChild("div","lock-icon lock-icon-insecure")]]),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Secure).title=s.UIString("Secure"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Neutral).title=s.UIString("Info"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).title=s.UIString("Not secure"),this._summarySection.createChild("div","triangle-pointer-container").createChild("div","triangle-pointer-wrapper").createChild("div","triangle-pointer"),this._summaryText=this._summarySection.createChild("div","security-summary-text"),h.markAsHeading(this._summaryText,2),this._explanations=null,this._securityState=null}getLockSpectrumDiv(e){const t=this._lockSpectrum.get(e);if(!t)throw new Error("Invalid argument: "+e);return t}_addExplanation(e,t){const i=e.createChild("div","security-explanation");i.classList.add("security-explanation-"+t.securityState),i.createChild("div","security-property").classList.add("security-property-"+t.securityState);const r=i.createChild("div","security-explanation-text"),n=r.createChild("div","security-explanation-title");if(t.title?(n.createChild("span").textContent=t.title+" - ",n.createChild("span","security-explanation-title-"+t.securityState).textContent=t.summary):n.textContent=t.summary,r.createChild("div").textContent=t.description,t.certificate.length&&r.appendChild(P.createCertificateViewerButtonForCert(s.UIString("View certificate"),t.certificate)),t.recommendations&&t.recommendations.length){const e=r.createChild("ul","security-explanation-recommendations");for(const i of t.recommendations)e.createChild("li").textContent=i}return r}updateSecurityState(e,t,i){this._summarySection.classList.remove("security-summary-"+this._securityState),this._securityState=e,this._summarySection.classList.add("security-summary-"+this._securityState);const r=new Map([[Protocol.Security.SecurityState.Unknown,ls`The security of this page is unknown.`],[Protocol.Security.SecurityState.Insecure,ls`This page is not secure.`],[Protocol.Security.SecurityState.Neutral,ls`This page is not secure.`],[Protocol.Security.SecurityState.Secure,ls`This page is secure (valid HTTPS).`],[Protocol.Security.SecurityState.InsecureBroken,ls`This page is not secure (broken HTTPS).`]]);this._securityState===Protocol.Security.SecurityState.Insecure?(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.add("lock-icon-insecure"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.remove("lock-icon-insecure-broken"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).title=s.UIString("Not secure")):this._securityState===Protocol.Security.SecurityState.InsecureBroken&&(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.add("lock-icon-insecure-broken"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.remove("lock-icon-insecure"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).title=s.UIString("Not secure (broken)")),this._summaryText.textContent=i||r.get(this._securityState)||"",this._explanations=t,this.refreshExplanations()}updateVisibleSecurityState(e){this._summarySection.classList.remove("security-summary-"+this._securityState),this._securityState=e.securityState,this._summarySection.classList.add("security-summary-"+this._securityState),this._securityState===Protocol.Security.SecurityState.Insecure?(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.add("lock-icon-insecure"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.remove("lock-icon-insecure-broken"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).title=ls`Not secure`):this._securityState===Protocol.Security.SecurityState.InsecureBroken&&(this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.add("lock-icon-insecure-broken"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).classList.remove("lock-icon-insecure"),this.getLockSpectrumDiv(Protocol.Security.SecurityState.Insecure).title=ls`Not secure (broken)`);const{summary:t,explanations:i}=this._getSecuritySummaryAndExplanations(e);this._summaryText.textContent=t||C[this._securityState],this._explanations=this._orderExplanations(i),this.refreshExplanations()}_getSecuritySummaryAndExplanations(e){const{securityState:t,securityStateIssueIds:i}=e;let s;const r=[];if(s=this._explainSafetyTipSecurity(e,s,r),i.includes("malicious-content"))s=ls`This page is dangerous (flagged by Google Safe Browsing).`,r.unshift(new k(Protocol.Security.SecurityState.Insecure,void 0,ls`Flagged by Google Safe Browsing`,ls`To check this page's status, visit g.co/safebrowsingstatus.`));else{if(i.includes("is-error-page")&&(null===e.certificateSecurityState||null===e.certificateSecurityState.certificateNetworkError))return s=ls`This is an error page.`,{summary:s,explanations:r};t===Protocol.Security.SecurityState.InsecureBroken&&i.includes("scheme-is-not-cryptographic")&&(s=s||ls`This page is insecure (unencrypted HTTP).`,i.includes("insecure-input-events")&&r.push(new k(Protocol.Security.SecurityState.Insecure,void 0,ls`Form field edited on a non-secure page`,ls`Data was entered in a field on a non-secure page. A warning has been added to the URL bar.`)))}return i.includes("scheme-is-not-cryptographic")?(t!==Protocol.Security.SecurityState.Neutral||i.includes("insecure-origin")||(s=ls`This page has a non-HTTPS secure origin.`),{summary:s,explanations:r}):(this._explainCertificateSecurity(e,r),this._explainConnectionSecurity(e,r),this._explainContentSecurity(e,r),{summary:s,explanations:r})}_explainSafetyTipSecurity(e,t,i){const{securityStateIssueIds:s,safetyTipInfo:r}=e,n=[];return s.includes("bad_reputation")?n.push({summary:ls`This page is suspicious`,description:ls`Chrome has determined that this site could be fake or fraudulent.\n\nIf you believe this is shown in error please visit https://bugs.chromium.org/p/chromium/issues/entry?template=Safety+Tips+Appeals.`}):s.includes("lookalike")&&r&&r.safeUrl&&n.push({summary:ls`Possible spoofing URL`,description:ls`This site's hostname looks similar to ${new URL(r.safeUrl).hostname}. Attackers sometimes mimic sites by making small, hard-to-see changes to the domain name.\n\nIf you believe this is shown in error please visit https://bugs.chromium.org/p/chromium/issues/entry?template=Safety+Tips+Appeals.`}),n.length>0&&(t=t||ls`This page is suspicious (flagged by Chrome).`,i.push(new k(Protocol.Security.SecurityState.Insecure,void 0,n[0].summary,n[0].description))),t}_explainCertificateSecurity(e,t){const{certificateSecurityState:i,securityStateIssueIds:s}=e,r=ls`Certificate`;if(i&&i.certificateHasSha1Signature){const e=ls`insecure (SHA-1)`,s=ls`The certificate chain for this site contains a certificate signed using SHA-1.`;i.certificateHasWeakSignature?t.push(new k(Protocol.Security.SecurityState.Insecure,r,e,s,i.certificate,Protocol.Security.MixedContentType.None)):t.push(new k(Protocol.Security.SecurityState.Neutral,r,e,s,i.certificate,Protocol.Security.MixedContentType.None))}i&&s.includes("cert-missing-subject-alt-name")&&t.push(new k(Protocol.Security.SecurityState.Insecure,r,ls`Subject Alternative Name missing`,ls`The certificate for this site does not contain a Subject Alternative Name extension containing a domain name or IP address.`,i.certificate,Protocol.Security.MixedContentType.None)),i&&null!==i.certificateNetworkError?t.push(new k(Protocol.Security.SecurityState.Insecure,r,ls`missing`,ls`This site is missing a valid, trusted certificate (${i.certificateNetworkError}).`,i.certificate,Protocol.Security.MixedContentType.None)):i&&!i.certificateHasSha1Signature&&t.push(new k(Protocol.Security.SecurityState.Secure,r,ls`valid and trusted`,ls`The connection to this site is using a valid, trusted server certificate issued by ${i.issuer}.`,i.certificate,Protocol.Security.MixedContentType.None)),s.includes("pkp-bypassed")&&t.push(new k(Protocol.Security.SecurityState.Info,r,ls`Public-Key-Pinning bypassed`,ls`Public-Key-Pinning was bypassed by a local root certificate.`)),i&&i.isCertificateExpiringSoon()&&t.push(new k(Protocol.Security.SecurityState.Info,void 0,ls`Certificate expires soon`,ls`The certificate for this site expires in less than 48 hours and needs to be renewed.`))}_explainConnectionSecurity(e,t){const i=e.certificateSecurityState;if(!i)return;const s=ls`Connection`;if(i.modernSSL)return void t.push(new k(Protocol.Security.SecurityState.Secure,s,ls`secure connection settings`,ls`The connection to this site is encrypted and authenticated using ${i.protocol}, ${i.getKeyExchangeName()}, and ${i.getCipherFullName()}.`));const r=[];i.obsoleteSslProtocol&&r.push(ls`${i.protocol} is obsolete. Enable TLS 1.2 or later.`),i.obsoleteSslKeyExchange&&r.push(ls`RSA key exchange is obsolete. Enable an ECDHE-based cipher suite.`),i.obsoleteSslCipher&&r.push(ls`${i.cipher} is obsolete. Enable an AES-GCM-based cipher suite.`),i.obsoleteSslSignature&&r.push(ls`The server signature uses SHA-1, which is obsolete. Enable a SHA-2 signature algorithm instead. (Note this is different from the signature in the certificate.)`),t.push(new k(Protocol.Security.SecurityState.Info,s,ls`obsolete connection settings`,ls`The connection to this site is encrypted and authenticated using ${i.protocol}, ${i.getKeyExchangeName()}, and ${i.getCipherFullName()}.`,void 0,void 0,r))}_explainContentSecurity(e,t){let i=!0;const s=ls`Resources`,r=e.securityStateIssueIds;r.includes("ran-mixed-content")&&(i=!1,t.push(new k(Protocol.Security.SecurityState.Insecure,s,ls`active mixed content`,ls`You have recently allowed non-secure content (such as scripts or iframes) to run on this site.`,[],Protocol.Security.MixedContentType.Blockable))),r.includes("displayed-mixed-content")&&(i=!1,t.push(new k(Protocol.Security.SecurityState.Neutral,s,ls`mixed content`,ls`This page includes HTTP resources.`,[],Protocol.Security.MixedContentType.OptionallyBlockable))),r.includes("contained-mixed-form")&&(i=!1,t.push(new k(Protocol.Security.SecurityState.Neutral,s,ls`non-secure form`,ls`This page includes a form with a non-secure "action" attribute.`))),null!==e.certificateSecurityState&&null!==e.certificateSecurityState.certificateNetworkError||(r.includes("ran-content-with-cert-error")&&(i=!1,t.push(new k(Protocol.Security.SecurityState.Insecure,s,ls`active content with certificate errors`,ls`You have recently allowed content loaded with certificate errors (such as scripts or iframes) to run on this site.`))),r.includes("displayed-content-with-cert-errors")&&(i=!1,t.push(new k(Protocol.Security.SecurityState.Neutral,s,ls`content with certificate errors`,ls`This page includes resources that were loaded with certificate errors.`)))),i&&(r.includes("scheme-is-not-cryptographic")||t.push(new k(Protocol.Security.SecurityState.Secure,s,ls`all served securely`,ls`All resources on this page are served securely.`)))}_orderExplanations(e){if(0===e.length)return e;const t=[Protocol.Security.SecurityState.Insecure,Protocol.Security.SecurityState.Neutral,Protocol.Security.SecurityState.Secure,Protocol.Security.SecurityState.Info],i=[];for(const s of t)i.push(...e.filter(e=>e.securityState===s));return i}refreshExplanations(){if(this._securityExplanationsMain.removeChildren(),this._securityExplanationsExtra.removeChildren(),this._explanations){for(const e of this._explanations)if(e.securityState===Protocol.Security.SecurityState.Info)this._addExplanation(this._securityExplanationsExtra,e);else switch(e.mixedContentType){case Protocol.Security.MixedContentType.Blockable:this._addMixedContentExplanation(this._securityExplanationsMain,e,a.MixedContentFilterValues.BlockOverridden);break;case Protocol.Security.MixedContentType.OptionallyBlockable:this._addMixedContentExplanation(this._securityExplanationsMain,e,a.MixedContentFilterValues.Displayed);break;default:this._addExplanation(this._securityExplanationsMain,e)}if(this._panel.filterRequestCount(a.MixedContentFilterValues.Blocked)>0){const e={securityState:Protocol.Security.SecurityState.Info,summary:s.UIString("Blocked mixed content"),description:s.UIString("Your page requested non-secure resources that were blocked."),mixedContentType:Protocol.Security.MixedContentType.Blockable,certificate:[],title:""};this._addMixedContentExplanation(this._securityExplanationsMain,e,a.MixedContentFilterValues.Blocked)}}}_addMixedContentExplanation(e,t,i){const r=this._addExplanation(e,t),n=this._panel.filterRequestCount(i);if(!n){return void(r.createChild("div","security-mixed-content").textContent=s.UIString("Reload the page to record requests for HTTP resources."))}const o=r.createChild("div","security-mixed-content devtools-link");h.markAsLink(o),o.tabIndex=0,o.textContent=1===n?s.UIString("View %d request in Network Panel",n):s.UIString("View %d requests in Network Panel",n),o.addEventListener("click",this.showNetworkFilter.bind(this,i)),o.addEventListener("keydown",e=>{isEnterKey(e)&&this.showNetworkFilter(i,e)})}showNetworkFilter(e,t){t.consume(),l.NetworkPanel.revealAndFilter([{filterType:a.FilterType.MixedContent,filterValue:e}])}}class N extends y.VBox{constructor(e,t,i){super(),this._panel=e,this.setMinimumSize(200,100),this.element.classList.add("security-origin-view"),this.registerRequiredCSS("security/originView.css",{enableLegacyPatching:!0}),this.registerRequiredCSS("security/lockIcon.css",{enableLegacyPatching:!0});const r=this.element.createChild("div","title-section"),o=r.createChild("div","title-section-header");o.textContent=ls`Origin`,h.markAsHeading(o,1);const c=r.createChild("div","origin-display");this._originLockIcon=c.createChild("span","security-property"),this._originLockIcon.classList.add("security-property-"+i.securityState),c.appendChild(P.createHighlightedUrl(t,i.securityState));const u=r.createChild("div","view-network-button"),S=d.createTextButton(ls`View requests in Network Panel`,e=>{e.consume();const i=new n.ParsedURL(t);l.NetworkPanel.revealAndFilter([{filterType:a.FilterType.Domain,filterValue:i.host},{filterType:a.FilterType.Scheme,filterValue:i.scheme}])});if(u.appendChild(S),h.markAsLink(S),i.securityDetails){const e=this.element.createChild("div","origin-view-section"),r=e.createChild("div","origin-view-section-title");r.textContent=ls`Connection`,h.markAsHeading(r,2);let n=new R;e.appendChild(n.element()),n.addRow(s.UIString("Protocol"),i.securityDetails.protocol),i.securityDetails.keyExchange&&n.addRow(s.UIString("Key exchange"),i.securityDetails.keyExchange),i.securityDetails.keyExchangeGroup&&n.addRow(s.UIString("Key exchange group"),i.securityDetails.keyExchangeGroup),n.addRow(s.UIString("Cipher"),i.securityDetails.cipher+(i.securityDetails.mac?" with "+i.securityDetails.mac:""));const o=this.element.createChild("div","origin-view-section"),c=o.createChild("div","origin-view-section-title");c.textContent=ls`Certificate`,h.markAsHeading(c,2);const a=i.securityDetails.signedCertificateTimestampList.length,l=i.securityDetails.certificateTransparencyCompliance;let u;if(a||l!==Protocol.Network.CertificateTransparencyCompliance.Unknown){u=this.element.createChild("div","origin-view-section");const e=u.createChild("div","origin-view-section-title");e.textContent=ls`Certificate Transparency`,h.markAsHeading(e,2)}const S=this._createSanDiv(i.securityDetails.sanList),y=new Date(1e3*i.securityDetails.validFrom).toUTCString(),p=new Date(1e3*i.securityDetails.validTo).toUTCString();if(n=new R,o.appendChild(n.element()),n.addRow(s.UIString("Subject"),i.securityDetails.subjectName),n.addRow(s.UIString("SAN"),S),n.addRow(s.UIString("Valid from"),y),n.addRow(s.UIString("Valid until"),p),n.addRow(s.UIString("Issuer"),i.securityDetails.issuer),n.addRow("",P.createCertificateViewerButtonForOrigin(s.UIString("Open full certificate details"),t)),!u)return;const g=new R;g.element().classList.add("sct-summary"),u.appendChild(g.element());for(let e=0;e<a;e++){const t=i.securityDetails.signedCertificateTimestampList[e];g.addRow(s.UIString("SCT"),t.logDescription+" ("+t.origin+", "+t.status+")")}const m=u.createChild("div","sct-details");m.classList.add("hidden");for(let e=0;e<a;e++){const t=new R;m.appendChild(t.element());const r=i.securityDetails.signedCertificateTimestampList[e];t.addRow(s.UIString("Log name"),r.logDescription),t.addRow(s.UIString("Log ID"),r.logId.replace(/(.{2})/g,"$1 ")),t.addRow(s.UIString("Validation status"),r.status),t.addRow(s.UIString("Source"),r.origin),t.addRow(s.UIString("Issued at"),new Date(r.timestamp).toUTCString()),t.addRow(s.UIString("Hash algorithm"),r.hashAlgorithm),t.addRow(s.UIString("Signature algorithm"),r.signatureAlgorithm),t.addRow(s.UIString("Signature data"),r.signatureData.replace(/(.{2})/g,"$1 "))}if(a){const e=d.createTextButton(ls`Show full details`,(function(){let t;const i=!m.classList.contains("hidden");t=i?ls`Show full details`:ls`Hide full details`,e.textContent=t,h.setAccessibleName(e,t),h.setExpanded(e,!i),g.element().classList.toggle("hidden"),m.classList.toggle("hidden")}),"details-toggle");u.appendChild(e)}switch(l){case Protocol.Network.CertificateTransparencyCompliance.Compliant:u.createChild("div","origin-view-section-notes").textContent=s.UIString("This request complies with Chrome's Certificate Transparency policy.");break;case Protocol.Network.CertificateTransparencyCompliance.NotCompliant:u.createChild("div","origin-view-section-notes").textContent=s.UIString("This request does not comply with Chrome's Certificate Transparency policy.");break;case Protocol.Network.CertificateTransparencyCompliance.Unknown:}const w=this.element.createChild("div","origin-view-section origin-view-notes");i.loadedFromCache&&(w.createChild("div").textContent=s.UIString("This response was loaded from cache. Some security details might be missing.")),w.createChild("div").textContent=s.UIString("The security details above are from the first inspected response.")}else if(i.securityState===Protocol.Security.SecurityState.Secure){const e=this.element.createChild("div","origin-view-section"),t=e.createChild("div","origin-view-section-title");t.textContent=ls`Secure`,h.markAsHeading(t,2),e.createChild("div").textContent=ls`This origin is a non-HTTPS secure origin.`}else if(i.securityState!==Protocol.Security.SecurityState.Unknown){const e=this.element.createChild("div","origin-view-section"),t=e.createChild("div","origin-view-section-title");t.textContent=ls`Not secure`,h.markAsHeading(t,2),e.createChild("div").textContent=s.UIString("Your connection to this origin is not secure.")}else{const e=this.element.createChild("div","origin-view-section"),t=e.createChild("div","origin-view-section-title");t.textContent=ls`No security information`,h.markAsHeading(t,2),e.createChild("div").textContent=s.UIString("No security details are available for this origin.")}}_createSanDiv(e){const t=document.createElement("div");if(0===e.length)t.textContent=s.UIString("(n/a)"),t.classList.add("empty-san");else{const s=2,r=e.length>s+1;for(let i=0;i<e.length;i++){const n=t.createChild("span","san-entry");n.textContent=e[i],r&&i>=s&&n.classList.add("truncated-entry")}if(r){function i(){const i=t.classList.contains("truncated-san");let r;i?(t.classList.remove("truncated-san"),r=ls`Show less`):(t.classList.add("truncated-san"),r=ls`Show more (${e.length} total)`),s.textContent=r,h.setAccessibleName(s,r),h.setExpanded(s,i)}const s=d.createTextButton(ls`Show more (${e.length} total)`,i);t.appendChild(s),i()}}return t}setSecurityState(e){for(const e of Array.prototype.slice.call(this._originLockIcon.classList))e.startsWith("security-property-")&&this._originLockIcon.classList.remove(e);this._originLockIcon.classList.add("security-property-"+e)}}class R{constructor(){this._element=document.createElement("table"),this._element.classList.add("details-table")}element(){return this._element}addRow(e,t){const i=this._element.createChild("div","details-table-row");i.createChild("div").textContent=e;const s=i.createChild("div");"string"==typeof t?s.textContent=t:s.appendChild(t)}}var U=Object.freeze({__proto__:null,SecurityPanel:P,SecurityPanelSidebarTree:E,OriginGroup:L,SecurityPanelSidebarTreeElement:M,SecurityMainView:V,SecurityOriginView:N,SecurityDetailsTable:R,OriginState:void 0,Origin:void 0});export{T as SecurityModel,U as SecurityPanel};
