/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.Filter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeVpnConnectionsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Boolean dryRun;
    private ListWithAutoConstructFlag<String> vpnConnectionIds;
    private ListWithAutoConstructFlag<Filter> filters;

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public DescribeVpnConnectionsRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public List<String> getVpnConnectionIds() {
        if (this.vpnConnectionIds == null) {
            this.vpnConnectionIds = new ListWithAutoConstructFlag();
            this.vpnConnectionIds.setAutoConstruct(true);
        }
        return this.vpnConnectionIds;
    }

    public void setVpnConnectionIds(Collection<String> vpnConnectionIds) {
        if (vpnConnectionIds == null) {
            this.vpnConnectionIds = null;
            return;
        }
        ListWithAutoConstructFlag vpnConnectionIdsCopy = new ListWithAutoConstructFlag(vpnConnectionIds.size());
        vpnConnectionIdsCopy.addAll(vpnConnectionIds);
        this.vpnConnectionIds = vpnConnectionIdsCopy;
    }

    public DescribeVpnConnectionsRequest withVpnConnectionIds(String ... vpnConnectionIds) {
        if (this.getVpnConnectionIds() == null) {
            this.setVpnConnectionIds(new ArrayList<String>(vpnConnectionIds.length));
        }
        for (String value : vpnConnectionIds) {
            this.getVpnConnectionIds().add(value);
        }
        return this;
    }

    public DescribeVpnConnectionsRequest withVpnConnectionIds(Collection<String> vpnConnectionIds) {
        if (vpnConnectionIds == null) {
            this.vpnConnectionIds = null;
        } else {
            ListWithAutoConstructFlag vpnConnectionIdsCopy = new ListWithAutoConstructFlag(vpnConnectionIds.size());
            vpnConnectionIdsCopy.addAll(vpnConnectionIds);
            this.vpnConnectionIds = vpnConnectionIdsCopy;
        }
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ListWithAutoConstructFlag();
            this.filters.setAutoConstruct(true);
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
        filtersCopy.addAll(filters);
        this.filters = filtersCopy;
    }

    public DescribeVpnConnectionsRequest withFilters(Filter ... filters) {
        if (this.getFilters() == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter value : filters) {
            this.getFilters().add(value);
        }
        return this;
    }

    public DescribeVpnConnectionsRequest withFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
        } else {
            ListWithAutoConstructFlag filtersCopy = new ListWithAutoConstructFlag(filters.size());
            filtersCopy.addAll(filters);
            this.filters = filtersCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.isDryRun() != null) {
            sb.append("DryRun: " + this.isDryRun() + ",");
        }
        if (this.getVpnConnectionIds() != null) {
            sb.append("VpnConnectionIds: " + this.getVpnConnectionIds() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getVpnConnectionIds() == null ? 0 : ((Object)this.getVpnConnectionIds()).hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : ((Object)this.getFilters()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsRequest)) {
            return false;
        }
        DescribeVpnConnectionsRequest other = (DescribeVpnConnectionsRequest)obj;
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getVpnConnectionIds() == null ^ this.getVpnConnectionIds() == null) {
            return false;
        }
        if (other.getVpnConnectionIds() != null && !((Object)other.getVpnConnectionIds()).equals(this.getVpnConnectionIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || ((Object)other.getFilters()).equals(this.getFilters());
    }
}

