/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class MobilogixProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("[").number("(dddd)-(dd)-(dd) ").number("(dd):(dd):(dd),").number("Td,").number("d+,").expression("[^,]+,").expression("([^,]+),").number("(xx),").number("(d+.d+),").number("(d)").number("(d)").number("(d),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+.?d*),").number("(d+.?d*)").any().compile();

    public MobilogixProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser;
        String sentence = (String)msg;
        String type = sentence.substring(21, 23);
        if (channel != null) {
            String time = sentence.substring(1, 20);
            String response = type.equals("T1") ? String.format("[%s,S1,1]", time) : String.format("[%s,S%c]", time, Character.valueOf(type.charAt(1)));
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        if (!(parser = new Parser(PATTERN, (String)msg)).matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setTime(parser.nextDateTime());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        int status = parser.nextHexInt();
        position.set("ignition", BitUtil.check(status, 2));
        position.set("motion", BitUtil.check(status, 3));
        position.set("status", status);
        position.set("battery", parser.nextDouble());
        position.setValid(parser.nextInt() > 0);
        position.set("rssi", parser.nextInt());
        position.set("sat", parser.nextInt());
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.setCourse(parser.nextDouble());
        return position;
    }
}

