/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class HomtecsProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().expression("([^_]+)").text("_R").number("(x{8}),").number("(dd)(dd)(dd),").number("(dd)(dd)(dd).d+,").number("(d+),").number("(dd)(dd.d+),").expression("([NS]),").number("(ddd)(dd.d+),").expression("([EW]),").number("(d+.?d*)?,").number("(d+.?d*)?,").number("(d),").number("(d+.?d*)?,").number("(d+.?d*)?").compile();

    public HomtecsProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        String id = parser.next();
        String mac = parser.next();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, id, id + "_R" + mac);
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.YMD_HMS));
        position.set("sat", parser.nextInt(0));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        position.setValid(parser.nextInt(0) > 0);
        position.set("hdop", parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        return position;
    }
}

