/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class TimeHandler
extends ChannelInboundHandlerAdapter {
    private final boolean useServerTime;
    private final Set<String> protocols;

    public TimeHandler(Config config) {
        this.useServerTime = config.getString(Keys.TIME_OVERRIDE).equalsIgnoreCase("serverTime");
        String protocolList = Context.getConfig().getString(Keys.TIME_PROTOCOLS);
        this.protocols = protocolList != null ? new HashSet<String>(Arrays.asList(protocolList.split("[, ]"))) : null;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof Position && (this.protocols == null || this.protocols.contains(((BaseProtocolDecoder)ctx.pipeline().get(BaseProtocolDecoder.class)).getProtocolName()))) {
            Position position = (Position)msg;
            if (this.useServerTime) {
                position.setDeviceTime(position.getServerTime());
                position.setFixTime(position.getServerTime());
            } else {
                position.setFixTime(position.getDeviceTime());
            }
        }
        ctx.fireChannelRead(msg);
    }
}

