/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.Map;

public enum TokenBindingKeyParameters {
    RSA2048_PKCS1_5(0),
    RSA2048_PSS(1),
    ECDSAP256(2);

    private final byte keyParameterValue;
    private static final Map<Byte, TokenBindingKeyParameters> MAP;

    private TokenBindingKeyParameters(byte keyParameterValue) {
        this.keyParameterValue = keyParameterValue;
    }

    public static TokenBindingKeyParameters getTokenBindingKeyParameter(byte value) {
        TokenBindingKeyParameters type = MAP.get(value);
        return type;
    }

    public byte getValue() {
        return this.keyParameterValue;
    }

    static {
        MAP = new HashMap<Byte, TokenBindingKeyParameters>();
        for (TokenBindingKeyParameters c : TokenBindingKeyParameters.values()) {
            MAP.put(c.keyParameterValue, c);
        }
    }
}

