/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import java.net.IDN;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.bouncycastle.util.IPAddress;

public class ClientDelegate
extends Delegate {
    private static final int DEFAULT_HTTPS_PORT = 443;
    @Parameter(names={"-connect"}, required=true, description="Who to connect to. Syntax: localhost:4433")
    private String host = null;
    @Parameter(names={"-server_name"}, description="Servername for the SNI extension.")
    private String sniHostname = null;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public void applyDelegate(Config config) {
        URI uri;
        config.setDefaultRunningMode(RunningModeType.CLIENT);
        if (this.host == null) {
            throw new ParameterException("Could not parse provided host: " + this.host);
        }
        String[] split = this.host.split("://");
        if (split.length > 0) {
            this.host = split[split.length - 1];
        }
        this.host = IDN.toASCII(this.host);
        try {
            uri = new URI("my://" + this.host);
        }
        catch (URISyntaxException ex) {
            throw new ParameterException("Could not parse host '" + this.host + "'", (Throwable)ex);
        }
        if (uri.getHost() == null) {
            throw new ParameterException("Provided host seems invalid:" + this.host);
        }
        OutboundConnection con = config.getDefaultClientConnection();
        if (con == null) {
            con = new OutboundConnection();
            config.setDefaultClientConnection(con);
        }
        if (uri.getPort() <= 0) {
            con.setPort(443);
        } else {
            con.setPort(uri.getPort());
        }
        if (IPAddress.isValid((String)uri.getHost())) {
            con.setIp(uri.getHost());
            if (this.sniHostname != null) {
                con.setHostname(this.sniHostname);
            } else {
                con.setHostname(this.getHostForIp(uri.getHost()));
            }
        } else {
            if (this.sniHostname != null) {
                con.setHostname(this.sniHostname);
            } else {
                con.setHostname(uri.getHost());
            }
            con.setIp(this.getIpForHost(uri.getHost()));
        }
    }

    private String getIpForHost(String host) {
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException ex) {
            LOGGER.warn("Could not resolve host \"" + host + "\" returning anyways", (Throwable)ex);
            return host;
        }
    }

    private String getHostForIp(String ip) {
        try {
            return InetAddress.getByName(ip).getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            LOGGER.warn("Could not perform reverse DNS for \"" + ip + "\"", (Throwable)ex);
            return ip;
        }
    }

    public String getSniHostname() {
        return this.sniHostname;
    }

    public void setSniHostname(String sniHostname) {
        this.sniHostname = sniHostname;
    }
}

