/*
 * Decompiled with CFR 0.152.
 */
package tr.model;

import tr.model.Data;
import tr.model.Item.Item;
import tr.model.action.Action;
import tr.model.action.Recurrence;
import tr.model.project.Project;

public class DataUpgrade2to3 {
    private static int OLD_VERSION = 2;
    private static int NEW_VERSION = 3;

    public static void process(Data data) {
        if (data.version == OLD_VERSION) {
            DataUpgrade2to3.upgrade(data);
            data.version = NEW_VERSION;
        }
    }

    private static void upgrade(Data data) {
        System.out.print("Upgrading data from version " + OLD_VERSION + " to version " + NEW_VERSION + " ... ");
        DataUpgrade2to3.processProjects(data);
        DataUpgrade2to3.processSingleActions(data);
        System.out.println("Done");
    }

    private static void processProjects(Data data) {
        for (Project project : data.getRootProjects().getChildren(Project.class)) {
            DataUpgrade2to3.processProject(project);
        }
    }

    private static void processProject(Project project) {
        for (Item child : project.getChildren()) {
            if (child instanceof Action) {
                DataUpgrade2to3.processAction((Action)child);
                continue;
            }
            if (!(child instanceof Project)) continue;
            DataUpgrade2to3.processProject((Project)child);
        }
    }

    private static void processSingleActions(Data data) {
        for (Action action : data.getRootActions().getChildren(Action.class)) {
            DataUpgrade2to3.processAction(action);
        }
    }

    private static void processAction(Action action) {
        Recurrence recurrence = action.getRecurrence();
        if (recurrence == null) {
            return;
        }
        recurrence.getPeriod().initialise(recurrence.getStartDate());
    }
}

