/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.solr.schema.SchemaField;

public class SortSpec {
    private Sort sort;
    private List<SchemaField> fields;
    private int num = 10;
    private int offset = 0;

    public SortSpec(Sort sort, List<SchemaField> fields, int num, int offset) {
        this.setSortAndFields(sort, fields);
        this.num = num;
        this.offset = offset;
    }

    public SortSpec(Sort sort, List<SchemaField> fields) {
        this.setSortAndFields(sort, fields);
    }

    public SortSpec(Sort sort, SchemaField[] fields, int num, int offset) {
        this.setSortAndFields(sort, Arrays.asList(fields));
        this.num = num;
        this.offset = offset;
    }

    public SortSpec(Sort sort, SchemaField[] fields) {
        this.setSortAndFields(sort, Arrays.asList(fields));
    }

    public void setSortAndFields(Sort s, List<SchemaField> fields) {
        assert (null == s || s.getSort().length == fields.size()) : "SortFields and SchemaFields do not have equal lengths";
        this.sort = s;
        this.fields = Collections.unmodifiableList(fields);
    }

    public static boolean includesScore(Sort sort) {
        if (sort == null) {
            return true;
        }
        for (SortField sf : sort.getSort()) {
            if (sf.getType() != SortField.Type.SCORE) continue;
            return true;
        }
        return false;
    }

    public boolean includesScore() {
        return SortSpec.includesScore(this.sort);
    }

    public Sort getSort() {
        return this.sort;
    }

    public List<SchemaField> getSchemaFields() {
        return this.fields;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getCount() {
        return this.num;
    }

    public void setCount(int count) {
        this.num = count;
    }

    public String toString() {
        return "start=" + this.offset + "&rows=" + this.num + (this.sort == null ? "" : "&sort=" + this.sort);
    }
}

