/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.psi.PyElementVisitor;
import org.jetbrains.annotations.NotNull;

public abstract class PyAnnotator
extends PyElementVisitor {
    private final boolean myTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private AnnotationHolder _holder;

    public AnnotationHolder getHolder() {
        return this._holder;
    }

    public void setHolder(AnnotationHolder holder) {
        this._holder = holder;
    }

    public synchronized void annotateElement(PsiElement psiElement, AnnotationHolder holder) {
        this.setHolder(holder);
        try {
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.setHolder(null);
        }
    }

    protected void markError(@NotNull PsiElement element, @NotNull @InspectionMessage String message) {
        if (element == null) {
            PyAnnotator.$$$reportNull$$$0(0);
        }
        if (message == null) {
            PyAnnotator.$$$reportNull$$$0(1);
        }
        this.getHolder().newAnnotation(HighlightSeverity.ERROR, message).range(element).create();
    }

    protected void addHighlightingAnnotation(@NotNull PsiElement target, @NotNull TextAttributesKey key) {
        if (target == null) {
            PyAnnotator.$$$reportNull$$$0(2);
        }
        if (key == null) {
            PyAnnotator.$$$reportNull$$$0(3);
        }
        this.addHighlightingAnnotation(target, key, HighlightSeverity.INFORMATION);
    }

    protected void addHighlightingAnnotation(@NotNull PsiElement target, @NotNull TextAttributesKey key, @NotNull HighlightSeverity severity) {
        if (target == null) {
            PyAnnotator.$$$reportNull$$$0(4);
        }
        if (key == null) {
            PyAnnotator.$$$reportNull$$$0(5);
        }
        if (severity == null) {
            PyAnnotator.$$$reportNull$$$0(6);
        }
        String message = this.myTestMode ? key.getExternalName() : null;
        HighlightSeverity actualSeverity = this.myTestMode && severity.myVal < HighlightSeverity.INFORMATION.myVal ? HighlightSeverity.INFORMATION : severity;
        (message == null ? this.getHolder().newSilentAnnotation(actualSeverity) : this.getHolder().newAnnotation(actualSeverity, message)).range(target).textAttributes(key).create();
    }

    protected void addHighlightingAnnotation(@NotNull ASTNode target, @NotNull TextAttributesKey key) {
        if (target == null) {
            PyAnnotator.$$$reportNull$$$0(7);
        }
        if (key == null) {
            PyAnnotator.$$$reportNull$$$0(8);
        }
        this.addHighlightingAnnotation(target.getPsi(), key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markError";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addHighlightingAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

