/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.pytestLegacy;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.testing.AbstractPythonLegacyTestRunConfiguration;
import com.jetbrains.python.testing.VFSTestFrameworkListener;
import com.jetbrains.python.testing.pytestLegacy.PyTestCommandLineState;
import com.jetbrains.python.testing.pytestLegacy.PyTestConfigurationEditor;
import com.jetbrains.python.testing.pytestLegacy.PyTestRunConfigurationParams;
import java.util.ArrayList;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTestRunConfiguration
extends AbstractPythonLegacyTestRunConfiguration<PyTestRunConfiguration>
implements PyTestRunConfigurationParams {
    private String myTestToRun = "";
    private String myKeywords = "";
    private String myParams = "";
    private boolean useParam = false;
    private boolean useKeyword = false;
    @NlsSafe
    protected String myTitle = "pytest";
    @NlsSafe
    protected String myPluralTitle = "pytests";
    private static final String TEST_TO_RUN_FIELD = "testToRun";
    private static final String KEYWORDS_FIELD = "keywords";
    private static final String PARAMS_FIELD = "params";

    public PyTestRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    @Override
    protected SettingsEditor<PyTestRunConfiguration> createConfigurationEditor() {
        return new PyTestConfigurationEditor(this.getProject(), this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            PyTestRunConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            PyTestRunConfiguration.$$$reportNull$$$0(1);
        }
        return new PyTestCommandLineState(this, env);
    }

    public String getTestToRun() {
        return this.myTestToRun;
    }

    @Override
    @NotNull
    public String getWorkingDirectorySafe() {
        VirtualFile path;
        String workingDirectoryFromConfig = this.getWorkingDirectory();
        if (StringUtil.isNotEmpty((String)workingDirectoryFromConfig)) {
            String string = workingDirectoryFromConfig;
            if (string == null) {
                PyTestRunConfiguration.$$$reportNull$$$0(2);
            }
            return string;
        }
        String testToRun = this.myTestToRun;
        if (testToRun != null && (path = LocalFileSystem.getInstance().findFileByPath(testToRun)) != null) {
            if (path.isDirectory()) {
                String string = path.getPath();
                if (string == null) {
                    PyTestRunConfiguration.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = path.getParent().getPath();
            if (string == null) {
                PyTestRunConfiguration.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = super.getWorkingDirectorySafe();
        if (string == null) {
            PyTestRunConfiguration.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setTestToRun(String testToRun) {
        this.myTestToRun = testToRun;
    }

    public String getKeywords() {
        if (this.useKeyword) {
            return this.myKeywords;
        }
        return "";
    }

    public void setKeywords(String keywords) {
        this.myKeywords = keywords;
    }

    public void setParams(String params) {
        this.myParams = params;
    }

    public String getParams() {
        if (this.useParam) {
            return this.myParams;
        }
        return "";
    }

    @Override
    public boolean useParam() {
        return this.useParam;
    }

    @Override
    public void useParam(boolean useParam) {
        this.useParam = useParam;
    }

    @Override
    public boolean useKeyword() {
        return this.useKeyword;
    }

    @Override
    public void useKeyword(boolean useKeyword) {
        this.useKeyword = useKeyword;
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            PyTestRunConfiguration.$$$reportNull$$$0(6);
        }
        super.readExternal(element);
        this.myTestToRun = JDOMExternalizerUtil.readField((Element)element, (String)TEST_TO_RUN_FIELD);
        this.myKeywords = JDOMExternalizerUtil.readField((Element)element, (String)KEYWORDS_FIELD);
        this.myParams = JDOMExternalizerUtil.readField((Element)element, (String)PARAMS_FIELD);
        this.useParam = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_PARAM"));
        this.useKeyword = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_KEYWORD"));
    }

    @Override
    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            PyTestRunConfiguration.$$$reportNull$$$0(7);
        }
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)TEST_TO_RUN_FIELD, (String)this.myTestToRun);
        JDOMExternalizerUtil.writeField((Element)element, (String)KEYWORDS_FIELD, (String)this.myKeywords);
        JDOMExternalizerUtil.writeField((Element)element, (String)PARAMS_FIELD, (String)this.myParams);
        JDOMExternalizerUtil.writeField((Element)element, (String)"USE_PARAM", (String)String.valueOf(this.useParam));
        JDOMExternalizerUtil.writeField((Element)element, (String)"USE_KEYWORD", (String)String.valueOf(this.useKeyword));
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        if (StringUtil.isEmptyOrSpaces((String)this.myTestToRun)) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.testing.specify.target.folder.or.script", new Object[0]));
        }
        Sdk sdk = PythonSdkUtil.findSdkByPath(this.getInterpreterPath());
        if (sdk != null && !VFSTestFrameworkListener.getInstance().isTestFrameworkInstalled(sdk, "pytest")) {
            throw new RuntimeConfigurationWarning(PyBundle.message("runcfg.testing.no.test.framework", "pytest"));
        }
    }

    @Override
    public String suggestedName() {
        return PyBundle.message("runcfg.pytest.suggested.name", this.getName());
    }

    @Override
    protected String getTitle() {
        return this.myTitle;
    }

    @Override
    protected String getPluralTitle() {
        return this.myPluralTitle;
    }

    @Override
    @Nullable
    public final String getTestSpec(@NotNull Location location, @NotNull AbstractTestProxy failedTest) {
        int indexOfBrace;
        if (location == null) {
            PyTestRunConfiguration.$$$reportNull$$$0(8);
        }
        if (failedTest == null) {
            PyTestRunConfiguration.$$$reportNull$$$0(9);
        }
        if ((indexOfBrace = failedTest.getName().indexOf(91)) == -1) {
            return super.getTestSpec(location, failedTest);
        }
        ArrayList<String> testNameParts = new ArrayList<String>();
        VirtualFile file = location.getVirtualFile();
        if (file == null) {
            return null;
        }
        String fileName = file.getName();
        testNameParts.add(failedTest.getName().substring(0, indexOfBrace));
        for (AbstractTestProxy test = failedTest.getParent(); test != null && !test.getName().equals(fileName); test = test.getParent()) {
            testNameParts.add(test.getName());
        }
        testNameParts.add(file.getCanonicalPath());
        return StringUtil.join((Collection)Lists.reverse(testNameParts), (String)"::");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/pytestLegacy/PyTestRunConfiguration";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failedTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/pytestLegacy/PyTestRunConfiguration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectorySafe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTestSpec";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

