/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.TimeoutUtil;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import org.jetbrains.annotations.NotNull;

public class PyUpdateProjectSdkAction
extends DumbAwareAction {
    private static final int N_REPEATS = 1;
    private static final int TIMEOUT = 0;
    private static final Logger LOG = Logger.getInstance(PyUpdateProjectSdkAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            PyUpdateProjectSdkAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (int i = 0; i < 1; ++i) {
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    Sdk sdk = PythonSdkUtil.findPythonSdk(module);
                    if (sdk == null) {
                        LOG.info("Skipping module " + module + " as not having a Python SDK");
                        continue;
                    }
                    PythonSdkUpdater.scheduleUpdate(sdk, project);
                    TimeoutUtil.sleep((long)0L);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/python/sdk/PyUpdateProjectSdkAction", "actionPerformed"));
    }
}

