/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ConvertDocstringQuickFix;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySingleQuotedDocstringInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PySingleQuotedDocstringInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PySingleQuotedDocstringInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PySingleQuotedDocstringInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression string) {
            ProblemsHolder holder;
            if (string == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            String stringText = string.getText();
            int length = PyStringLiteralUtil.getPrefixLength(stringText);
            stringText = stringText.substring(length);
            PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)string, PyDocStringOwner.class);
            if (docStringOwner != null && docStringOwner.getDocStringExpression() == string && !stringText.startsWith("\"\"\"") && !stringText.endsWith("\"\"\"") && (holder = this.getHolder()) != null) {
                int quoteCount = 1;
                if (stringText.startsWith("'''") && stringText.endsWith("'''")) {
                    quoteCount = 3;
                }
                TextRange trStart = new TextRange(length, length + quoteCount);
                TextRange trEnd = new TextRange(stringText.length() + length - quoteCount, stringText.length() + length);
                if (string.getStringValue().isEmpty()) {
                    holder.registerProblem((PsiElement)string, PyPsiBundle.message("INSP.message.single.quoted.docstring", new Object[0]), new LocalQuickFix[]{new ConvertDocstringQuickFix()});
                } else {
                    holder.registerProblem((PsiElement)string, trStart, PyPsiBundle.message("INSP.message.single.quoted.docstring", new Object[0]), new LocalQuickFix[]{new ConvertDocstringQuickFix()});
                    holder.registerProblem((PsiElement)string, trEnd, PyPsiBundle.message("INSP.message.single.quoted.docstring", new Object[0]), new LocalQuickFix[]{new ConvertDocstringQuickFix()});
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PySingleQuotedDocstringInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyStringLiteralExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

