/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseQuoteHandler
implements MultiCharQuoteHandler {
    private final char[] ourAutoClosingChars;
    private final TokenSet myPlainStringTokens;

    public BaseQuoteHandler(TokenSet tokenSet, char[] autoClosingChars) {
        this.myPlainStringTokens = tokenSet;
        this.ourAutoClosingChars = autoClosingChars;
        Arrays.sort(this.ourAutoClosingChars);
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        boolean mayBeTripleQuote;
        Document document = iterator.getDocument();
        if (document == null) {
            return false;
        }
        CharSequence text2 = document.getCharsSequence();
        boolean mayBeSingleQuote = offset + 1 >= text2.length() || Arrays.binarySearch(this.ourAutoClosingChars, text2.charAt(offset + 1)) >= 0;
        boolean bl = mayBeTripleQuote = offset + 4 >= text2.length() || Arrays.binarySearch(this.ourAutoClosingChars, text2.charAt(offset + 4)) >= 0;
        if (mayBeTripleQuote && this.isOpeningTripleQuote(iterator, offset)) {
            return true;
        }
        if (mayBeSingleQuote) {
            int start;
            if (this.isOpeningSingleQuote(iterator, offset)) {
                return true;
            }
            if (this.getOpeningQuotesTokens().contains(iterator.getTokenType()) && offset - (start = iterator.getStart()) <= 3 && BaseQuoteHandler.getLiteralStartOffset(text2, start) == offset) {
                return true;
            }
        }
        return false;
    }

    private boolean isOpeningTripleQuote(HighlighterIterator iterator, int offset) {
        CharSequence text2 = iterator.getDocument().getCharsSequence();
        char theQuote = text2.charAt(offset);
        IElementType tokenType = iterator.getTokenType();
        if (this.getOpeningQuotesTokens().contains(tokenType) && offset >= 2 && text2.charAt(offset - 1) == theQuote && text2.charAt(offset - 2) == theQuote && (offset < 3 || text2.charAt(offset - 3) != theQuote)) {
            return BaseQuoteHandler.getLiteralStartOffset(text2, iterator.getStart()) == offset - 2;
        }
        return false;
    }

    private static int getLiteralStartOffset(CharSequence text2, int start) {
        return PyStringLiteralUtil.getPrefixEndOffset(text2, start);
    }

    public boolean hasNonClosedLiteral(Editor editor2, HighlighterIterator iterator, int offset) {
        IElementType tokenType = iterator.getTokenType();
        if (!this.getOpeningQuotesTokens().contains(tokenType)) {
            return false;
        }
        CharSequence chars = iterator.getDocument().getCharsSequence();
        int end = iterator.getEnd();
        if (BaseQuoteHandler.getLiteralStartOffset(chars, iterator.getStart()) >= end - 1) {
            return true;
        }
        char endSymbol = chars.charAt(end - 1);
        if (endSymbol != '\"' && endSymbol != '\'') {
            return true;
        }
        return end >= 3 && endSymbol == chars.charAt(end - 2) && chars.charAt(end - 2) == chars.charAt(end - 3) && (end < 4 || chars.charAt(end - 4) != endSymbol);
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        IElementType tokenType = iterator.getTokenType();
        if (this.getClosingQuotesTokens().contains(tokenType)) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            if (end - start >= 1 && offset == end - 1) {
                char ch;
                Document doc = iterator.getDocument();
                if (doc == null) {
                    return false;
                }
                CharSequence chars = doc.getCharsSequence();
                return chars.length() <= offset + 1 || Arrays.binarySearch(this.ourAutoClosingChars, ch = chars.charAt(offset + 1)) >= 0;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        if (iterator == null) {
            BaseQuoteHandler.$$$reportNull$$$0(0);
        }
        Document document = iterator.getDocument();
        CharSequence text2 = document.getCharsSequence();
        char theQuote = text2.charAt(offset - 1);
        boolean retreated = false;
        if (iterator.getStart() == offset) {
            retreated = true;
            iterator.retreat();
        }
        try {
            if (this.isOpeningTripleQuote(iterator, offset - 1)) {
                String string = StringUtil.repeat((String)String.valueOf(theQuote), (int)3);
                return string;
            }
            if (this.isOpeningSingleQuote(iterator, offset - 1)) {
                String string = String.valueOf(theQuote);
                return string;
            }
            CharSequence charSequence = null;
            return charSequence;
        }
        finally {
            if (retreated) {
                iterator.advance();
            }
        }
    }

    private boolean isOpeningSingleQuote(@NotNull HighlighterIterator iterator, int offset) {
        if (iterator == null) {
            BaseQuoteHandler.$$$reportNull$$$0(1);
        }
        if (this.getOpeningQuotesTokens().contains(iterator.getTokenType())) {
            int start = iterator.getStart();
            return offset == start;
        }
        return false;
    }

    public boolean isInsideLiteral(HighlighterIterator iterator) {
        return this.getLiteralContentTokens().contains(iterator.getTokenType());
    }

    @NotNull
    protected TokenSet getOpeningQuotesTokens() {
        TokenSet tokenSet = this.myPlainStringTokens;
        if (tokenSet == null) {
            BaseQuoteHandler.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    protected TokenSet getClosingQuotesTokens() {
        TokenSet tokenSet = this.myPlainStringTokens;
        if (tokenSet == null) {
            BaseQuoteHandler.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    protected TokenSet getLiteralContentTokens() {
        TokenSet tokenSet = this.myPlainStringTokens;
        if (tokenSet == null) {
            BaseQuoteHandler.$$$reportNull$$$0(4);
        }
        return tokenSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/editor/BaseQuoteHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/editor/BaseQuoteHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpeningQuotesTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClosingQuotesTokens";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralContentTokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClosingQuote";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isOpeningSingleQuote";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

