/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.documentation.PyStructuredDocstringFormatter;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.awt.Color;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRuntimeDocstringFormatter {
    private static final Logger LOG = Logger.getInstance(PyStructuredDocstringFormatter.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    @Nullable
    public static String runExternalTool(@NotNull Module module, @NotNull DocStringFormat format, @NotNull String docstring) {
        String missingInterpreterMessage;
        Sdk sdk;
        if (module == null) {
            PyRuntimeDocstringFormatter.$$$reportNull$$$0(0);
        }
        if (format == null) {
            PyRuntimeDocstringFormatter.$$$reportNull$$$0(1);
        }
        if (docstring == null) {
            PyRuntimeDocstringFormatter.$$$reportNull$$$0(2);
        }
        if (format == DocStringFormat.EPYTEXT) {
            sdk = PythonSdkType.findPython2Sdk(module);
            missingInterpreterMessage = PyPsiBundle.message("QDOC.epydoc.python2.sdk.not.found", new Object[0]);
        } else {
            sdk = PythonSdkType.findLocalCPython(module);
            missingInterpreterMessage = PyPsiBundle.message("QDOC.local.sdk.not.found", new Object[0]);
        }
        if (sdk == null) {
            LOG.warn("Python SDK for docstring formatter " + format + " is not found");
            return HtmlChunk.p().attr("color", ColorUtil.toHtmlColor((Color)JBColor.RED)).addText(missingInterpreterMessage).toString();
        }
        String sdkHome = sdk.getHomePath();
        if (sdkHome == null) {
            return null;
        }
        ByteBuffer encoded = DEFAULT_CHARSET.encode(docstring);
        byte[] data = new byte[encoded.limit()];
        encoded.get(data);
        ArrayList arguments = Lists.newArrayList((Object[])new String[]{format.getFormatterCommand()});
        GeneralCommandLine commandLine = PythonHelper.DOCSTRING_FORMATTER.newCommandLine(sdk, (List<String>)arguments);
        commandLine.setCharset(DEFAULT_CHARSET);
        LOG.debug("Command for launching docstring formatter: " + commandLine.getCommandLineString());
        ProcessOutput output = PySdkUtil.getProcessOutput(commandLine, new File(sdkHome).getParent(), null, 5000, data, false);
        if (!output.checkSuccess(LOG)) {
            LOG.info("Malformed docstring:\n" + docstring);
            return null;
        }
        return output.getStdout();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "format";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "docstring";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/documentation/PyRuntimeDocstringFormatter";
        objectArray[2] = "runExternalTool";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

