/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class PyDataViewDialog
extends DialogWrapper {
    private final JPanel myMainPanel;
    private static final int TABLE_DEFAULT_WIDTH = 700;
    private static final int TABLE_DEFAULT_HEIGHT = 500;
    private final Project myProject;
    private final PyDataViewerPanel myDataViewerPanel;

    public PyDataViewDialog(@NotNull Project project, @NotNull PyDebugValue value) {
        if (project == null) {
            PyDataViewDialog.$$$reportNull$$$0(0);
        }
        if (value == null) {
            PyDataViewDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myProject = project;
        this.setModal(false);
        this.setCancelButtonText(PyBundle.message("debugger.data.view.close", new Object[0]));
        this.setCrossClosesWindow(true);
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myDataViewerPanel = this.createDataViewerPanel(project, value.getFrameAccessor());
        this.myDataViewerPanel.apply(value, false);
        this.myDataViewerPanel.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        this.myMainPanel.add((Component)this.myDataViewerPanel, this.createDataViewPanelConstraints());
        this.myDataViewerPanel.addListener(new PyDataViewerPanel.Listener(){

            @Override
            public void onNameChanged(String name) {
                PyDataViewDialog.this.setTitle(name);
            }
        });
        this.addBottomElements();
        this.setTitle(value.getFullName());
        this.init();
    }

    protected void addBottomElements() {
        final JBCheckBox colored = new JBCheckBox(PyBundle.message("debugger.data.view.colored.cells", new Object[0]));
        final JBCheckBox resize = new JBCheckBox(PyBundle.message("debugger.data.view.resize.automatically", new Object[0]));
        resize.setSelected(PropertiesComponent.getInstance((Project)this.myProject).getBoolean("python.debugger.dataview.autoresize", true));
        colored.setSelected(PropertiesComponent.getInstance((Project)this.myProject).getBoolean("python.debugger.dataview.coloredbydefault", true));
        colored.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyDataViewDialog.this.myDataViewerPanel.setColored(colored.isSelected());
                PyDataViewDialog.this.myDataViewerPanel.updateUI();
            }
        });
        resize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyDataViewDialog.this.myDataViewerPanel.resize(resize.isSelected());
                PyDataViewDialog.this.myDataViewerPanel.updateUI();
            }
        });
        GridBagConstraints checkBoxConstraints = this.createCheckBoxConstraints();
        checkBoxConstraints.gridy = 1;
        this.myMainPanel.add((Component)colored, checkBoxConstraints);
        checkBoxConstraints.gridy = 2;
        this.myMainPanel.add((Component)resize, checkBoxConstraints);
    }

    protected PyDataViewerPanel createDataViewerPanel(@NotNull Project project, @NotNull PyFrameAccessor frameAccessor) {
        if (project == null) {
            PyDataViewDialog.$$$reportNull$$$0(2);
        }
        if (frameAccessor == null) {
            PyDataViewDialog.$$$reportNull$$$0(3);
        }
        return new PyDataViewerPanel(project, frameAccessor);
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction()};
        if (actionArray == null) {
            PyDataViewDialog.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected GridBagConstraints createDataViewPanelConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.9;
        c.weighty = 0.9;
        return c;
    }

    protected GridBagConstraints createCheckBoxConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.05;
        c.anchor = 21;
        return c;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAccessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/containerview/PyDataViewDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/containerview/PyDataViewDialog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDataViewerPanel";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

