/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.signatureHelp;

import com.intellij.codeInsight.parameterInfo.ParameterFlag;
import com.intellij.codeInsight.signatureHelp.ParameterInfo;
import com.intellij.codeInsight.signatureHelp.SignatureHelpProvider;
import com.intellij.codeInsight.signatureHelp.SignatureHelpResult;
import com.intellij.codeInsight.signatureHelp.SignatureInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.codeInsight.parameterInfo.ParameterHints;
import com.jetbrains.python.codeInsight.parameterInfo.PyParameterInfoUtils;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.types.PyCallableType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public final class PySignatureHelpProvider
implements SignatureHelpProvider {
    public SignatureHelpResult getSignatureHelp(PsiFile file, int offset) {
        PyArgumentList argumentList = PyParameterInfoUtils.findArgumentList(file, offset, -1);
        if (argumentList == null || !argumentList.getTextRange().contains(offset) && argumentList.getText().endsWith(")")) {
            return null;
        }
        List<Pair<PyCallExpression, PyCallableType>> signatures = PyParameterInfoUtils.findCallCandidates(argumentList);
        int currentParamOffset = PyParameterInfoUtils.findCurrentParameter(argumentList, offset, file);
        ArrayList<SignatureInfo> signatureInfos = new ArrayList<SignatureInfo>();
        for (Pair<PyCallExpression, PyCallableType> signature : signatures) {
            ParameterHints parameterHints = PyParameterInfoUtils.buildParameterHints(signature, currentParamOffset);
            if (parameterHints == null) continue;
            List<String> hints = parameterHints.getHints();
            ArrayList<ParameterInfo> parameterInfos = new ArrayList<ParameterInfo>();
            for (String hint : hints) {
                parameterInfos.add(new ParameterInfo(null, hint));
            }
            String fullSignature = String.join((CharSequence)"", hints);
            int highlightedParamIndex = PySignatureHelpProvider.findHighlightedParamIndex(parameterHints.getFlags());
            signatureInfos.add(new SignatureInfo(null, fullSignature, parameterInfos, highlightedParamIndex));
        }
        return new SignatureHelpResult(signatureInfos);
    }

    private static int findHighlightedParamIndex(Map<Integer, EnumSet<ParameterFlag>> flags) {
        for (int i = 0; i < flags.size(); ++i) {
            EnumSet<ParameterFlag> parameterFlags;
            if (!flags.containsKey(i) || !(parameterFlags = flags.get(i)).contains(ParameterFlag.HIGHLIGHT)) continue;
            return i;
        }
        return -1;
    }
}

