/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonHelpersLocator {
    private static final Logger LOG = Logger.getInstance(PythonHelpersLocator.class);
    private static final String PROPERTY_HELPERS_LOCATION = "idea.python.helpers.path";

    private PythonHelpersLocator() {
    }

    @NotNull
    public static File getHelpersRoot() {
        String property = System.getProperty(PROPERTY_HELPERS_LOCATION);
        if (property != null) {
            return new File(property);
        }
        return PythonHelpersLocator.getHelperRoot("intellij.python.helpers", "helpers");
    }

    @NotNull
    public static File getHelpersProRoot() {
        return PythonHelpersLocator.getHelperRoot("intellij.python.helpers.pro", "helpers-pro");
    }

    @NotNull
    public static File getHelperRoot(@NotNull String moduleName, @NotNull String dirName) {
        String jarPath;
        File pluginBaseDir;
        if (moduleName == null) {
            PythonHelpersLocator.$$$reportNull$$$0(0);
        }
        if (dirName == null) {
            PythonHelpersLocator.$$$reportNull$$$0(1);
        }
        if ((pluginBaseDir = PythonHelpersLocator.getPluginBaseDir(jarPath = PathUtil.getJarPathForClass(PythonHelpersLocator.class))) != null) {
            return new File(pluginBaseDir, dirName);
        }
        return new File(new File(jarPath).getParentFile(), moduleName);
    }

    @Nullable
    private static File getPluginBaseDir(@NonNls String jarPath) {
        if (jarPath.endsWith(".jar")) {
            File jarFile = new File(jarPath);
            LOG.assertTrue(jarFile.exists(), (Object)"jar file cannot be null");
            return jarFile.getParentFile().getParentFile();
        }
        return null;
    }

    public static String getHelperPath(@NonNls @NotNull String resourceName) {
        if (resourceName == null) {
            PythonHelpersLocator.$$$reportNull$$$0(2);
        }
        return PythonHelpersLocator.getHelperFile(resourceName).getAbsolutePath();
    }

    @NotNull
    public static File getHelperFile(@NotNull String resourceName) {
        if (resourceName == null) {
            PythonHelpersLocator.$$$reportNull$$$0(3);
        }
        return new File(PythonHelpersLocator.getHelpersRoot(), resourceName);
    }

    public static String getPythonCommunityPath() {
        File pathFromUltimate = new File(PathManager.getHomePath(), "community/python");
        if (pathFromUltimate.exists()) {
            return pathFromUltimate.getPath();
        }
        return new File(PathManager.getHomePath(), "python").getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/PythonHelpersLocator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHelperRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getHelperPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getHelperFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

