/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.FileChannelUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

final class FileChannelWithSizeTracking {
    private static final Logger LOG = Logger.getInstance(FileChannelWithSizeTracking.class);
    private static final boolean doAssertions = SystemProperties.getBooleanProperty("idea.do.random.access.wrapper.assertions", false);
    private final Path myPath;
    private final FileChannel myChannel;
    private volatile long mySize;

    FileChannelWithSizeTracking(@NotNull Path path) throws IOException {
        if (path == null) {
            FileChannelWithSizeTracking.$$$reportNull$$$0(0);
        }
        Path parent = path.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        this.myChannel = FileChannelUtil.unInterruptible(FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE));
        this.mySize = this.myChannel.size();
        this.myPath = path;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Inst:" + this + "," + Thread.currentThread() + "," + this.getClass().getClassLoader());
        }
    }

    long length() throws IOException {
        if (doAssertions) assert (this.mySize == this.myChannel.size());
        return this.mySize;
    }

    void write(long addr, byte[] dst, int off, int len) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("write:" + this + "," + Thread.currentThread() + "," + len + "," + addr);
        }
        int written = this.myChannel.write(ByteBuffer.wrap(dst, off, len), addr);
        this.mySize = Math.max((long)written + addr, this.length());
    }

    void read(long addr, byte[] dst, int off, int len) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("read:" + this + "," + Thread.currentThread() + "," + len + "," + addr);
        }
        this.myChannel.read(ByteBuffer.wrap(dst, off, len), addr);
    }

    void close() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Closed:" + this + "," + Thread.currentThread());
        }
        this.force();
        this.myChannel.close();
    }

    public String toString() {
        return this.myPath + "@" + Integer.toHexString(this.hashCode());
    }

    private void force() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Forcing:" + this + "," + Thread.currentThread());
        }
        this.myChannel.force(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/io/FileChannelWithSizeTracking", "<init>"));
    }
}

