/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GHErrorPanelModel;
import org.jetbrains.plugins.github.ui.GHImmutableErrorPanelModel;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;
import org.jetbrains.plugins.github.util.GithubUIUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J,\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0012\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0013\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/ui/GHHtmlErrorPanel;", "", "()V", "ERROR_ACTION_HREF", "", "addDotIfNeeded", "line", "create", "Ljavax/swing/JComponent;", "errorPrefix", "error", "", "errorAction", "Ljavax/swing/Action;", "horizontalAlignment", "", "model", "Lorg/jetbrains/plugins/github/ui/GHErrorPanelModel;", "getLoadingErrorText", "newLineSeparator", "Controller", "intellij.vcs.github"})
public final class GHHtmlErrorPanel {
    private static final String ERROR_ACTION_HREF = "ERROR_ACTION";
    public static final GHHtmlErrorPanel INSTANCE;

    @NotNull
    public final JComponent create(@NotNull String errorPrefix, @NotNull Throwable error, @Nullable Action errorAction, int horizontalAlignment) {
        Intrinsics.checkNotNullParameter((Object)errorPrefix, (String)"errorPrefix");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        GHImmutableErrorPanelModel model2 = new GHImmutableErrorPanelModel(errorPrefix, error, errorAction);
        return this.create(model2, horizontalAlignment);
    }

    public static /* synthetic */ JComponent create$default(GHHtmlErrorPanel gHHtmlErrorPanel, String string, Throwable throwable, Action action2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            action2 = null;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        return gHHtmlErrorPanel.create(string, throwable, action2, n);
    }

    @NotNull
    public final JComponent create(@NotNull GHErrorPanelModel model2, int horizontalAlignment) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        HtmlEditorPane htmlEditorPane = new HtmlEditorPane();
        boolean bl = false;
        boolean bl2 = false;
        HtmlEditorPane $this$apply = htmlEditorPane;
        boolean bl3 = false;
        $this$apply.setForeground(UIUtil.getErrorForeground());
        $this$apply.setFocusable(true);
        $this$apply.removeHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        $this$apply.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter($this$apply, model2){
            final /* synthetic */ HtmlEditorPane $this_apply;
            final /* synthetic */ GHErrorPanelModel $model$inlined;
            {
                this.$this_apply = $receiver;
                this.$model$inlined = gHErrorPanelModel;
            }

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (Intrinsics.areEqual((Object)e.getDescription(), (Object)"ERROR_ACTION")) {
                    Action action2 = this.$model$inlined.getErrorAction();
                    if (action2 != null) {
                        action2.actionPerformed(new ActionEvent((Object)((Object)this.$this_apply), 1001, "perform"));
                    }
                } else {
                    BrowserUtil.browse((String)e.getDescription());
                }
            }
        });
        $this$apply.registerKeyboardAction(new ActionListener(model2){
            final /* synthetic */ GHErrorPanelModel $model$inlined;
            {
                this.$model$inlined = gHErrorPanelModel;
            }

            public final void actionPerformed(ActionEvent it) {
                block0: {
                    Action action2 = this.$model$inlined.getErrorAction();
                    if (action2 == null) break block0;
                    action2.actionPerformed(it);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        HtmlEditorPane pane2 = htmlEditorPane;
        new Controller(model2, pane2, horizontalAlignment);
        return (JComponent)((Object)pane2);
    }

    public static /* synthetic */ JComponent create$default(GHHtmlErrorPanel gHHtmlErrorPanel, GHErrorPanelModel gHErrorPanelModel, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return gHHtmlErrorPanel.create(gHErrorPanelModel, n);
    }

    private final String getLoadingErrorText(Throwable error, String newLineSeparator) {
        String string;
        block11: {
            block10: {
                if (error instanceof GithubStatusCodeException && ((GithubStatusCodeException)error).getError() != null) {
                    GithubErrorMessage githubErrorMessage = ((GithubStatusCodeException)error).getError();
                    Intrinsics.checkNotNull((Object)githubErrorMessage);
                    Intrinsics.checkNotNullExpressionValue((Object)githubErrorMessage, (String)"error.error!!");
                    if (githubErrorMessage.getMessage() != null) {
                        GithubErrorMessage githubErrorMessage2 = ((GithubStatusCodeException)error).getError();
                        Intrinsics.checkNotNull((Object)githubErrorMessage2);
                        Intrinsics.checkNotNullExpressionValue((Object)githubErrorMessage2, (String)"error.error!!");
                        GithubErrorMessage githubError = githubErrorMessage2;
                        String string2 = githubError.getMessage();
                        Intrinsics.checkNotNull((Object)string2);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"githubError.message!!");
                        String message = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string2, (CharSequence)"["), (CharSequence)"]");
                        StringBuilder builder = new StringBuilder(message);
                        if (StringsKt.startsWith((String)message, (String)"Could not resolve to a Repository", (boolean)true)) {
                            builder.append(" Either repository doesn't exist or you don't have access. The most probable cause is that OAuth App access restrictions are enabled in organization.");
                        }
                        List<GithubErrorMessage.Error> errors = githubError.getErrors();
                        Collection collection = errors;
                        boolean bl = false;
                        boolean bl2 = false;
                        if (!(collection == null || collection.isEmpty())) {
                            builder.append(": ").append(newLineSeparator);
                            Iterator<GithubErrorMessage.Error> iterator = errors.iterator();
                            while (iterator.hasNext()) {
                                GithubErrorMessage.Error e;
                                GithubErrorMessage.Error error2 = e = iterator.next();
                                Intrinsics.checkNotNullExpressionValue((Object)error2, (String)"e");
                                String string3 = error2.getMessage();
                                if (string3 == null) {
                                    Object[] objectArray = new Object[3];
                                    objectArray[0] = e.getCode();
                                    objectArray[1] = e.getResource();
                                    String string4 = e.getField();
                                    boolean bl3 = false;
                                    String string5 = string4;
                                    if (string5 == null) {
                                        string5 = "";
                                    }
                                    objectArray[2] = string5;
                                    string3 = GithubBundle.message("gql.error.in.field", objectArray);
                                }
                                builder.append(string3).append(newLineSeparator);
                            }
                        }
                        String string6 = builder.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"builder.toString()");
                        return string6;
                    }
                }
                if ((string = error.getMessage()) == null) break block10;
                String string7 = string;
                boolean bl = false;
                boolean bl4 = false;
                String it = string7;
                boolean bl5 = false;
                string = INSTANCE.addDotIfNeeded(it);
                if (string != null) break block11;
            }
            String string8 = GithubBundle.message("unknown.loading.error", new Object[0]);
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"GithubBundle.message(\"unknown.loading.error\")");
        }
        return string;
    }

    static /* synthetic */ String getLoadingErrorText$default(GHHtmlErrorPanel gHHtmlErrorPanel, Throwable throwable, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "\n";
        }
        return gHHtmlErrorPanel.getLoadingErrorText(throwable, string);
    }

    private final String addDotIfNeeded(String line) {
        return StringsKt.endsWith$default((CharSequence)line, (char)'.', (boolean)false, (int)2, null) ? line : line + '.';
    }

    private GHHtmlErrorPanel() {
    }

    static {
        GHHtmlErrorPanel gHHtmlErrorPanel;
        INSTANCE = gHHtmlErrorPanel = new GHHtmlErrorPanel();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/ui/GHHtmlErrorPanel$Controller;", "", "model", "Lorg/jetbrains/plugins/github/ui/GHErrorPanelModel;", "pane", "Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane;", "horizontalAlignment", "", "(Lorg/jetbrains/plugins/github/ui/GHErrorPanelModel;Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane;I)V", "alignmentText", "", "a", "link", "text", "paragraph", "update", "", "intellij.vcs.github"})
    private static final class Controller {
        private final String alignmentText;
        private final GHErrorPanelModel model;
        private final HtmlEditorPane pane;

        private final void update() {
            Throwable error = this.model.getError();
            if (error != null) {
                this.pane.setVisible(true);
                String errorText = this.paragraph(this.model.getErrorPrefix()) + this.paragraph(INSTANCE.getLoadingErrorText(error, "<br/>"));
                Action errorAction = this.model.getErrorAction();
                if (errorAction != null) {
                    errorText = errorText + "<br/>" + this.paragraph(this.a(GHHtmlErrorPanel.ERROR_ACTION_HREF, GithubUIUtilKt.getName(errorAction)));
                }
                this.pane.setBody(errorText);
            } else {
                this.pane.setVisible(false);
                this.pane.setBody("");
            }
            this.pane.setSize(0x3FFFFFFF, 0x3FFFFFFF);
        }

        private final String paragraph(String text) {
            return "<p align='" + this.alignmentText + "'>" + text + "</p>";
        }

        private final String a(String link, String text) {
            return "<a href='" + link + "'>" + text + "</a>";
        }

        public Controller(@NotNull GHErrorPanelModel model2, @NotNull HtmlEditorPane pane2, int horizontalAlignment) {
            String string;
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)((Object)pane2), (String)"pane");
            this.model = model2;
            this.pane = pane2;
            switch (horizontalAlignment) {
                case 2: {
                    string = "left";
                    break;
                }
                case 4: {
                    string = "right";
                    break;
                }
                default: {
                    string = "center";
                }
            }
            this.alignmentText = string;
            this.model.addAndInvokeChangeEventListener((Function0<Unit>)((Function0)new Function0<Unit>(this){

                public final void invoke() {
                    ((Controller)this.receiver).update();
                }
            }));
        }
    }
}

