/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.google.common.primitives.Ints;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ValueKey;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.graph.RowInfo;
import com.intellij.vcs.log.graph.RowType;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.paint.PositionUtil;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.SimpleColoredComponentLinkMouseListener;
import com.intellij.vcs.log.ui.table.GraphCommitCellController;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.IndexSpeedSearch;
import com.intellij.vcs.log.ui.table.Selection;
import com.intellij.vcs.log.ui.table.TableWithProgress;
import com.intellij.vcs.log.ui.table.VcsLogCellController;
import com.intellij.vcs.log.ui.table.VcsLogCellRenderer;
import com.intellij.vcs.log.ui.table.column.Commit;
import com.intellij.vcs.log.ui.table.column.Root;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnManager;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnUtilKt;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogGraphTable
extends TableWithProgress
implements DataProvider,
CopyProvider {
    private static final Logger LOG = Logger.getInstance(VcsLogGraphTable.class);
    public static final int ROOT_INDICATOR_WHITE_WIDTH = 5;
    private static final int ROOT_INDICATOR_WIDTH = 13;
    private static final int ROOT_NAME_MAX_WIDTH = 300;
    private static final int MAX_DEFAULT_DYNAMIC_COLUMN_WIDTH = 300;
    private static final int MAX_ROWS_TO_CALC_WIDTH = 1000;
    private static final Color DEFAULT_HOVERED_BACKGROUND = new JBColor(ColorUtil.withAlpha((Color)new Color(12833507), (double)0.4), new Color(4606541));
    private static final Color HOVERED_BACKGROUND = JBColor.namedColor((String)"VersionControl.Log.Commit.hoveredBackground", (Color)DEFAULT_HOVERED_BACKGROUND);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final String myId;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final MyDummyTableCellEditor myDummyEditor;
    @NotNull
    private final BaseStyleProvider myBaseStyleProvider;
    @NotNull
    private final GraphCommitCellRenderer myGraphCommitCellRenderer;
    @NotNull
    private final MyMouseAdapter myMouseAdapter;
    @NotNull
    private final Map<VcsLogColumn<?>, TableColumn> myTableColumns;
    @NotNull
    private final Set<VcsLogColumn<?>> myInitializedColumns;
    @NotNull
    private final Collection<VcsLogHighlighter> myHighlighters;
    @Nullable
    private Selection mySelection;

    public VcsLogGraphTable(@NotNull String logId, @NotNull VcsLogData logData, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogColorManager colorManager, @NotNull Consumer<Runnable> requestMore, @NotNull Disposable disposable) {
        if (logId == null) {
            VcsLogGraphTable.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VcsLogGraphTable.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            VcsLogGraphTable.$$$reportNull$$$0(2);
        }
        if (colorManager == null) {
            VcsLogGraphTable.$$$reportNull$$$0(3);
        }
        if (requestMore == null) {
            VcsLogGraphTable.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            VcsLogGraphTable.$$$reportNull$$$0(5);
        }
        super(new GraphTableModel(logData, requestMore, uiProperties));
        this.myDummyEditor = new MyDummyTableCellEditor();
        this.myTableColumns = new HashMap();
        this.myInitializedColumns = new HashSet();
        this.myHighlighters = new LinkedHashSet<VcsLogHighlighter>();
        this.mySelection = null;
        this.myLogData = logData;
        this.myId = logId;
        this.myProperties = uiProperties;
        this.myColorManager = colorManager;
        this.myBaseStyleProvider = new BaseStyleProvider((JTable)((Object)this));
        this.getEmptyText().setText(VcsLogBundle.message((String)"vcs.log.default.status", (Object[])new Object[0]));
        this.myLogData.getProgress().addProgressIndicatorListener(new MyProgressListener(), disposable);
        this.initColumnModel();
        this.onColumnOrderSettingChanged();
        this.setRootColumnSize();
        this.myGraphCommitCellRenderer = (GraphCommitCellRenderer)this.myTableColumns.get(Commit.INSTANCE).getCellRenderer();
        VcsLogColumnManager.getInstance().addCurrentColumnsListener(disposable, new MyCurrentColumnsListener());
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setIntercellSpacing((Dimension)JBUI.emptySize());
        this.setTableHeader((JTableHeader)new JBTable.InvisibleResizableHeader(){

            protected boolean canMoveOrResizeColumn(int modelIndex) {
                return modelIndex != VcsLogColumnManager.getInstance().getModelIndex(Root.INSTANCE);
            }
        });
        this.myMouseAdapter = new MyMouseAdapter();
        this.addMouseMotionListener(this.myMouseAdapter);
        this.addMouseListener(this.myMouseAdapter);
        this.getSelectionModel().addListSelectionListener(e -> {
            this.mySelection = null;
        });
        this.getColumnModel().setColumnSelectionAllowed(false);
        ScrollingUtil.installActions((JTable)((Object)this), (boolean)false);
        new IndexSpeedSearch(this.myLogData.getProject(), this.myLogData.getIndex(), this){

            @Override
            protected boolean isSpeedSearchEnabled() {
                return VcsLogGraphTable.this.isSpeedSearchEnabled() && super.isSpeedSearchEnabled();
            }
        };
    }

    private void initColumnModel() {
        MyTableColumnModel columnModel = new MyTableColumnModel(this.myProperties);
        this.setColumnModel(columnModel);
        this.setAutoCreateColumnsFromModel(false);
    }

    protected boolean isSpeedSearchEnabled() {
        return Registry.is((String)"vcs.log.speedsearch");
    }

    protected void updateEmptyText() {
        this.getEmptyText().setText(VcsLogBundle.message((String)"vcs.log.default.status", (Object[])new Object[0]));
    }

    protected void setErrorEmptyText(@NotNull Throwable error, @NlsContexts.StatusText @NotNull String defaultText) {
        if (error == null) {
            VcsLogGraphTable.$$$reportNull$$$0(6);
        }
        if (defaultText == null) {
            VcsLogGraphTable.$$$reportNull$$$0(7);
        }
        String message = (String)ObjectUtils.chooseNotNull((Object)error.getLocalizedMessage(), (Object)defaultText);
        String shortenedMessage = StringUtil.shortenTextWithEllipsis((String)message, (int)150, (int)0, (boolean)true);
        this.getEmptyText().setText(shortenedMessage.replace('\n', ' '));
    }

    protected void appendActionToEmptyText(@Nls @NotNull String text2, @NotNull Runnable action) {
        if (text2 == null) {
            VcsLogGraphTable.$$$reportNull$$$0(8);
        }
        if (action == null) {
            VcsLogGraphTable.$$$reportNull$$$0(9);
        }
        this.getEmptyText().appendSecondaryText(text2, VcsLogUiUtil.getLinkAttributes(), e -> action.run());
    }

    public void updateDataPack(@NotNull VisiblePack visiblePack, boolean permGraphChanged) {
        if (visiblePack == null) {
            VcsLogGraphTable.$$$reportNull$$$0(10);
        }
        boolean filtersChanged = !this.getModel().getVisiblePack().getFilters().equals(visiblePack.getFilters());
        Selection previousSelection = this.getSelection();
        this.getModel().setVisiblePack(visiblePack);
        previousSelection.restore(visiblePack.getVisibleGraph(), true, permGraphChanged);
        for (VcsLogHighlighter highlighter : this.myHighlighters) {
            highlighter.update((VcsLogDataPack)visiblePack, permGraphChanged);
        }
        if (!this.getEmptyText().getText().equals(VcsLogBundle.message((String)"vcs.log.loading.status", (Object[])new Object[0]))) {
            this.updateEmptyText();
        }
        this.setPaintBusy(false);
        if (filtersChanged) {
            this.myInitializedColumns.clear();
        }
        this.reLayout();
    }

    public void onColumnOrderSettingChanged() {
        List<VcsLogColumn<?>> columnOrder = this.getColumnOrderFromProperties();
        if (columnOrder != null) {
            TableColumnModel columnModel = this.getColumnModel();
            int columnCount = this.getVisibleColumnCount();
            for (int i = columnCount - 1; i >= 0; --i) {
                columnModel.removeColumn(columnModel.getColumn(i));
            }
            for (VcsLogColumn<?> column : columnOrder) {
                this.myTableColumns.computeIfAbsent(column, k -> this.createTableColumn(column));
                columnModel.addColumn(this.myTableColumns.get(column));
            }
        }
        this.reLayout();
    }

    @Nullable
    private List<VcsLogColumn<?>> getColumnOrderFromProperties() {
        List<VcsLogColumn<?>> columnOrder = VcsLogColumnUtilKt.getColumnsOrder(this.myProperties);
        if (VcsLogColumnUtilKt.isValidColumnOrder(columnOrder)) {
            return columnOrder;
        }
        LOG.debug("Incorrect column order was saved in properties " + columnOrder + ", replacing it with default order.");
        VcsLogColumnUtilKt.updateOrder(this.myProperties, ContainerUtil.map(this.getVisibleColumns(), it -> VcsLogColumnManager.getInstance().getColumn((int)it)));
        return null;
    }

    @NotNull
    private List<Integer> getVisibleColumns() {
        ArrayList<Integer> columnOrder = new ArrayList<Integer>();
        for (int i = 0; i < this.getVisibleColumnCount(); ++i) {
            columnOrder.add(this.getColumnModel().getColumn(i).getModelIndex());
        }
        ArrayList<Integer> arrayList = columnOrder;
        if (arrayList == null) {
            VcsLogGraphTable.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private int getVisibleColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    public void reLayout() {
        if (this.getTableHeader().getResizingColumn() == null) {
            this.updateDynamicColumnsWidth();
            super.doLayout();
            this.repaint();
        }
    }

    public void forceReLayout(@NotNull VcsLogColumn<?> column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(12);
        }
        this.myInitializedColumns.remove(column);
        this.reLayout();
    }

    public void doLayout() {
        if (this.getTableHeader().getResizingColumn() == null) {
            this.updateDynamicColumnsWidth();
        }
        super.doLayout();
    }

    private void resetColumnWidth(@NotNull VcsLogColumn<?> column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(13);
        }
        VcsLogUsageTriggerCollector.triggerUsage(VcsLogUsageTriggerCollector.VcsLogEvent.COLUMN_RESET, null);
        if (VcsLogColumnUtilKt.getWidth(column, this.myProperties) != -1) {
            VcsLogColumnUtilKt.setWidth(column, this.myProperties, -1);
        } else {
            this.forceReLayout(column);
        }
    }

    @NotNull
    private TableColumn createTableColumn(VcsLogColumn<?> column) {
        TableColumn tableColumn = new TableColumn(VcsLogColumnManager.getInstance().getModelIndex(column));
        tableColumn.setResizable(column.isResizable());
        tableColumn.setCellRenderer(column.createTableCellRenderer(this));
        TableColumn tableColumn2 = tableColumn;
        if (tableColumn2 == null) {
            VcsLogGraphTable.$$$reportNull$$$0(14);
        }
        return tableColumn2;
    }

    @NotNull
    public VcsLogUiProperties getProperties() {
        VcsLogUiProperties vcsLogUiProperties = this.myProperties;
        if (vcsLogUiProperties == null) {
            VcsLogGraphTable.$$$reportNull$$$0(15);
        }
        return vcsLogUiProperties;
    }

    @NotNull
    public VcsLogColorManager getColorManager() {
        VcsLogColorManager vcsLogColorManager = this.myColorManager;
        if (vcsLogColorManager == null) {
            VcsLogGraphTable.$$$reportNull$$$0(16);
        }
        return vcsLogColorManager;
    }

    @NotNull
    public VcsLogData getLogData() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            VcsLogGraphTable.$$$reportNull$$$0(17);
        }
        return vcsLogData;
    }

    private void updateDynamicColumnsWidth() {
        for (VcsLogColumn<?> logColumn : VcsLogColumnManager.getInstance().getCurrentDynamicColumns()) {
            TableColumn column = this.getTableColumn(logColumn);
            if (column == null) continue;
            int width = VcsLogColumnUtilKt.getWidth(logColumn, this.myProperties);
            if (width <= 0 || width > this.getWidth()) {
                width = this.getColumnWidthFromData(column);
            }
            if (width <= 0 || width == column.getPreferredWidth()) continue;
            column.setPreferredWidth(width);
        }
        int size = this.getWidth();
        for (VcsLogColumn<?> logColumn : VcsLogColumnManager.getInstance().getCurrentColumns()) {
            TableColumn column;
            if (logColumn == Commit.INSTANCE || (column = this.getTableColumn(logColumn)) == null) continue;
            size -= column.getPreferredWidth();
        }
        this.getCommitColumn().setPreferredWidth(size);
    }

    private int getColumnWidthFromData(@NotNull TableColumn column) {
        Integer width;
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(18);
        }
        int index = column.getModelIndex();
        VcsLogColumn<?> logColumn = VcsLogColumnManager.getInstance().getColumn(index);
        TableCellRenderer columnRenderer = this.myTableColumns.get(logColumn).getCellRenderer();
        if (columnRenderer instanceof VcsLogCellRenderer && (width = ((VcsLogCellRenderer)((Object)columnRenderer)).getPreferredWidth((JTable)((Object)this))) != null) {
            return width;
        }
        if (this.getModel().getRowCount() <= 0 || !(this.getModel().getValueAt(0, logColumn) instanceof String) || this.myInitializedColumns.contains(logColumn)) {
            return column.getPreferredWidth();
        }
        Font tableFont = VcsLogGraphTable.getTableFont();
        int maxRowsToCheck = Math.min(1000, this.getRowCount());
        int maxValueWidth = 0;
        int unloaded = 0;
        for (int row2 = 0; row2 < maxRowsToCheck; ++row2) {
            String value = this.getModel().getValueAt(row2, logColumn).toString();
            if (value.isEmpty()) {
                ++unloaded;
                continue;
            }
            Font font = tableFont;
            VcsLogHighlighter.TextStyle style = this.getStyle(row2, this.getColumnViewIndex(logColumn), false, false, false).getTextStyle();
            if (VcsLogHighlighter.TextStyle.BOLD.equals((Object)style)) {
                font = tableFont.deriveFont(1);
            } else if (VcsLogHighlighter.TextStyle.ITALIC.equals((Object)style)) {
                font = tableFont.deriveFont(2);
            }
            maxValueWidth = Math.max(this.getFontMetrics(font).stringWidth(value + "*"), maxValueWidth);
        }
        int horizontalPadding = columnRenderer instanceof SimpleColoredComponent ? VcsLogUiUtil.getHorizontalTextPadding((SimpleColoredComponent)columnRenderer) : 0;
        int width2 = Math.min(maxValueWidth + horizontalPadding, JBUIScale.scale((int)300));
        if (unloaded * 2 <= maxRowsToCheck) {
            this.myInitializedColumns.add(logColumn);
        }
        return width2;
    }

    @Nullable
    public VcsLogColumn<?> getVcsLogColumn(int viewIndex) {
        int modelIndex = this.convertColumnIndexToModel(viewIndex);
        return modelIndex < 0 ? null : VcsLogColumnManager.getInstance().getColumn(modelIndex);
    }

    public final int getColumnViewIndex(@NotNull VcsLogColumn<?> column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(19);
        }
        return this.convertColumnIndexToView(VcsLogColumnManager.getInstance().getModelIndex(column));
    }

    @Nullable
    public TableColumn getTableColumn(@NotNull VcsLogColumn<?> column) {
        int viewIndex;
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(20);
        }
        return (viewIndex = this.getColumnViewIndex(column)) != -1 ? this.getColumnModel().getColumn(viewIndex) : null;
    }

    @NotNull
    public TableColumn getRootColumn() {
        TableColumn tableColumn = Objects.requireNonNull(this.getTableColumn(Root.INSTANCE));
        if (tableColumn == null) {
            VcsLogGraphTable.$$$reportNull$$$0(21);
        }
        return tableColumn;
    }

    @NotNull
    public TableColumn getCommitColumn() {
        TableColumn tableColumn = Objects.requireNonNull(this.getTableColumn(Commit.INSTANCE));
        if (tableColumn == null) {
            VcsLogGraphTable.$$$reportNull$$$0(22);
        }
        return tableColumn;
    }

    @Nullable
    private VcsLogCellController getController(@NotNull VcsLogColumn<?> column) {
        TableColumn tableColumn;
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(23);
        }
        if ((tableColumn = this.getTableColumn(column)) == null) {
            return null;
        }
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (!(renderer instanceof VcsLogCellRenderer)) {
            return null;
        }
        return ((VcsLogCellRenderer)((Object)renderer)).getCellController();
    }

    @NotNull
    Point getPointInCell(@NotNull Point clickPoint, @NotNull VcsLogColumn<?> vcsLogColumn) {
        TableColumn column;
        if (clickPoint == null) {
            VcsLogGraphTable.$$$reportNull$$$0(24);
        }
        if (vcsLogColumn == null) {
            VcsLogGraphTable.$$$reportNull$$$0(25);
        }
        int width = 0;
        for (int i = 0; i < this.getColumnModel().getColumnCount() && (column = this.getColumnModel().getColumn(i)).getModelIndex() != VcsLogColumnManager.getInstance().getModelIndex(vcsLogColumn); ++i) {
            width += column.getWidth();
        }
        return new Point(clickPoint.x - width, PositionUtil.getYInsideRow(clickPoint, this.getRowHeight()));
    }

    int getColumnLeftXCoordinate(int viewColumnIndex) {
        int x = 0;
        for (int i = 0; i < viewColumnIndex; ++i) {
            x += this.getColumnModel().getColumn(i).getWidth();
        }
        return x;
    }

    private void setRootColumnSize() {
        int rootWidth;
        TableColumn column = this.getRootColumn();
        if (!this.myColorManager.hasMultiplePaths()) {
            rootWidth = 0;
        } else if (!this.isShowRootNames()) {
            rootWidth = JBUIScale.scale((int)13);
        } else {
            int width = 0;
            for (FilePath file : this.myColorManager.getPaths()) {
                Font tableFont = VcsLogGraphTable.getTableFont();
                width = Math.max(this.getFontMetrics(tableFont).stringWidth(file.getName() + "  "), width);
            }
            rootWidth = Math.min(width, JBUIScale.scale((int)300));
        }
        column.setMinWidth(rootWidth);
        column.setMaxWidth(rootWidth);
        column.setPreferredWidth(rootWidth);
    }

    public void rootColumnUpdated() {
        this.setRootColumnSize();
        this.reLayout();
        this.repaint();
    }

    public String getToolTipText(@NotNull MouseEvent event) {
        Object path2;
        if (event == null) {
            VcsLogGraphTable.$$$reportNull$$$0(26);
        }
        int row2 = this.rowAtPoint(event.getPoint());
        VcsLogColumn<?> column = this.getVcsLogColumn(this.columnAtPoint(event.getPoint()));
        if (column == null || row2 < 0) {
            return null;
        }
        if (column == Root.INSTANCE && (path2 = this.getValueAt(row2, VcsLogColumnManager.getInstance().getModelIndex(column))) instanceof FilePath) {
            String clickMessage = this.isShowRootNames() ? VcsLogBundle.message((String)"vcs.log.click.to.collapse.paths.column.tooltip", (Object[])new Object[0]) : VcsLogBundle.message((String)"vcs.log.click.to.expand.paths.column.tooltip", (Object[])new Object[0]);
            return new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)this.myColorManager.getLongName((FilePath)path2)).bold()).br().append(clickMessage).wrapWith(HtmlChunk.html()).toString();
        }
        return null;
    }

    private boolean isShowRootNames() {
        return this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES) && this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES) != false;
    }

    public void jumpToRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex <= this.getRowCount() - 1) {
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
            this.setRowSelectionInterval(rowIndex, rowIndex);
            if (!this.hasFocus()) {
                IdeFocusManager.getInstance((Project)this.myLogData.getProject()).requestFocus((Component)((Object)this), true);
            }
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            VcsLogGraphTable.$$$reportNull$$$0(27);
        }
        return ValueKey.match((String)dataId).ifEq((ValueKey)PlatformDataKeys.COPY_PROVIDER).then((Object)this).ifEq((ValueKey)VcsDataKeys.VCS).thenGet(() -> {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length == 0 || selectedRows.length > 1000) {
                return null;
            }
            Set roots = ContainerUtil.map2Set((Collection)Ints.asList((int[])selectedRows), row2 -> this.getModel().getRootAtRow((int)row2));
            if (roots.size() == 1) {
                return this.myLogData.getLogProvider(Objects.requireNonNull((VirtualFile)ContainerUtil.getFirstItem((Collection)roots))).getSupportedVcs();
            }
            return null;
        }).ifEq((ValueKey)VcsLogDataKeys.VCS_LOG_BRANCHES).thenGet(() -> {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length != 1) {
                return null;
            }
            return this.getModel().getBranchesAtRow(selectedRows[0]);
        }).ifEq((ValueKey)VcsLogDataKeys.VCS_LOG_REFS).thenGet(() -> {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length != 1) {
                return null;
            }
            return this.getModel().getRefsAtRow(selectedRows[0]);
        }).ifEq((ValueKey)VcsDataKeys.PRESET_COMMIT_MESSAGE).thenGet(() -> {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < Math.min(1000, selectedRows.length); ++i) {
                sb.append(this.getModel().getValueAt(selectedRows[i], Commit.INSTANCE).toString());
                if (i == selectedRows.length - 1) continue;
                sb.append("\n");
            }
            return sb.toString();
        }).orNull();
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            VcsLogGraphTable.$$$reportNull$$$0(28);
        }
        StringBuilder sb = new StringBuilder();
        List<Integer> visibleColumns = this.getVisibleColumns();
        int[] selectedRows = this.getSelectedRows();
        for (int i = 0; i < Math.min(1000, selectedRows.length); ++i) {
            int row2 = selectedRows[i];
            sb.append(StringUtil.join(visibleColumns, j -> {
                if (j.intValue() == VcsLogColumnManager.getInstance().getModelIndex(Root.INSTANCE)) {
                    return "";
                }
                return this.getModel().getValueAt(row2, (int)j).toString();
            }, (String)" "));
            if (i == selectedRows.length - 1) continue;
            sb.append("\n");
        }
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(sb.toString()));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            VcsLogGraphTable.$$$reportNull$$$0(29);
        }
        return this.getSelectedRowCount() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            VcsLogGraphTable.$$$reportNull$$$0(30);
        }
        return true;
    }

    public void addHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            VcsLogGraphTable.$$$reportNull$$$0(31);
        }
        this.myHighlighters.add(highlighter);
        highlighter.update((VcsLogDataPack)this.getModel().getVisiblePack(), true);
    }

    public void removeHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            VcsLogGraphTable.$$$reportNull$$$0(32);
        }
        this.myHighlighters.remove(highlighter);
    }

    public void removeAllHighlighters() {
        this.myHighlighters.clear();
    }

    @NotNull
    public SimpleTextAttributes applyHighlighters(@NotNull Component rendererComponent, int row2, int column, boolean hasFocus, boolean selected) {
        if (rendererComponent == null) {
            VcsLogGraphTable.$$$reportNull$$$0(33);
        }
        VcsLogHighlighter.VcsCommitStyle style = this.getStyle(row2, column, hasFocus, selected, row2 == TableHoverListener.getHoveredRow((JTable)((Object)this)));
        assert (style.getBackground() != null && style.getForeground() != null && style.getTextStyle() != null);
        rendererComponent.setBackground(style.getBackground());
        rendererComponent.setForeground(style.getForeground());
        switch (style.getTextStyle()) {
            case BOLD: {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                if (simpleTextAttributes == null) {
                    VcsLogGraphTable.$$$reportNull$$$0(34);
                }
                return simpleTextAttributes;
            }
            case ITALIC: {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES;
                if (simpleTextAttributes == null) {
                    VcsLogGraphTable.$$$reportNull$$$0(35);
                }
                return simpleTextAttributes;
            }
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            VcsLogGraphTable.$$$reportNull$$$0(36);
        }
        return simpleTextAttributes;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getBaseStyle(int row2, int column, boolean hasFocus, boolean selected) {
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = this.myBaseStyleProvider.getBaseStyle(row2, column, hasFocus, selected);
        if (vcsCommitStyle == null) {
            VcsLogGraphTable.$$$reportNull$$$0(37);
        }
        return vcsCommitStyle;
    }

    @NotNull
    VcsLogHighlighter.VcsCommitStyle getStyle(int row2, int column, boolean hasFocus, boolean selected, boolean hovered) {
        VcsLogHighlighter.VcsCommitStyle baseStyle = this.getBaseStyle(row2, column, hasFocus, selected);
        VisibleGraph<Integer> visibleGraph = this.getVisibleGraph();
        if (row2 < 0 || row2 >= visibleGraph.getVisibleCommitCount()) {
            LOG.error("Visible graph has " + visibleGraph.getVisibleCommitCount() + " commits, yet we want row " + row2);
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = baseStyle;
            if (vcsCommitStyle == null) {
                VcsLogGraphTable.$$$reportNull$$$0(38);
            }
            return vcsCommitStyle;
        }
        RowInfo rowInfo = visibleGraph.getRowInfo(row2);
        VcsLogHighlighter.VcsCommitStyle style = VcsCommitStyleFactory.createStyle((Color)(rowInfo.getRowType() == RowType.UNMATCHED ? JBColor.GRAY : baseStyle.getForeground()), (Color)baseStyle.getBackground(), (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
        int commitId = (Integer)rowInfo.getCommit();
        VcsShortCommitDetails details = this.myLogData.getMiniDetailsGetter().getCommitDataIfAvailable(commitId);
        if (details != null) {
            List styles = ContainerUtil.map(this.myHighlighters, highlighter -> highlighter.getStyle(commitId, details, selected));
            style = VcsCommitStyleFactory.combine((Collection)ContainerUtil.append((List)styles, (Object[])new VcsLogHighlighter.VcsCommitStyle[]{style}));
        }
        if (!selected && hovered) {
            Color background = Objects.requireNonNull(style.getBackground());
            VcsLogHighlighter.VcsCommitStyle lightSelectionBgStyle = VcsCommitStyleFactory.background((Color)VcsLogGraphTable.getHoveredBackgroundColor(background));
            style = VcsCommitStyleFactory.combine(Arrays.asList(lightSelectionBgStyle, style));
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = style;
        if (vcsCommitStyle == null) {
            VcsLogGraphTable.$$$reportNull$$$0(39);
        }
        return vcsCommitStyle;
    }

    @Nullable
    protected Color getHoveredRowBackground() {
        return null;
    }

    public void viewportSet(JViewport viewport) {
        viewport.addChangeListener(e -> {
            if (this.isShowRootNames()) {
                GraphTableModel model = this.getModel();
                Couple visibleRows = ScrollingUtil.getVisibleRows((JTable)((Object)this));
                if ((Integer)visibleRows.first >= 0) {
                    TableModelEvent evt = new TableModelEvent(model, (Integer)visibleRows.first, (Integer)visibleRows.second, VcsLogColumnManager.getInstance().getModelIndex(Root.INSTANCE));
                    model.fireTableChanged(evt);
                }
            }
            this.mySelection = null;
        });
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        Component layeredPane2 = ComponentUtil.findParentByCondition((Component)((Object)this), component -> component instanceof LoadingDecorator.CursorAware);
        if (layeredPane2 != null) {
            layeredPane2.setCursor(cursor);
        }
    }

    @NotNull
    public GraphTableModel getModel() {
        GraphTableModel graphTableModel = (GraphTableModel)super.getModel();
        if (graphTableModel == null) {
            VcsLogGraphTable.$$$reportNull$$$0(40);
        }
        return graphTableModel;
    }

    @NotNull
    public Selection getSelection() {
        if (this.mySelection == null) {
            this.mySelection = new Selection(this);
        }
        Selection selection = this.mySelection;
        if (selection == null) {
            VcsLogGraphTable.$$$reportNull$$$0(41);
        }
        return selection;
    }

    public void handleAnswer(@NotNull GraphAnswer<Integer> answer) {
        if (answer == null) {
            VcsLogGraphTable.$$$reportNull$$$0(42);
        }
        GraphCommitCellController controller = (GraphCommitCellController)Objects.requireNonNull(this.getController(Commit.INSTANCE));
        Cursor cursor = controller.handleGraphAnswer(answer, true, null, null);
        this.myMouseAdapter.handleCursor(cursor);
    }

    public void showTooltip(int row2, @NotNull VcsLogColumn<?> column) {
        if (column == null) {
            VcsLogGraphTable.$$$reportNull$$$0(43);
        }
        if (column != Commit.INSTANCE) {
            return;
        }
        GraphCommitCellController controller = (GraphCommitCellController)Objects.requireNonNull(this.getController(column));
        controller.showTooltip(row2);
    }

    public void setCompactReferencesView(boolean compact) {
        this.myGraphCommitCellRenderer.setCompactReferencesView(compact);
        this.repaint();
    }

    public void setShowTagNames(boolean showTagsNames) {
        this.myGraphCommitCellRenderer.setShowTagsNames(showTagsNames);
        this.repaint();
    }

    public void setLabelsLeftAligned(boolean leftAligned) {
        this.myGraphCommitCellRenderer.setLeftAligned(leftAligned);
        this.repaint();
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        VisibleGraph<Integer> visibleGraph = this.getModel().getVisiblePack().getVisibleGraph();
        if (visibleGraph == null) {
            VcsLogGraphTable.$$$reportNull$$$0(44);
        }
        return visibleGraph;
    }

    public TableCellEditor getCellEditor() {
        return this.myDummyEditor;
    }

    public int getRowHeight() {
        return this.myGraphCommitCellRenderer.getPreferredHeight();
    }

    @Override
    protected void paintFooter(@NotNull Graphics g, int x, int y, int width, int height) {
        if (g == null) {
            VcsLogGraphTable.$$$reportNull$$$0(45);
        }
        this.paintTopBottomBorder(g, x, y, width, height, false);
    }

    private void paintTopBottomBorder(@NotNull Graphics g, int x, int y, int width, int height, boolean isTopBorder) {
        int targetRow;
        if (g == null) {
            VcsLogGraphTable.$$$reportNull$$$0(46);
        }
        int n = targetRow = isTopBorder ? 0 : this.getRowCount() - 1;
        if (targetRow >= 0 && targetRow < this.getRowCount()) {
            g.setColor(this.getStyle(targetRow, this.getColumnViewIndex(Commit.INSTANCE), this.hasFocus(), false, false).getBackground());
            g.fillRect(x, y, width, height);
            if (this.myColorManager.hasMultiplePaths()) {
                g.setColor((Color)VcsLogGraphTable.getPathBackgroundColor(this.getModel().getValueAt(targetRow, Root.INSTANCE), this.myColorManager));
                int rootWidth = this.getRootColumn().getWidth();
                if (!this.isShowRootNames()) {
                    rootWidth -= JBUIScale.scale((int)5);
                }
                g.fillRect(x, y, rootWidth, height);
            }
        } else {
            g.setColor(this.getBaseStyle(targetRow, this.getColumnViewIndex(Commit.INSTANCE), this.hasFocus(), false).getBackground());
            g.fillRect(x, y, width, height);
        }
    }

    @NotNull
    public Border createTopBottomBorder(int top, int bottom) {
        return new MyTopBottomBorder(top, bottom);
    }

    public boolean isResizingColumns() {
        return this.getCursor() == Cursor.getPredefinedCursor(11);
    }

    @NotNull
    private static Color getHoveredBackgroundColor(@NotNull Color background) {
        int alpha;
        if (background == null) {
            VcsLogGraphTable.$$$reportNull$$$0(47);
        }
        if ((alpha = HOVERED_BACKGROUND.getAlpha()) == 255) {
            Color color = HOVERED_BACKGROUND;
            if (color == null) {
                VcsLogGraphTable.$$$reportNull$$$0(48);
            }
            return color;
        }
        if (alpha == 0) {
            Color color = background;
            if (color == null) {
                VcsLogGraphTable.$$$reportNull$$$0(49);
            }
            return color;
        }
        Color color = ColorUtil.mix((Color)new Color(HOVERED_BACKGROUND.getRGB()), (Color)background, (double)((double)alpha / 255.0));
        if (color == null) {
            VcsLogGraphTable.$$$reportNull$$$0(50);
        }
        return color;
    }

    @NotNull
    public static JBColor getRootBackgroundColor(@NotNull VirtualFile root, @NotNull VcsLogColorManager colorManager) {
        if (root == null) {
            VcsLogGraphTable.$$$reportNull$$$0(51);
        }
        if (colorManager == null) {
            VcsLogGraphTable.$$$reportNull$$$0(52);
        }
        JBColor jBColor = VcsLogColorManagerImpl.getBackgroundColor(colorManager.getRootColor(root));
        if (jBColor == null) {
            VcsLogGraphTable.$$$reportNull$$$0(53);
        }
        return jBColor;
    }

    @NotNull
    public static JBColor getPathBackgroundColor(@NotNull FilePath filePath, @NotNull VcsLogColorManager colorManager) {
        if (filePath == null) {
            VcsLogGraphTable.$$$reportNull$$$0(54);
        }
        if (colorManager == null) {
            VcsLogGraphTable.$$$reportNull$$$0(55);
        }
        JBColor jBColor = VcsLogColorManagerImpl.getBackgroundColor(colorManager.getPathColor(filePath));
        if (jBColor == null) {
            VcsLogGraphTable.$$$reportNull$$$0(56);
        }
        return jBColor;
    }

    static Font getTableFont() {
        return UIManager.getFont("Table.font");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestMore";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable";
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clickPoint";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsLogColumn";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rendererComponent";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableColumn";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogData";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootColumn";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitColumn";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "applyHighlighters";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseStyle";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleGraph";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getHoveredBackgroundColor";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootBackgroundColor";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathBackgroundColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setErrorEmptyText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendActionToEmptyText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 56: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "forceReLayout";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resetColumnWidth";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getColumnWidthFromData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getColumnViewIndex";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTableColumn";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getController";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPointInCell";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getToolTipText";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighter";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlighter";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "applyHighlighters";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "handleAnswer";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "paintFooter";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "paintTopBottomBorder";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getHoveredBackgroundColor";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getRootBackgroundColor";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getPathBackgroundColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 48: 
            case 49: 
            case 50: 
            case 53: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCurrentColumnsListener
    implements VcsLogColumnManager.CurrentColumnsListener {
        private MyCurrentColumnsListener() {
        }

        @Override
        public void columnAdded(@NotNull VcsLogColumn<?> column) {
            if (column == null) {
                MyCurrentColumnsListener.$$$reportNull$$$0(0);
            }
            VcsLogGraphTable.this.onColumnOrderSettingChanged();
        }

        @Override
        public void columnRemoved(@NotNull VcsLogColumn<?> column) {
            if (column == null) {
                MyCurrentColumnsListener.$$$reportNull$$$0(1);
            }
            VcsLogGraphTable.this.myTableColumns.remove(column);
            VcsLogGraphTable.this.myInitializedColumns.remove(column);
            VcsLogGraphTable.this.onColumnOrderSettingChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "column";
            objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyCurrentColumnsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "columnAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "columnRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyTopBottomBorder
    implements Border {
        @NotNull
        private final JBInsets myInsets;

        private MyTopBottomBorder(int top, int bottom) {
            this.myInsets = JBUI.insets((int)top, (int)0, (int)bottom, (int)0);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.myInsets.top > 0) {
                VcsLogGraphTable.this.paintTopBottomBorder(g, x, y, width, this.myInsets.top, true);
            }
            if (this.myInsets.bottom > 0) {
                VcsLogGraphTable.this.paintTopBottomBorder(g, x, y + height - this.myInsets.bottom, width, this.myInsets.bottom, false);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.myInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class MyTableColumnModel
    extends DefaultTableColumnModel {
        @NotNull
        private final VcsLogUiProperties myProperties;

        MyTableColumnModel(VcsLogUiProperties properties) {
            if (properties == null) {
                MyTableColumnModel.$$$reportNull$$$0(0);
            }
            this.myProperties = properties;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (VcsLogGraphTable.this.getTableHeader().getResizingColumn() == null) {
                return;
            }
            if ("width".equals(evt.getPropertyName())) {
                for (VcsLogColumn<?> logColumn : VcsLogColumnManager.getInstance().getCurrentDynamicColumns()) {
                    TableColumn column = VcsLogGraphTable.this.getTableColumn(logColumn);
                    if (!evt.getSource().equals(column)) continue;
                    VcsLogColumnUtilKt.setWidth(logColumn, this.myProperties, column.getWidth());
                }
            }
            super.propertyChange(evt);
        }

        @Override
        public void moveColumn(int columnIndex, int newIndex) {
            VcsLogColumn<?> column = VcsLogGraphTable.this.getVcsLogColumn(columnIndex);
            if (column == null || column == Root.INSTANCE || VcsLogGraphTable.this.getVcsLogColumn(newIndex) == Root.INSTANCE || !VcsLogColumnUtilKt.supportsColumnsReordering(this.myProperties)) {
                return;
            }
            super.moveColumn(columnIndex, newIndex);
            VcsLogColumnUtilKt.moveColumn(this.myProperties, column, newIndex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyTableColumnModel", "<init>"));
        }
    }

    private class MyProgressListener
    implements VcsLogProgress.ProgressListener {
        private MyProgressListener() {
        }

        @Override
        public void progressStarted(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
            if (keys == null) {
                MyProgressListener.$$$reportNull$$$0(0);
            }
            this.progressChanged(keys);
        }

        @Override
        public void progressChanged(@NotNull Collection<? extends VcsLogProgress.ProgressKey> keys) {
            if (keys == null) {
                MyProgressListener.$$$reportNull$$$0(1);
            }
            if (VcsLogUiUtil.isProgressVisible(keys, VcsLogGraphTable.this.myId)) {
                VcsLogGraphTable.this.getEmptyText().setText(VcsLogBundle.message((String)"vcs.log.loading.status", (Object[])new Object[0]));
            } else {
                VcsLogGraphTable.this.updateEmptyText();
            }
        }

        @Override
        public void progressStopped() {
            VcsLogGraphTable.this.updateEmptyText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "keys";
            objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyProgressListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "progressStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "progressChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDummyTableCellEditor
    implements TableCellEditor {
        private MyDummyTableCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row2, int column) {
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return false;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            if (!(anEvent instanceof MouseEvent)) {
                return true;
            }
            MouseEvent e = (MouseEvent)anEvent;
            int row2 = VcsLogGraphTable.this.rowAtPoint(e.getPoint());
            if (row2 < 0 || row2 >= VcsLogGraphTable.this.getRowCount()) {
                return true;
            }
            VcsLogColumn<?> column = VcsLogGraphTable.this.getVcsLogColumn(VcsLogGraphTable.this.columnAtPoint(e.getPoint()));
            if (column == null) {
                return true;
            }
            VcsLogCellController controller = VcsLogGraphTable.this.getController(column);
            if (controller == null) {
                return true;
            }
            return controller.shouldSelectCell(row2, e);
        }

        @Override
        public boolean stopCellEditing() {
            return false;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private static final int BORDER_THICKNESS = 3;
        @NotNull
        private final TableLinkMouseListener myLinkListener = new MyLinkMouseListener();
        @Nullable
        private Cursor myLastCursor = null;

        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            VcsLogCellController controller;
            int row2;
            if (this.myLinkListener.onClick(e, e.getClickCount())) {
                return;
            }
            int c = VcsLogGraphTable.this.columnAtPoint(e.getPoint());
            VcsLogColumn<?> column = VcsLogGraphTable.this.getVcsLogColumn(c);
            if (column == null) {
                return;
            }
            if (e.getClickCount() == 2) {
                boolean useLeftBorder;
                int commitColumnIndex = VcsLogGraphTable.this.getColumnViewIndex(Commit.INSTANCE);
                boolean bl = useLeftBorder = c > commitColumnIndex;
                if ((useLeftBorder ? this.isOnLeftBorder(e, c) : this.isOnRightBorder(e, c)) && column.isDynamic()) {
                    VcsLogGraphTable.this.resetColumnWidth(column);
                } else {
                    int c2 = VcsLogGraphTable.this.columnAtPoint(new Point(e.getPoint().x + (useLeftBorder ? 1 : -1) * JBUIScale.scale((int)3), e.getPoint().y));
                    VcsLogColumn<?> column2 = VcsLogGraphTable.this.getVcsLogColumn(c2);
                    if (column2 != null && (useLeftBorder ? this.isOnLeftBorder(e, c2) : this.isOnRightBorder(e, c2)) && column2.isDynamic()) {
                        VcsLogGraphTable.this.resetColumnWidth(column2);
                    }
                }
            }
            if ((row2 = VcsLogGraphTable.this.rowAtPoint(e.getPoint())) >= 0 && row2 < VcsLogGraphTable.this.getRowCount() && e.getClickCount() == 1 && (controller = VcsLogGraphTable.this.getController(column)) != null) {
                Cursor cursor = controller.performMouseClick(row2, e);
                this.handleCursor(cursor);
            }
        }

        public boolean isOnLeftBorder(@NotNull MouseEvent e, int column) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(0);
            }
            return Math.abs(VcsLogGraphTable.this.getColumnLeftXCoordinate(column) - e.getPoint().x) <= JBUIScale.scale((int)3);
        }

        public boolean isOnRightBorder(@NotNull MouseEvent e, int column) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(1);
            }
            return Math.abs(VcsLogGraphTable.this.getColumnLeftXCoordinate(column) + VcsLogGraphTable.this.getColumnModel().getColumn(column).getWidth() - e.getPoint().x) <= JBUIScale.scale((int)3);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (VcsLogGraphTable.this.getRowCount() == 0) {
                return;
            }
            if (VcsLogGraphTable.this.isResizingColumns()) {
                return;
            }
            VcsLogGraphTable.this.getExpandableItemsHandler().setEnabled(true);
            if (this.myLinkListener.getTagAt(e) != null) {
                this.swapCursor();
                return;
            }
            int row2 = VcsLogGraphTable.this.rowAtPoint(e.getPoint());
            if (row2 >= 0 && row2 < VcsLogGraphTable.this.getRowCount()) {
                VcsLogColumn<?> column = VcsLogGraphTable.this.getVcsLogColumn(VcsLogGraphTable.this.columnAtPoint(e.getPoint()));
                if (column == null) {
                    return;
                }
                VcsLogCellController controller = VcsLogGraphTable.this.getController(column);
                if (controller != null) {
                    Cursor cursor = controller.performMouseMove(row2, e);
                    this.handleCursor(cursor);
                    return;
                }
            }
            this.restoreCursor();
        }

        private void handleCursor(@Nullable Cursor cursor) {
            if (cursor != null) {
                if (cursor.getType() == 0) {
                    this.restoreCursor();
                } else if (cursor.getType() == 12) {
                    this.swapCursor();
                }
            }
        }

        private void swapCursor() {
            if (VcsLogGraphTable.this.getCursor().getType() != 12 && this.myLastCursor == null) {
                Cursor newCursor = Cursor.getPredefinedCursor(12);
                this.myLastCursor = VcsLogGraphTable.this.getCursor();
                VcsLogGraphTable.this.setCursor(newCursor);
            }
        }

        private void restoreCursor() {
            if (VcsLogGraphTable.this.getCursor().getType() != 0) {
                VcsLogGraphTable.this.setCursor(UIUtil.cursorIfNotDefault((Cursor)this.myLastCursor));
                this.myLastCursor = null;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            VcsLogGraphTable.this.getExpandableItemsHandler().setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyMouseAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOnLeftBorder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOnRightBorder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyLinkMouseListener
        extends SimpleColoredComponentLinkMouseListener {
            private MyLinkMouseListener() {
            }

            @Override
            @Nullable
            public Object getTagAt(@NotNull MouseEvent e) {
                if (e == null) {
                    MyLinkMouseListener.$$$reportNull$$$0(0);
                }
                return ObjectUtils.tryCast((Object)super.getTagAt(e), SimpleColoredComponent.BrowserLauncherTag.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/VcsLogGraphTable$MyMouseAdapter$MyLinkMouseListener", "getTagAt"));
            }
        }
    }

    private static class BaseStyleProvider {
        @NotNull
        private final JTable myTable;
        @NotNull
        private final TableCellRenderer myDummyRenderer;

        BaseStyleProvider(@NotNull JTable table) {
            if (table == null) {
                BaseStyleProvider.$$$reportNull$$$0(0);
            }
            this.myDummyRenderer = new DefaultTableCellRenderer();
            this.myTable = table;
        }

        @NotNull
        public VcsLogHighlighter.VcsCommitStyle getBaseStyle(int row2, int column, boolean hasFocus, boolean selected) {
            Component dummyRendererComponent = this.myDummyRenderer.getTableCellRendererComponent(this.myTable, "", selected, hasFocus, row2, column);
            Color background = selected ? (this.myTable.hasFocus() ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.getListSelectionBackground((boolean)false)) : UIUtil.getListBackground();
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.createStyle((Color)dummyRendererComponent.getForeground(), (Color)background, (VcsLogHighlighter.TextStyle)VcsLogHighlighter.TextStyle.NORMAL);
            if (vcsCommitStyle == null) {
                BaseStyleProvider.$$$reportNull$$$0(1);
            }
            return vcsCommitStyle;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$BaseStyleProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/table/VcsLogGraphTable$BaseStyleProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBaseStyle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

