/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u0018\u001a\u00020\b*\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/ui/actions/GoToParentOrChildAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "parent", "", "(Z)V", "getParent", "()Z", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "ui", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "rows", "", "", "getActionText", "", "commitMetadata", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getRowsToJump", "update", "triggerUsage", "intellij.platform.vcs.log.impl"})
public class GoToParentOrChildAction
extends DumbAwareAction {
    private final boolean parent;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VcsLogUiEx ui2 = (VcsLogUiEx)e.getData(VcsLogInternalDataKeys.LOG_UI_EX);
        if (ui2 == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setVisible(true);
        if (e.getInputEvent() instanceof KeyEvent) {
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            VcsLogGraphTable vcsLogGraphTable = ui2.getTable();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)vcsLogGraphTable), (String)"ui.table");
            presentation2.setEnabled(vcsLogGraphTable.isFocusOwner());
        } else {
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            Collection collection = this.getRowsToJump(ui2);
            boolean bl = false;
            presentation3.setEnabled(!collection.isEmpty());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.triggerUsage(this, e);
        Object object = e.getRequiredData(VcsLogInternalDataKeys.LOG_UI_EX);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(VcsLog\u2026ternalDataKeys.LOG_UI_EX)");
        VcsLogUiEx ui2 = (VcsLogUiEx)object;
        List<Integer> rows = this.getRowsToJump(ui2);
        if (rows.isEmpty()) {
            return;
        }
        if (rows.size() == 1) {
            VcsLogUtil.jumpToRow(ui2, ((Number)CollectionsKt.single(rows)).intValue(), false);
        } else {
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(this.parent ? VcsLogBundle.message((String)"action.go.to.select.parent.to.navigate", (Object[])new Object[0]) : VcsLogBundle.message((String)"action.go.to.select.child.to.navigate", (Object[])new Object[0]), this.createGroup(ui2, rows), e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, false);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"JBPopupFactory.getInstan\u2026tionAid.NUMBERING, false)");
            ListPopup popup = listPopup;
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ActionGroup createGroup(VcsLogUiEx ui2, List<Integer> rows) {
        void $this$mapTo$iv;
        Iterable iterable = rows;
        boolean bl = false;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void row2;
            int n = ((Number)item$iv).intValue();
            Collection collection = destination$iv;
            boolean bl2 = false;
            VcsLogGraphTable vcsLogGraphTable = ui2.getTable();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)vcsLogGraphTable), (String)"ui.table");
            VcsCommitMetadata vcsCommitMetadata = vcsLogGraphTable.getModel().getCommitMetadata((int)row2);
            Intrinsics.checkNotNullExpressionValue((Object)vcsCommitMetadata, (String)"ui.table.model.getCommitMetadata(row)");
            String text2 = this.getActionText(vcsCommitMetadata);
            DumbAwareAction dumbAwareAction = new DumbAwareAction((int)row2, text2, text2, VcsLogBundle.message((String)"action.go.to.navigate.to", (Object[])new Object[]{text2}), null, this, ui2){
                final /* synthetic */ int $row;
                final /* synthetic */ String $text;
                final /* synthetic */ GoToParentOrChildAction this$0;
                final /* synthetic */ VcsLogUiEx $ui$inlined;
                {
                    this.$row = $captured_local_variable$1;
                    this.$text = $captured_local_variable$2;
                    this.this$0 = goToParentOrChildAction;
                    this.$ui$inlined = vcsLogUiEx;
                    super($super_call_param$3, $super_call_param$4, $super_call_param$5);
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    GoToParentOrChildAction.access$triggerUsage(this.this$0, this, e);
                    VcsLogUtil.jumpToRow(this.$ui$inlined, this.$row, false);
                }
            };
            collection.add(dumbAwareAction);
        }
        List actions = (List)destination$iv;
        return (ActionGroup)new DefaultActionGroup(actions);
    }

    private final void triggerUsage(DumbAwareAction $this$triggerUsage, AnActionEvent e) {
        VcsLogUsageTriggerCollector.triggerUsage(e, $this$triggerUsage, new Consumer<FeatureUsageData>(this){
            final /* synthetic */ GoToParentOrChildAction this$0;

            public final void accept(FeatureUsageData data) {
                data.addData("parent_commit", this.this$0.getParent());
            }
            {
                this.this$0 = goToParentOrChildAction;
            }
        });
    }

    @NlsActions.ActionText
    private final String getActionText(VcsCommitMetadata commitMetadata) {
        if (!(commitMetadata instanceof LoadingDetails)) {
            long time = commitMetadata.getAuthorTime();
            String commitMessage2 = "\"" + StringUtil.shortenTextWithEllipsis((String)commitMetadata.getSubject(), (int)40, (int)0, (String)"...") + "\"";
            String string = VcsLogBundle.message((String)"action.go.to.select.hash.subject.author.date.time", (Object[])new Object[]{((Hash)commitMetadata.getId()).toShortString(), commitMessage2, CommitPresentationUtil.getAuthorPresentation((VcsShortCommitDetails)commitMetadata), DateFormatUtil.formatDate((long)time), DateFormatUtil.formatTime((long)time)});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VcsLogBundle.message(\"ac\u2026matUtil.formatTime(time))");
            return string;
        }
        String string = ((LoadingDetails)commitMetadata).getId().toShortString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"commitMetadata.id.toShortString()");
        return string;
    }

    private final List<Integer> getRowsToJump(VcsLogUiEx ui2) {
        VcsLogGraphTable vcsLogGraphTable = ui2.getTable();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)vcsLogGraphTable), (String)"ui.table");
        int[] selectedRows = vcsLogGraphTable.getSelectedRows();
        if (selectedRows.length != 1) {
            return CollectionsKt.emptyList();
        }
        VisiblePack visiblePack = ui2.getDataPack();
        Intrinsics.checkNotNullExpressionValue((Object)visiblePack, (String)"ui.dataPack");
        VisibleGraph<Integer> visibleGraph = visiblePack.getVisibleGraph();
        Intrinsics.checkNotNullExpressionValue((Object)selectedRows, (String)"selectedRows");
        List list = visibleGraph.getRowInfo(ArraysKt.single((int[])selectedRows)).getAdjacentRows(this.parent);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ui.dataPack.visibleGraph\u2026).getAdjacentRows(parent)");
        return CollectionsKt.sorted((Iterable)list);
    }

    public final boolean getParent() {
        return this.parent;
    }

    public GoToParentOrChildAction(boolean parent) {
        this.parent = parent;
    }

    public static final /* synthetic */ void access$triggerUsage(GoToParentOrChildAction $this, DumbAwareAction $this$access_u24triggerUsage, AnActionEvent e) {
        $this.triggerUsage($this$access_u24triggerUsage, e);
    }
}

