/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.navigation.History;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPanel
extends JBPanel
implements DataProvider {
    @NotNull
    private final VcsLogManager myManager;
    @NotNull
    private final VcsLogUiEx myUi;

    public VcsLogPanel(@NotNull VcsLogManager manager, @NotNull VcsLogUiEx logUi) {
        if (manager == null) {
            VcsLogPanel.$$$reportNull$$$0(0);
        }
        if (logUi == null) {
            VcsLogPanel.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout());
        this.myManager = manager;
        this.myUi = logUi;
        this.add(this.myUi.getMainComponent(), "Center");
    }

    @NotNull
    public VcsLogUiEx getUi() {
        VcsLogUiEx vcsLogUiEx = this.myUi;
        if (vcsLogUiEx == null) {
            VcsLogPanel.$$$reportNull$$$0(2);
        }
        return vcsLogUiEx;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            VcsLogPanel.$$$reportNull$$$0(3);
        }
        if (VcsLogInternalDataKeys.LOG_MANAGER.is(dataId)) {
            return this.myManager;
        }
        if (VcsLogDataKeys.VCS_LOG.is(dataId)) {
            return this.myUi.getVcsLog();
        }
        if (VcsLogDataKeys.VCS_LOG_UI.is(dataId)) {
            return this.myUi;
        }
        if (VcsLogDataKeys.VCS_LOG_DATA_PROVIDER.is(dataId) || VcsLogInternalDataKeys.LOG_DATA.is(dataId)) {
            return this.myManager.getDataManager();
        }
        if (VcsDataKeys.VCS_REVISION_NUMBER.is(dataId)) {
            List hashes = this.myUi.getVcsLog().getSelectedCommits();
            if (hashes.isEmpty()) {
                return null;
            }
            return VcsLogUtil.convertToRevisionNumber(Objects.requireNonNull((CommitId)ContainerUtil.getFirstItem((List)hashes)).getHash());
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(dataId)) {
            List hashes = this.myUi.getVcsLog().getSelectedCommits();
            if (hashes.size() > 1000) {
                return null;
            }
            return ContainerUtil.map((Collection)hashes, commitId -> VcsLogUtil.convertToRevisionNumber(commitId.getHash())).toArray(new VcsRevisionNumber[0]);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myUi.getHelpId();
        }
        if (History.KEY.is(dataId)) {
            return this.myUi.getNavigationHistory();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

