/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import gnu.trove.TIntHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MiniDetailsGetter
extends AbstractDataGetter<VcsCommitMetadata> {
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final VcsLogObjectsFactory myFactory;

    MiniDetailsGetter(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull VcsLogIndex index, @NotNull Disposable parentDisposable) {
        if (project == null) {
            MiniDetailsGetter.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            MiniDetailsGetter.$$$reportNull$$$0(1);
        }
        if (logProviders == null) {
            MiniDetailsGetter.$$$reportNull$$$0(2);
        }
        if (topCommitsDetailsCache == null) {
            MiniDetailsGetter.$$$reportNull$$$0(3);
        }
        if (index == null) {
            MiniDetailsGetter.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            MiniDetailsGetter.$$$reportNull$$$0(5);
        }
        super(storage, logProviders, index, parentDisposable);
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myFactory = (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
    }

    @RequiresBackgroundThread
    public void loadCommitsData(@NotNull Iterable<Integer> hashes, @NotNull Consumer<? super VcsCommitMetadata> consumer, @NotNull ProgressIndicator indicator) throws VcsException {
        if (hashes == null) {
            MiniDetailsGetter.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            MiniDetailsGetter.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            MiniDetailsGetter.$$$reportNull$$$0(8);
        }
        TIntHashSet toLoad = new TIntHashSet();
        for (int id : hashes) {
            VcsCommitMetadata details = (VcsCommitMetadata)this.getFromCache(id);
            if (details == null || details instanceof LoadingDetails) {
                toLoad.add(id);
                continue;
            }
            consumer.consume((Object)details);
        }
        if (!toLoad.isEmpty()) {
            indicator.checkCanceled();
            this.preLoadCommitData(toLoad, consumer);
            this.notifyLoaded();
        }
    }

    @Override
    @Nullable
    protected VcsCommitMetadata getFromAdditionalCache(int commitId) {
        return this.myTopCommitsDetailsCache.get(commitId);
    }

    @Override
    protected void readDetails(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsCommitMetadata> consumer) throws VcsException {
        if (logProvider == null) {
            MiniDetailsGetter.$$$reportNull$$$0(9);
        }
        if (root == null) {
            MiniDetailsGetter.$$$reportNull$$$0(10);
        }
        if (hashes == null) {
            MiniDetailsGetter.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            MiniDetailsGetter.$$$reportNull$$$0(12);
        }
        logProvider.readMetadata(root, hashes, consumer);
    }

    @Override
    protected void preLoadCommitData(@NotNull TIntHashSet commits, @NotNull Consumer<? super VcsCommitMetadata> consumer) throws VcsException {
        IndexDataGetter dataGetter;
        if (commits == null) {
            MiniDetailsGetter.$$$reportNull$$$0(13);
        }
        if (consumer == null) {
            MiniDetailsGetter.$$$reportNull$$$0(14);
        }
        if ((dataGetter = this.myIndex.getDataGetter()) == null) {
            super.preLoadCommitData(commits, consumer);
            return;
        }
        TIntHashSet notIndexed = new TIntHashSet();
        commits.forEach(commit -> {
            VcsCommitMetadata metadata = IndexedDetails.createMetadata(commit, dataGetter, this.myStorage, this.myFactory);
            if (metadata == null) {
                notIndexed.add(commit);
            } else {
                this.saveInCache(commit, metadata);
                consumer.consume((Object)metadata);
            }
            return true;
        });
        if (!notIndexed.isEmpty()) {
            super.preLoadCommitData(notIndexed, consumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topCommitsDetailsCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 7: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/data/MiniDetailsGetter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "loadCommitsData";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "readDetails";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "preLoadCommitData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

