/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.vcs.commit.AbstractCommitMessagePolicy;
import com.intellij.vcs.commit.ChangeListCommitState;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u0013H\u0002J\u0016\u0010$\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0005R\"\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/commit/SingleChangeListCommitMessagePolicy;", "Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "project", "Lcom/intellij/openapi/project/Project;", "initialCommitMessage", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "<set-?>", "commitMessage", "getCommitMessage", "()Ljava/lang/String;", "defaultNameChangeListMessage", "getDefaultNameChangeListMessage", "setDefaultNameChangeListMessage", "(Ljava/lang/String;)V", "lastChangeListName", "messagesToSave", "", "forgetMessage", "", "()Lkotlin/Unit;", "init", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "includedChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "rememberMessage", "message", "(Ljava/lang/String;)Lkotlin/Unit;", "save", "commitState", "Lcom/intellij/vcs/commit/ChangeListCommitState;", "success", "", "saveMessages", "update", "currentMessage", "intellij.platform.vcs.impl"})
public final class SingleChangeListCommitMessagePolicy
extends AbstractCommitMessagePolicy {
    @Nullable
    private String defaultNameChangeListMessage;
    private String lastChangeListName;
    private final Map<String, String> messagesToSave;
    @Nullable
    private String commitMessage;
    private final String initialCommitMessage;

    @Nullable
    public final String getDefaultNameChangeListMessage() {
        return this.defaultNameChangeListMessage;
    }

    public final void setDefaultNameChangeListMessage(@Nullable String string) {
        this.defaultNameChangeListMessage = string;
    }

    @Nullable
    public final String getCommitMessage() {
        return this.commitMessage;
    }

    public final void init(@NotNull LocalChangeList changeList, @NotNull List<? extends Change> includedChanges) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        Intrinsics.checkNotNullParameter(includedChanges, (String)"includedChanges");
        if (this.getVcsConfiguration().CLEAR_INITIAL_COMMIT_MESSAGE) {
            return;
        }
        this.lastChangeListName = changeList.getName();
        if (this.initialCommitMessage != null) {
            this.defaultNameChangeListMessage = this.initialCommitMessage;
            this.commitMessage = this.initialCommitMessage;
        } else {
            this.commitMessage = this.getCommitMessageFor(changeList);
            CharSequence charSequence = this.commitMessage;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                this.defaultNameChangeListMessage = this.getVcsConfiguration().LAST_COMMIT_MESSAGE;
                String string = this.getCommitMessageFromVcs(includedChanges);
                if (string == null) {
                    string = this.defaultNameChangeListMessage;
                }
                this.commitMessage = string;
            }
        }
    }

    public final void update(@NotNull LocalChangeList changeList, @NotNull String currentMessage) {
        Intrinsics.checkNotNullParameter((Object)changeList, (String)"changeList");
        Intrinsics.checkNotNullParameter((Object)currentMessage, (String)"currentMessage");
        this.commitMessage = currentMessage;
        if (this.getVcsConfiguration().CLEAR_INITIAL_COMMIT_MESSAGE) {
            return;
        }
        if (Intrinsics.areEqual((Object)changeList.getName(), (Object)this.lastChangeListName) ^ true) {
            this.rememberMessage(currentMessage);
            this.lastChangeListName = changeList.getName();
            String string = this.getCommitMessageFor(changeList);
            if (string == null) {
                string = this.defaultNameChangeListMessage;
            }
            this.commitMessage = string;
        }
    }

    public final void save(@NotNull ChangeListCommitState commitState, boolean success2) {
        Intrinsics.checkNotNullParameter((Object)commitState, (String)"commitState");
        this.rememberMessage(commitState.getCommitMessage());
        if (success2) {
            boolean entireChangeListIncluded;
            this.getVcsConfiguration().saveCommitMessage(commitState.getCommitMessage());
            boolean bl = entireChangeListIncluded = commitState.getChangeList().getChanges().size() == commitState.getChanges().size();
            if (!entireChangeListIncluded) {
                this.forgetMessage();
            }
        }
        this.saveMessages();
    }

    private final Unit rememberMessage(String message) {
        Unit unit;
        String string = this.lastChangeListName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.messagesToSave.put(it, message);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final Unit forgetMessage() {
        Unit unit;
        String string = this.lastChangeListName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Map<String, String> map2 = this.messagesToSave;
            boolean bl4 = false;
            map2.remove(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    /*
     * WARNING - void declaration
     */
    private final void saveMessages() {
        Map<String, String> $this$forEach$iv = this.messagesToSave;
        boolean $i$f$forEach = false;
        Map<String, String> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void changeListName;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$changeListName$commitMessage = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$changeListName$commitMessage;
            boolean bl3 = false;
            String string = entry.getKey();
            entry = $dstr$changeListName$commitMessage;
            bl3 = false;
            String commitMessage2 = entry.getValue();
            this.save((String)changeListName, commitMessage2);
        }
    }

    public SingleChangeListCommitMessagePolicy(@NotNull Project project, @Nullable String initialCommitMessage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.initialCommitMessage = initialCommitMessage;
        boolean bl = false;
        this.messagesToSave = new LinkedHashMap();
    }
}

