/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class VcsIntegrationEnabler {
    @NotNull
    protected final Project myProject;
    @NotNull
    private final AbstractVcs myVcs;

    protected VcsIntegrationEnabler(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            VcsIntegrationEnabler.$$$reportNull$$$0(0);
        }
        this.myProject = vcs.getProject();
        this.myVcs = vcs;
    }

    public void enable(@NotNull Collection<? extends VcsRoot> vcsRoots) {
        if (vcsRoots == null) {
            VcsIntegrationEnabler.$$$reportNull$$$0(1);
        }
        Collection roots = vcsRoots.stream().filter(root -> {
            AbstractVcs vcs = root.getVcs();
            return vcs != null && vcs.getName().equals(this.myVcs.getName());
        }).map(VcsRoot::getPath).collect(Collectors.toList());
        VirtualFile projectDir = this.myProject.getBaseDir();
        assert (projectDir != null) : "Base dir is unexpectedly null for project: " + this.myProject;
        if (roots.isEmpty()) {
            boolean succeeded = this.initOrNotifyError(projectDir);
            if (succeeded) {
                this.addVcsRoots(Collections.singleton(projectDir));
            }
        } else {
            if (roots.size() > 1 || this.isProjectBelowVcs(roots)) {
                this.notifyAddedRoots(roots);
            }
            this.addVcsRoots(roots);
        }
    }

    private boolean isProjectBelowVcs(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            VcsIntegrationEnabler.$$$reportNull$$$0(2);
        }
        return ContainerUtil.exists(roots, root -> VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)this.myProject.getBaseDir(), (boolean)true));
    }

    @NotNull
    public static String joinRootsPaths(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            VcsIntegrationEnabler.$$$reportNull$$$0(3);
        }
        String string = StringUtil.join(roots, VirtualFile::getPresentableUrl, (String)", ");
        if (string == null) {
            VcsIntegrationEnabler.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected abstract boolean initOrNotifyError(@NotNull VirtualFile var1);

    protected void notifyAddedRoots(Collection<? extends VirtualFile> roots) {
        String message = VcsBundle.message((String)"roots.notification.content.added.vcs.name.roots", (Object[])new Object[]{this.myVcs.getName(), roots.size(), VcsIntegrationEnabler.joinRootsPaths(roots)});
        VcsNotifier.getInstance(this.myProject).notifySuccess("vcs.root.added", "", message);
    }

    private void addVcsRoots(@NotNull Collection<? extends VirtualFile> roots) {
        if (roots == null) {
            VcsIntegrationEnabler.$$$reportNull$$$0(5);
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        List<VirtualFile> currentVcsRoots = Arrays.asList(vcsManager2.getRootsUnderVcs(this.myVcs));
        ArrayList<VcsDirectoryMapping> mappings = new ArrayList<VcsDirectoryMapping>(vcsManager2.getDirectoryMappings(this.myVcs));
        for (VirtualFile virtualFile : roots) {
            if (currentVcsRoots.contains(virtualFile)) continue;
            mappings.add(new VcsDirectoryMapping(virtualFile.getPath(), this.myVcs.getName()));
        }
        vcsManager2.setDirectoryMappings(mappings);
    }

    protected static void refreshVcsDir(@NotNull VirtualFile projectDir, @NotNull String vcsDirName) {
        if (projectDir == null) {
            VcsIntegrationEnabler.$$$reportNull$$$0(6);
        }
        if (vcsDirName == null) {
            VcsIntegrationEnabler.$$$reportNull$$$0(7);
        }
        LocalFileSystem.getInstance().refreshAndFindFileByPath(projectDir.getPath() + "/" + vcsDirName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoots";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsIntegrationEnabler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsIntegrationEnabler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "joinRootsPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "enable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isProjectBelowVcs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "joinRootsPaths";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addVcsRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "refreshVcsDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

