/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.CustomChangelistTodoTreeStructure;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomChangelistTodosTreeBuilder
extends TodoTreeBuilder {
    public static final TodoItem[] EMPTY_ITEMS = new TodoItem[0];
    private final PsiTodoSearchHelper myPsiTodoSearchHelper;
    private final MultiMap<PsiFile, TodoItem> myMap;
    private final Set<PsiFile> myIncludedFiles;
    @Nullable
    private final Set<String> myIncludedChangeListsIds;

    public CustomChangelistTodosTreeBuilder(@NotNull JTree tree, @NotNull Project project, @NotNull Collection<Change> changes, @NotNull Collection<? extends TodoItem> todoItems) {
        if (tree == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(1);
        }
        if (changes == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(2);
        }
        if (todoItems == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(3);
        }
        super(tree, project);
        this.myPsiTodoSearchHelper = new MyPsiTodoSearchHelper();
        this.myMap = new MultiMap();
        this.myIncludedFiles = CustomChangelistTodosTreeBuilder.collectIncludedFiles(todoItems);
        this.myIncludedChangeListsIds = CustomChangelistTodosTreeBuilder.collectIncludedChangeListsIds(project, changes);
        this.buildMap(todoItems);
    }

    @NotNull
    private static Set<PsiFile> collectIncludedFiles(@NotNull Collection<? extends TodoItem> todoItems) {
        if (todoItems == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(4);
        }
        HashSet<PsiFile> files = new HashSet<PsiFile>();
        for (TodoItem todoItem : todoItems) {
            files.add(todoItem.getFile());
        }
        HashSet<PsiFile> hashSet = files;
        if (hashSet == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @Nullable
    private static Set<String> collectIncludedChangeListsIds(@NotNull Project project, @NotNull Collection<Change> changes) {
        if (project == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(6);
        }
        if (changes == null) {
            CustomChangelistTodosTreeBuilder.$$$reportNull$$$0(7);
        }
        if (!ChangeListManager.getInstance((Project)project).areChangeListsEnabled()) {
            return null;
        }
        HashSet<String> ids = new HashSet<String>();
        for (Change change : changes) {
            if (change instanceof ChangeListChange) {
                ChangeListChange changeListChange = (ChangeListChange)change;
                ids.add(changeListChange.getChangeListId());
                continue;
            }
            return null;
        }
        return ids;
    }

    private void buildMap(Collection<? extends TodoItem> todoItems) {
        this.myMap.clear();
        for (TodoItem todoItem : todoItems) {
            this.myMap.putValue((Object)todoItem.getFile(), (Object)todoItem);
        }
    }

    private TodoItem[] findPatternedTodoItems(PsiFile file, TodoFilter todoFilter) {
        Collection todoItems;
        if (!this.myIncludedFiles.contains(file)) {
            return EMPTY_ITEMS;
        }
        if (this.myDirtyFileSet.contains(file.getVirtualFile())) {
            this.myMap.remove((Object)file);
            Change change = ChangeListManager.getInstance((Project)this.myProject).getChange(file.getVirtualFile());
            if (change != null) {
                TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(this.myProject, Collections.singletonList(change), todoFilter);
                worker.execute();
                Set<TodoItem> todoItems2 = worker.inOneList();
                if (todoItems2 != null && !todoItems2.isEmpty()) {
                    for (TodoItem todoItem : todoItems2) {
                        this.myMap.putValue((Object)file, (Object)todoItem);
                    }
                }
            }
        }
        return (todoItems = this.myMap.get((Object)file)).isEmpty() ? EMPTY_ITEMS : todoItems.toArray(new TodoItem[0]);
    }

    @NotNull
    protected TodoTreeStructure createTreeStructure() {
        return new CustomChangelistTodoTreeStructure(this.myProject, this.myPsiTodoSearchHelper);
    }

    void collectFiles(Processor<? super VirtualFile> collector) {
        PsiFile[] psiFiles;
        TodoTreeStructure treeStructure = this.getTodoTreeStructure();
        for (PsiFile psiFile : psiFiles = this.myPsiTodoSearchHelper.findFilesWithTodoItems()) {
            if (this.myPsiTodoSearchHelper.getTodoItemsCount(psiFile) <= 0 || !treeStructure.accept(psiFile)) continue;
            collector.process((Object)psiFile.getVirtualFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "todoItems";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIncludedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectIncludedFiles";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectIncludedChangeListsIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyPsiTodoSearchHelper
    implements PsiTodoSearchHelper {
        private MyPsiTodoSearchHelper() {
        }

        public PsiFile @NotNull [] findFilesWithTodoItems() {
            MultiMap allChanges = new MultiMap();
            if (CustomChangelistTodosTreeBuilder.this.myIncludedChangeListsIds == null) {
                this.putChangesForLocalFiles((MultiMap<VirtualFile, Change>)allChanges, ChangeListManager.getInstance((Project)CustomChangelistTodosTreeBuilder.this.myProject).getAllChanges());
            } else {
                for (String string : CustomChangelistTodosTreeBuilder.this.myIncludedChangeListsIds) {
                    LocalChangeList changeList = ChangeListManager.getInstance((Project)CustomChangelistTodosTreeBuilder.this.myProject).getChangeList(string);
                    if (changeList == null) continue;
                    this.putChangesForLocalFiles((MultiMap<VirtualFile, Change>)allChanges, changeList.getChanges());
                }
            }
            ArrayList changes = new ArrayList();
            for (PsiFile next : CustomChangelistTodosTreeBuilder.this.myIncludedFiles) {
                changes.addAll(allChanges.get((Object)next.getVirtualFile()));
            }
            TodoCheckinHandlerWorker todoCheckinHandlerWorker = new TodoCheckinHandlerWorker(CustomChangelistTodosTreeBuilder.this.myProject, changes, CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter());
            todoCheckinHandlerWorker.execute();
            CustomChangelistTodosTreeBuilder.this.buildMap(todoCheckinHandlerWorker.inOneList());
            Set files = CustomChangelistTodosTreeBuilder.this.myMap.keySet();
            PsiFile[] psiFileArray = files.toArray(PsiFile.EMPTY_ARRAY);
            if (psiFileArray == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(0);
            }
            return psiFileArray;
        }

        private void putChangesForLocalFiles(@NotNull MultiMap<VirtualFile, Change> changesMap, @NotNull Collection<Change> changes) {
            if (changesMap == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(1);
            }
            if (changes == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(2);
            }
            for (Change change : changes) {
                FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
                VirtualFile file = afterPath != null ? afterPath.getVirtualFile() : null;
                if (file == null) continue;
                changesMap.putValue((Object)file, (Object)change);
            }
        }

        public TodoItem @NotNull [] findTodoItems(@NotNull PsiFile file) {
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(3);
            }
            TodoItem[] todoItemArray = CustomChangelistTodosTreeBuilder.this.findPatternedTodoItems(file, CustomChangelistTodosTreeBuilder.this.getTodoTreeStructure().getTodoFilter());
            if (todoItemArray == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(4);
            }
            return todoItemArray;
        }

        public TodoItem @NotNull [] findTodoItemsLight(@NotNull PsiFile file) {
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(5);
            }
            TodoItem[] todoItemArray = this.findTodoItems(file);
            if (todoItemArray == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(6);
            }
            return todoItemArray;
        }

        public TodoItem @NotNull [] findTodoItemsLight(@NotNull PsiFile file, int startOffset, int endOffset) {
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(7);
            }
            TodoItem[] todoItemArray = this.findTodoItems(file, startOffset, endOffset);
            if (todoItemArray == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(8);
            }
            return todoItemArray;
        }

        public TodoItem @NotNull [] findTodoItems(@NotNull PsiFile file, int startOffset, int endOffset) {
            TodoItem[] todoItems;
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(9);
            }
            if ((todoItems = this.findTodoItems(file)).length == 0) {
                if (todoItems == null) {
                    MyPsiTodoSearchHelper.$$$reportNull$$$0(10);
                }
                return todoItems;
            }
            TextRange textRange = new TextRange(startOffset, endOffset);
            ArrayList<TodoItem> result2 = new ArrayList<TodoItem>();
            for (TodoItem todoItem : todoItems) {
                if (!todoItem.getTextRange().contains(textRange)) continue;
                result2.add(todoItem);
            }
            TodoItem[] todoItemArray = result2.isEmpty() ? EMPTY_ITEMS : result2.toArray(new TodoItem[0]);
            if (todoItemArray == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(11);
            }
            return todoItemArray;
        }

        public int getTodoItemsCount(@NotNull PsiFile file) {
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(12);
            }
            return this.findTodoItems(file).length;
        }

        public int getTodoItemsCount(@NotNull PsiFile file, @NotNull TodoPattern pattern) {
            if (file == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(13);
            }
            if (pattern == null) {
                MyPsiTodoSearchHelper.$$$reportNull$$$0(14);
            }
            TodoFilter filter = new TodoFilter();
            filter.addTodoPattern(pattern);
            return CustomChangelistTodosTreeBuilder.this.findPatternedTodoItems(file, filter).length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$MyPsiTodoSearchHelper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesMap";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findFilesWithTodoItems";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/todo/CustomChangelistTodosTreeBuilder$MyPsiTodoSearchHelper";
                    break;
                }
                case 4: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findTodoItems";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findTodoItemsLight";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "putChangesForLocalFiles";
                    break;
                }
                case 3: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "findTodoItems";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findTodoItemsLight";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getTodoItemsCount";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

