/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import javax.annotation.Nonnull;
import org.fest.reflect.core.Reflection;
import org.fest.swing.util.SystemPropertyWriter;
import org.fest.util.VisibleForTesting;

public final class AWTExceptionHandlerInstaller {
    private static final SystemPropertyWriter WRITER = new SystemPropertyWriter();

    public static void installAWTExceptionHandler(@Nonnull Class<?> exceptionHandlerType) {
        AWTExceptionHandlerInstaller.installAWTExceptionHandler(exceptionHandlerType, WRITER);
    }

    @VisibleForTesting
    static void installAWTExceptionHandler(@Nonnull Class<?> exceptionHandlerType, SystemPropertyWriter writer) {
        try {
            Reflection.constructor().in(exceptionHandlerType).target();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("The exception handler type should have a default constructor");
        }
        writer.updateSystemProperty("sun.awt.exception.handler", exceptionHandlerType.getName());
    }

    private AWTExceptionHandlerInstaller() {
    }
}

