/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.timing;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.BasicDescription;
import org.fest.assertions.Description;
import org.fest.util.Strings;

public abstract class Condition {
    protected static final String EMPTY_TEXT = "";
    private final Description description;

    public Condition(@Nonnull String description) {
        this((Description)new BasicDescription(description));
    }

    public Condition(@Nullable Description description) {
        this.description = description;
    }

    public abstract boolean test();

    @Nonnull
    public final String toString() {
        String descriptionText = this.description != null ? this.description.value() : this.defaultDescription();
        String addendum = this.descriptionAddendum();
        return Strings.concat((Object[])new Object[]{descriptionText, addendum});
    }

    private String defaultDescription() {
        return String.format("condition of type [%s]", this.getClass().getName());
    }

    @Nonnull
    protected String descriptionAddendum() {
        return EMPTY_TEXT;
    }

    protected void done() {
    }
}

