/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.hierarchy.ChildrenFinderStrategy;
import org.fest.util.Arrays;
import org.fest.util.Lists;

final class WindowChildrenFinder
implements ChildrenFinderStrategy {
    WindowChildrenFinder() {
    }

    @Override
    @Nonnull
    @RunsInCurrentThread
    public Collection<Component> nonExplicitChildrenOf(@Nonnull Container c) {
        if (!(c instanceof Window)) {
            return Lists.emptyList();
        }
        return this.ownedWindows((Window)c);
    }

    @Nonnull
    @RunsInCurrentThread
    private Collection<Component> ownedWindows(@Nonnull Window w) {
        Object[] windows = w.getOwnedWindows();
        if (Arrays.isNullOrEmpty((Object[])windows)) {
            return Lists.emptyList();
        }
        ArrayList windowsList = Lists.newArrayList();
        for (Object c : windows) {
            if (!((Component)c).isDisplayable()) continue;
            windowsList.add(c);
        }
        return windowsList;
    }
}

