/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.swing.JList;
import javax.swing.ListModel;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.swing.format.SwingIntEnums;
import org.fest.util.Arrays;
import org.fest.util.Lists;
import org.fest.util.Strings;

public class JListFormatter
extends ComponentFormatterTemplate {
    @Override
    @Nonnull
    @RunsInCurrentThread
    protected String doFormat(@Nonnull Component c) {
        JList list = (JList)c;
        String format = "%s[name=%s, selectedValues=%s, contents=%s, selectionMode=%s, enabled=%b, visible=%b, showing=%b]";
        return String.format(format, list.getClass().getName(), Strings.quote((String)list.getName()), Arrays.format((Object)list.getSelectedValues()), Arrays.format((Object)this.contentsOf(list)), SwingIntEnums.SELECTION_MODES.get(list.getSelectionMode()), list.isEnabled(), list.isVisible(), list.isShowing());
    }

    @Nonnull
    private Object[] contentsOf(JList list) {
        ArrayList contents = Lists.newArrayList();
        ListModel model = list.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            contents.add(model.getElementAt(i));
        }
        return contents.toArray();
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        return JList.class;
    }
}

