/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Font;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Assertions;
import org.fest.assertions.BasicDescription;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.Description;
import org.fest.assertions.IntAssert;
import org.fest.assertions.StringAssert;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

public class FontFixture {
    private static final String PROPERTY_SEPARATOR = " - ";
    private static final String BOLD_PROPERTY = "bold";
    private static final String FAMILY_PROPERTY = "family";
    private static final String ITALIC_PROPERTY = "italic";
    private static final String NAME_PROPERTY = "name";
    private static final String PLAIN_PROPERTY = "plain";
    private static final String SIZE_PROPERTY = "size";
    private final Font target;
    private final Description description;

    public FontFixture(@Nonnull Font target) {
        this(target, (Description)null);
    }

    public FontFixture(@Nonnull Font target, @Nonnull String description) {
        this(target, (Description)new BasicDescription(description));
    }

    public FontFixture(@Nonnull Font target, @Nullable Description description) {
        this.target = (Font)Preconditions.checkNotNull((Object)target);
        this.description = description;
    }

    @Nonnull
    public FontFixture requireFamily(@Nonnull String family) {
        ((StringAssert)Assertions.assertThat((String)this.target.getFamily()).as(this.property(FAMILY_PROPERTY))).isEqualTo((Object)family);
        return this;
    }

    @Nonnull
    public FontFixture requireName(@Nonnull String name) {
        ((StringAssert)Assertions.assertThat((String)this.target.getName()).as(this.property(NAME_PROPERTY))).isEqualTo((Object)name);
        return this;
    }

    @Nonnull
    public FontFixture requireSize(int size) {
        ((IntAssert)Assertions.assertThat((int)this.target.getSize()).as(this.property(SIZE_PROPERTY))).isEqualTo(size);
        return this;
    }

    @Nonnull
    public FontFixture requireBold() {
        return this.requireBold(true);
    }

    @Nonnull
    public FontFixture requireNotBold() {
        return this.requireBold(false);
    }

    @Nonnull
    private FontFixture requireBold(boolean bold) {
        ((BooleanAssert)Assertions.assertThat((boolean)this.target.isBold()).as(this.property(BOLD_PROPERTY))).isEqualTo(bold);
        return this;
    }

    @Nonnull
    public FontFixture requireItalic() {
        return this.requireItalic(true);
    }

    @Nonnull
    public FontFixture requireNotItalic() {
        return this.requireItalic(false);
    }

    @Nonnull
    private FontFixture requireItalic(boolean italic) {
        ((BooleanAssert)Assertions.assertThat((boolean)this.target.isItalic()).as(this.property(ITALIC_PROPERTY))).isEqualTo(italic);
        return this;
    }

    @Nonnull
    public FontFixture requirePlain() {
        return this.requirePlain(true);
    }

    @Nonnull
    public FontFixture requireNotPlain() {
        return this.requirePlain(false);
    }

    @Nonnull
    private FontFixture requirePlain(boolean plain) {
        ((BooleanAssert)Assertions.assertThat((boolean)this.target.isBold()).as(this.property(PLAIN_PROPERTY))).isEqualTo(plain);
        return this;
    }

    @Nonnull
    private String property(@Nonnull String s) {
        if (!Strings.isNullOrEmpty((String)this.description())) {
            return Strings.concat((Object[])new Object[]{this.description.value(), PROPERTY_SEPARATOR, s});
        }
        return s;
    }

    @Nonnull
    public Font target() {
        return this.target;
    }

    @Nullable
    public final String description() {
        return this.description != null ? this.description.value() : null;
    }
}

