/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.edt;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.SwingUtilities;
import org.fest.swing.edt.GuiAction;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Preconditions;

public abstract class GuiQuery<T>
extends GuiAction {
    private T result;

    @Nonnull
    public static <T> T getNonNull(@Nonnull Supplier<T> supplier) {
        return (T)Preconditions.checkNotNull(GuiQuery.get(supplier));
    }

    @Nullable
    public static <T> T get(final @Nonnull Supplier<T> supplier) {
        return GuiActionRunner.execute(new GuiQuery<T>(){

            @Override
            @Nullable
            protected T executeInEDT() throws Throwable {
                return supplier.get();
            }
        });
    }

    @Override
    public final void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw ActionFailedException.actionFailure("Query should be executed in the event dispatch thread");
        }
        try {
            this.result = this.executeInEDT();
        }
        catch (Throwable t) {
            this.catchedException(t);
        }
        finally {
            this.notifyExecutionCompleted();
        }
    }

    @Nullable
    protected abstract T executeInEDT() throws Throwable;

    @Nullable
    final T result() {
        return this.result;
    }

    final void clearResult() {
        this.result = null;
    }
}

