/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.Assert;
import org.fest.assertions.AssertExtension;
import org.fest.assertions.Description;
import org.fest.swing.util.Strings;

class TextAssert
extends Assert
implements AssertExtension {
    private final String actual;

    @Nonnull
    static TextAssert assertThat(@Nullable String s) {
        return new TextAssert(s);
    }

    @Nonnull
    static TextAssert verifyThat(@Nullable String s) {
        return new TextAssert(s);
    }

    TextAssert(@Nullable String actual) {
        this.actual = actual;
    }

    @Nonnull
    TextAssert as(@Nullable String description) {
        this.description(description);
        return this;
    }

    @Nonnull
    TextAssert as(@Nullable Description description) {
        this.description(description);
        return this;
    }

    @Nonnull
    TextAssert isEqualOrMatches(@Nullable String s) {
        if (Strings.areEqualOrMatch(s, this.actual)) {
            return this;
        }
        String format = "actual value:<%s> is not equal to or does not match pattern:<%s>";
        String msg = String.format(format, org.fest.util.Strings.quote((String)this.actual), org.fest.util.Strings.quote((String)s));
        throw this.failure(msg);
    }

    @Nonnull
    TextAssert matches(@Nonnull Pattern pattern) {
        if (Strings.match(pattern, this.actual)) {
            return this;
        }
        String format = "actual value:<%s> does not match pattern:<%s>";
        String msg = String.format(format, org.fest.util.Strings.quote((String)this.actual), org.fest.util.Strings.quote((String)pattern.pattern()));
        throw this.failure(msg);
    }
}

