/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JProgressBar;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.fest.assertions.IntAssert;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JProgressBarIndeterminateQuery;
import org.fest.swing.driver.JProgressBarMinimumAndMaximumQuery;
import org.fest.swing.driver.JProgressBarStringQuery;
import org.fest.swing.driver.JProgressBarValueQuery;
import org.fest.swing.driver.JProgressBarWaitUntilIsDeterminate;
import org.fest.swing.driver.JProgressBarWaitUntilValueIsEqualToExpectedTask;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.driver.TextDisplayDriver;
import org.fest.swing.timing.Timeout;
import org.fest.swing.util.Pair;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JProgressBarDriver
extends JComponentDriver
implements TextDisplayDriver<JProgressBar> {
    private static final Timeout DEFAULT_TIMEOUT = Timeout.timeout(30L, TimeUnit.SECONDS);
    private static final String TEXT_PROPERTY = "string";

    public JProgressBarDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JProgressBar progressBar, @Nullable String expected) {
        TextAssert.verifyThat(JProgressBarStringQuery.stringOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, TEXT_PROPERTY)).isEqualOrMatches(expected);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JProgressBar progressBar, @Nonnull Pattern pattern) {
        TextAssert.verifyThat(JProgressBarStringQuery.stringOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, TEXT_PROPERTY)).matches(pattern);
    }

    @RunsInEDT
    public void requireValue(@Nonnull JProgressBar progressBar, int value) {
        ((IntAssert)Assertions.assertThat((int)JProgressBarValueQuery.valueOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, "value"))).isEqualTo(value);
    }

    @RunsInEDT
    public void requireIndeterminate(@Nonnull JProgressBar progressBar) {
        this.requireIndeterminate(progressBar, true);
    }

    @RunsInEDT
    public void requireDeterminate(@Nonnull JProgressBar progressBar) {
        this.requireIndeterminate(progressBar, false);
    }

    @RunsInEDT
    private void requireIndeterminate(@Nonnull JProgressBar progressBar, boolean indeterminate) {
        ((BooleanAssert)Assertions.assertThat((boolean)JProgressBarIndeterminateQuery.isIndeterminate(progressBar)).as(JProgressBarDriver.propertyName(progressBar, "indeterminate"))).isEqualTo(indeterminate);
    }

    @RunsInEDT
    public void waitUntilValueIs(@Nonnull JProgressBar progressBar, int value) {
        this.waitUntilValueIs(progressBar, value, DEFAULT_TIMEOUT);
    }

    @RunsInEDT
    public void waitUntilValueIs(@Nonnull JProgressBar progressBar, int value, @Nonnull Timeout timeout) {
        this.checkInBetweenMinAndMax(progressBar, value);
        Preconditions.checkNotNull((Object)timeout);
        JProgressBarWaitUntilValueIsEqualToExpectedTask.waitUntilValueIsEqualToExpected(progressBar, value, timeout);
    }

    @RunsInEDT
    private void checkInBetweenMinAndMax(@Nonnull JProgressBar progressBar, int value) {
        Pair<Integer, Integer> minAndMax = JProgressBarMinimumAndMaximumQuery.minimumAndMaximumOf(progressBar);
        this.assertIsInBetweenMinAndMax(value, (Integer)minAndMax.first, (Integer)minAndMax.second);
    }

    private void assertIsInBetweenMinAndMax(int value, int min, int max) {
        if (value >= min && value <= max) {
            return;
        }
        String msg = String.format("Value <%d> should be between <[%d, %d]>", value, min, max);
        throw new IllegalArgumentException(msg);
    }

    @RunsInEDT
    public void waitUntilIsDeterminate(@Nonnull JProgressBar progressBar) {
        this.waitUntilIsDeterminate(progressBar, DEFAULT_TIMEOUT);
    }

    @RunsInEDT
    public void waitUntilIsDeterminate(@Nonnull JProgressBar progressBar, @Nonnull Timeout timeout) {
        Preconditions.checkNotNull((Object)timeout);
        JProgressBarWaitUntilIsDeterminate.waitUntilValueIsDeterminate(progressBar, timeout);
    }

    @Override
    @Nullable
    @RunsInEDT
    public String textOf(@Nonnull JProgressBar progressBar) {
        return JProgressBarStringQuery.stringOf(progressBar);
    }
}

