/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.IntArrayAssert;
import org.fest.assertions.IntAssert;
import org.fest.assertions.ListAssert;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.awt.AWT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.BasicJListCellReader;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JListContentQuery;
import org.fest.swing.driver.JListItemCountQuery;
import org.fest.swing.driver.JListItemPreconditions;
import org.fest.swing.driver.JListItemValueQuery;
import org.fest.swing.driver.JListMatchingItemQuery;
import org.fest.swing.driver.JListScrollToItemTask;
import org.fest.swing.driver.JListSelectedIndexQuery;
import org.fest.swing.driver.JListSelectionIndicesQuery;
import org.fest.swing.driver.JListSelectionValueQuery;
import org.fest.swing.driver.JListSelectionValuesQuery;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.ArrayPreconditions;
import org.fest.swing.util.Pair;
import org.fest.swing.util.PatternTextMatcher;
import org.fest.swing.util.Range;
import org.fest.swing.util.StringTextMatcher;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Arrays;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JListDriver
extends JComponentDriver {
    private static final String SELECTED_INDICES_PROPERTY = "selectedIndices";
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private JListCellReader cellReader;

    public JListDriver(@Nonnull Robot robot) {
        super(robot);
        this.replaceCellReader(new BasicJListCellReader());
    }

    @Nonnull
    @RunsInEDT
    public String[] contentsOf(@Nonnull JList list) {
        return JListContentQuery.contents(list, this.cellReader());
    }

    @RunsInEDT
    public void selectItems(@Nonnull JList list, @Nonnull String[] values) {
        this.selectItems(list, new StringTextMatcher(values));
    }

    @RunsInEDT
    public void selectItems(@Nonnull JList list, @Nonnull Pattern[] patterns) {
        this.selectItems(list, new PatternTextMatcher(patterns));
    }

    @RunsInEDT
    private void selectItems(final @Nonnull JList list, @Nonnull TextMatcher matcher) {
        final List<Integer> indices = JListMatchingItemQuery.matchingItemIndices(list, matcher, this.cellReader());
        if (indices.isEmpty()) {
            throw this.failMatchingNotFound(list, matcher);
        }
        this.clearSelection(list);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return indices.size();
            }

            @Override
            void selectElement(int index) {
                JListDriver.this.selectItem(list, (Integer)indices.get(index));
            }
        }.multiSelect();
    }

    @RunsInEDT
    public void selectItem(@Nonnull JList list, @Nullable String value) {
        this.selectItem(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void selectItem(@Nonnull JList list, @Nonnull Pattern pattern) {
        this.selectItem(list, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private void selectItem(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItemIfNotSelectedYet(list, matcher, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher);
        if (scrollInfo.second == null) {
            return;
        }
        this.robot.click((Component)list, this.cellCenterIn(scrollInfo));
    }

    public void clickItem(@Nonnull JList list, @Nullable String value, @Nonnull MouseButton button, int times) {
        this.clickItem(list, new StringTextMatcher(value), button, times);
    }

    public void clickItem(@Nonnull JList list, @Nonnull Pattern pattern, @Nonnull MouseButton button, int times) {
        this.clickItem(list, new PatternTextMatcher(pattern), button, times);
    }

    private void clickItem(@Nonnull JList list, @Nonnull TextMatcher matcher, @Nonnull MouseButton button, int times) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher);
        this.robot.click(list, this.cellCenterIn(scrollInfo), button, times);
    }

    public void selectItems(final @Nonnull JList list, final @Nonnull int[] indices) {
        ArrayPreconditions.checkNotNullOrEmpty(indices);
        this.clearSelection(list);
        new MultipleSelectionTemplate(this.robot){

            @Override
            int elementCount() {
                return indices.length;
            }

            @Override
            void selectElement(int index) {
                JListDriver.this.selectItem(list, indices[index]);
            }
        }.multiSelect();
    }

    public void clearSelection(@Nonnull JList list) {
        JListDriver.clearSelectionOf(list);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void clearSelectionOf(final @Nonnull JList list) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                list.clearSelection();
            }
        });
    }

    @RunsInEDT
    public void selectItems(@Nonnull JList list, @Nonnull Range.From from, @Nonnull Range.To to) {
        this.selectItems(list, from.value, to.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RunsInEDT
    public void selectItems(@Nonnull JList list, int start, int end) {
        JListDriver.validateIndicesAndClearSelection(list, start, end);
        this.selectItem(list, start);
        this.robot.pressKey(16);
        try {
            this.clickItem(list, end, MouseButton.LEFT_BUTTON, 1);
        }
        finally {
            this.robot.releaseKey(16);
        }
    }

    @RunsInEDT
    private static void validateIndicesAndClearSelection(final @Nonnull JList list, final int ... indices) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JListItemPreconditions.checkIndicesInBounds(list, indices);
                list.clearSelection();
            }
        });
    }

    @RunsInEDT
    public void selectItem(@Nonnull JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItemIfNotSelectedYet(list, index);
        this.robot.waitForIdle();
        if (cellCenter == null) {
            return;
        }
        this.robot.click((Component)list, cellCenter);
    }

    @RunsInEDT
    public void clickItem(@Nonnull JList list, int index, @Nonnull MouseButton button, int times) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        this.robot.click(list, cellCenter, button, times);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JList list, @Nullable String value) {
        String selection = this.requiredSelection(list);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(list)).isEqualOrMatches(value);
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JList list, @Nonnull Pattern pattern) {
        String selection = this.requiredSelection(list);
        TextAssert.verifyThat(selection).as(this.selectedIndexProperty(list)).matches(pattern);
    }

    @Nullable
    private String requiredSelection(@Nonnull JList list) {
        Object selection = JListSelectionValueQuery.singleSelectionValue(list, this.cellReader());
        if (JListSelectionValueQuery.NO_SELECTION_VALUE == selection) {
            this.failNoSelection(list);
        }
        return (String)selection;
    }

    @RunsInEDT
    public void requireSelection(@Nonnull JList list, int index) {
        int selectedIndex = JListSelectedIndexQuery.selectedIndexOf(list);
        if (selectedIndex == -1) {
            this.failNoSelection(list);
        }
        ((IntAssert)Assertions.assertThat((int)selectedIndex).as(this.selectedIndexProperty(list))).isEqualTo(index);
    }

    @Nonnull
    @RunsInEDT
    public String[] selectionOf(@Nonnull JList list) {
        List<String> selection = JListSelectionValuesQuery.selectionValues(list, this.cellReader());
        return selection.toArray(new String[selection.size()]);
    }

    @RunsInEDT
    public void requireSelectedItems(@Nonnull JList list, String ... items) {
        this.requireSelectedItems(list, new StringTextMatcher(items));
    }

    @RunsInEDT
    public void requireSelectedItems(@Nonnull JList list, Pattern ... patterns) {
        this.requireSelectedItems(list, new PatternTextMatcher(patterns));
    }

    @RunsInEDT
    private void requireSelectedItems(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        List<String> matchingValues = JListMatchingItemQuery.matchingItemValues(list, matcher, this.cellReader());
        ((ListAssert)Assertions.assertThat(JListSelectionValuesQuery.selectionValues(list, this.cellReader())).as(JListDriver.propertyName(list, SELECTED_INDICES_PROPERTY))).isEqualTo(matchingValues);
    }

    @RunsInEDT
    public void requireSelectedItems(@Nonnull JList list, int ... indices) {
        ArrayPreconditions.checkNotNullOrEmpty(indices);
        java.util.Arrays.sort(indices);
        ((IntArrayAssert)Assertions.assertThat((int[])JListSelectionIndicesQuery.selectedIndices(list)).as(JListDriver.propertyName(list, SELECTED_INDICES_PROPERTY))).isEqualTo(indices);
    }

    @RunsInEDT
    public void requireNoSelection(@Nonnull JList list) {
        ((IntAssert)Assertions.assertThat((int)JListSelectedIndexQuery.selectedIndexOf(list)).as(this.selectedIndexProperty(list))).isEqualTo(-1);
    }

    @RunsInEDT
    private void failNoSelection(@Nonnull JList list) {
        Fail.fail((String)String.format("[%s] No selection", this.selectedIndexProperty(list).value()));
    }

    @RunsInEDT
    private Description selectedIndexProperty(@Nonnull JList list) {
        return JListDriver.propertyName(list, SELECTED_INDEX_PROPERTY);
    }

    @RunsInEDT
    public void drag(@Nonnull JList list, @Nullable String value) {
        this.drag(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public void drag(@Nonnull JList list, @Nonnull Pattern pattern) {
        this.drag(list, new PatternTextMatcher(pattern));
    }

    private void drag(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher);
        super.drag(list, this.cellCenterIn(scrollInfo));
    }

    @RunsInEDT
    public void drop(@Nonnull JList list, @Nullable String value) {
        this.drop(list, new StringTextMatcher(value));
    }

    public void drop(@Nonnull JList list, @Nonnull Pattern pattern) {
        this.drop(list, new PatternTextMatcher(pattern));
    }

    private void drop(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher);
        super.drop(list, this.cellCenterIn(scrollInfo));
    }

    private void checkItemFound(@Nonnull JList list, @Nonnull Pair<Integer, Point> scrollInfo, @Nonnull TextMatcher matcher) {
        if (JListScrollToItemTask.ITEM_NOT_FOUND == scrollInfo) {
            throw this.failMatchingNotFound(list, matcher);
        }
    }

    @RunsInEDT
    public void drag(@Nonnull JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        super.drag(list, cellCenter);
    }

    @RunsInEDT
    public void drop(@Nonnull JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        super.drop(list, cellCenter);
    }

    @RunsInEDT
    public void drop(@Nonnull JList list) {
        JListDriver.checkInEdtEnabledAndShowing(list);
        super.drop(list, AWT.visibleCenterOf(list));
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JList list, @Nullable String value) {
        return this.showPopupMenu(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JList list, @Nonnull Pattern pattern) {
        return this.showPopupMenu(list, new PatternTextMatcher(pattern));
    }

    @Nonnull
    @RunsInEDT
    private JPopupMenu showPopupMenu(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        Pair<Integer, Point> scrollInfo = JListScrollToItemTask.scrollToItem(list, matcher, this.cellReader());
        this.robot.waitForIdle();
        this.checkItemFound(list, scrollInfo, matcher);
        return this.robot.showPopupMenu(list, this.cellCenterIn(scrollInfo));
    }

    @Nonnull
    private Point cellCenterIn(@Nonnull Pair<Integer, Point> scrollInfo) {
        return (Point)Preconditions.checkNotNull(scrollInfo.second);
    }

    @Nonnull
    @RunsInEDT
    public JPopupMenu showPopupMenu(@Nonnull JList list, int index) {
        Point cellCenter = JListScrollToItemTask.scrollToItem(list, index);
        this.robot.waitForIdle();
        return this.robot.showPopupMenu(list, cellCenter);
    }

    @Nonnull
    @RunsInEDT
    public Point pointAt(@Nonnull JList list, @Nullable String value) {
        return JListMatchingItemQuery.centerOfMatchingItemCell(list, value, this.cellReader());
    }

    @RunsInEDT
    public int indexOf(@Nonnull JList list, @Nullable String value) {
        return this.indexOf(list, new StringTextMatcher(value));
    }

    @RunsInEDT
    public int indexOf(@Nonnull JList list, @Nonnull Pattern pattern) {
        return this.indexOf(list, new PatternTextMatcher(pattern));
    }

    @RunsInEDT
    private int indexOf(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        int index = JListDriver.itemIndex(list, matcher, this.cellReader());
        if (index >= 0) {
            return index;
        }
        throw this.failMatchingNotFound(list, matcher);
    }

    @RunsInEDT
    private static int itemIndex(final @Nonnull JList list, final @Nonnull TextMatcher matcher, final @Nonnull JListCellReader cellReader) {
        Integer result = GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                return JListMatchingItemQuery.matchingItemIndex(list, matcher, cellReader);
            }
        });
        return (Integer)Preconditions.checkNotNull((Object)result);
    }

    @Nonnull
    private LocationUnavailableException failMatchingNotFound(@Nonnull JList list, @Nonnull TextMatcher matcher) {
        String format = "Unable to find item matching the %s %s among the JList contents %s";
        String msg = String.format(format, matcher.description(), matcher.formattedValues(), Arrays.format((Object)JListContentQuery.contents(list, this.cellReader())));
        return new LocationUnavailableException(msg);
    }

    @Nullable
    @RunsInEDT
    public String value(@Nonnull JList list, int index) {
        return JListItemValueQuery.itemValue(list, index, this.cellReader());
    }

    public void replaceCellReader(@Nonnull JListCellReader newCellReader) {
        this.cellReader = (JListCellReader)Preconditions.checkNotNull((Object)newCellReader);
    }

    @RunsInEDT
    public void requireItemCount(@Nonnull JList list, int expected) {
        int actual = JListItemCountQuery.itemCountIn(list);
        ((IntAssert)Assertions.assertThat((int)actual).as(JListDriver.propertyName(list, "itemCount"))).isEqualTo(expected);
    }

    @Nonnull
    private JListCellReader cellReader() {
        return this.cellReader;
    }
}

