/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.io.File;
import javax.annotation.Nonnull;
import javax.swing.JFileChooser;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;
import org.fest.util.ToString;

final class JFileChooserSelectFileTask {
    @RunsInEDT
    static void setSelectedFile(final @Nonnull JFileChooser fileChooser, final @Nonnull File file) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(fileChooser);
                JFileChooserSelectFileTask.checkSelectionMode(fileChooser, file);
                fileChooser.setSelectedFile(file);
            }
        });
    }

    @RunsInEDT
    static void setSelectedFiles(final @Nonnull JFileChooser fileChooser, final @Nonnull File[] files) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(fileChooser);
                if (files.length > 1 && !fileChooser.isMultiSelectionEnabled()) {
                    throw new IllegalStateException(Strings.concat((Object[])new Object[]{"Expecting file chooser ", Formatting.format(fileChooser), " to handle multiple selection"}));
                }
                for (File file : files) {
                    JFileChooserSelectFileTask.checkSelectionMode(fileChooser, file);
                }
                fileChooser.setSelectedFiles(files);
            }
        });
    }

    @RunsInCurrentThread
    private static void checkSelectionMode(JFileChooser fileChooser, File file) {
        int mode = fileChooser.getFileSelectionMode();
        if (mode == 0 && !file.isFile()) {
            throw JFileChooserSelectFileTask.cannotSelectFile(file, "the file chooser can only open files");
        }
        if (mode == 1 && !file.isDirectory()) {
            throw JFileChooserSelectFileTask.cannotSelectFile(file, "the file chooser can only open directories");
        }
    }

    private static IllegalArgumentException cannotSelectFile(File file, String reason) {
        String msg = String.format("Unabled to select file %s: %s", ToString.toStringOf((Object)file), reason);
        return new IllegalArgumentException(msg);
    }

    private JFileChooserSelectFileTask() {
    }
}

