/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.AbstractComponentMatcher;
import org.fest.util.Objects;
import org.fest.util.Preconditions;

public final class NameMatcher
extends AbstractComponentMatcher {
    private final String name;
    private final Class<? extends Component> type;

    public NameMatcher(@Nullable String name) {
        this(name, false);
    }

    public NameMatcher(@Nullable String name, boolean requireShowing) {
        this(name, Component.class, requireShowing);
    }

    public NameMatcher(@Nullable String name, @Nonnull Class<? extends Component> type) {
        this(name, type, false);
    }

    public NameMatcher(@Nullable String name, @Nonnull Class<? extends Component> type, boolean requireShowing) {
        super(requireShowing);
        this.name = Preconditions.checkNotNullOrEmpty((String)name);
        this.type = (Class)Preconditions.checkNotNull(type);
    }

    @Override
    @RunsInCurrentThread
    public boolean matches(@Nullable Component c) {
        if (c == null) {
            return false;
        }
        return Objects.areEqual((Object)this.name, (Object)c.getName()) && this.type.isInstance(c) && this.requireShowingMatches(c);
    }

    public String toString() {
        String format = "%s[name='%s', type=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.name, this.type.getName(), this.requireShowing());
    }
}

