/*
 * Decompiled with CFR 0.152.
 */
package git4idea.validators;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitBranch;
import git4idea.branch.GitBranchesCollection;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u001e\u0010\t\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a2\u0010\n\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u00062\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0002\u001a,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0016"}, d2={"checkBranchConflict", "Lcom/intellij/openapi/ui/ValidationInfo;", "repositories", "", "Lgit4idea/repo/GitRepository;", "inputString", "", "checkRefName", "checkRefNameEmptyOrHead", "conflictsWithLocalBranch", "conflictsWithLocalOrRemote", "local", "", "message", "conflictsWithRemoteBranch", "findConflictingBranch", "Lgit4idea/GitBranch;", "repository", "getAdditionalDescription", "", "getReposWithConflictingBranch", "validateName", "intellij.vcs.git"})
public final class GitBranchValidatorKt {
    @Nullable
    public static final ValidationInfo validateName(@NotNull Collection<? extends GitRepository> repositories, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        ValidationInfo validationInfo = GitBranchValidatorKt.checkRefName(inputString);
        if (validationInfo == null) {
            validationInfo = GitBranchValidatorKt.checkBranchConflict(repositories, inputString);
        }
        return validationInfo;
    }

    @Nullable
    public static final ValidationInfo checkRefName(@Nullable String inputString) {
        Object object = GitBranchValidatorKt.checkRefNameEmptyOrHead(inputString);
        if (object == null) {
            object = !GitRefNameValidator.getInstance().checkInput(inputString) ? new ValidationInfo(GitBundle.message("new.branch.dialog.error.branch.name.invalid", inputString)) : null;
        }
        return object;
    }

    @Nullable
    public static final ValidationInfo checkRefNameEmptyOrHead(@Nullable String inputString) {
        return StringUtil.isEmptyOrSpaces((String)inputString) ? new ValidationInfo(GitBundle.message("new.branch.dialog.error.branch.name.empty", new Object[0])) : (StringUtil.equalsIgnoreCase((CharSequence)inputString, (CharSequence)"HEAD") ? new ValidationInfo(GitBundle.message("new.branch.dialog.error.branch.name.head", new Object[0])) : null);
    }

    private static final ValidationInfo checkBranchConflict(Collection<? extends GitRepository> repositories, String inputString) {
        ValidationInfo validationInfo = GitBranchValidatorKt.conflictsWithLocalBranch(repositories, inputString);
        if (validationInfo == null) {
            validationInfo = GitBranchValidatorKt.conflictsWithRemoteBranch(repositories, inputString);
        }
        return validationInfo;
    }

    @Nullable
    public static final ValidationInfo conflictsWithLocalBranch(@NotNull Collection<? extends GitRepository> repositories, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        return GitBranchValidatorKt.conflictsWithLocalOrRemote(repositories, inputString, true, "new.branch.dialog.error.branch.already.exists");
    }

    @Nullable
    public static final ValidationInfo conflictsWithRemoteBranch(@NotNull Collection<? extends GitRepository> repositories, @NotNull String inputString) {
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
        return GitBranchValidatorKt.conflictsWithLocalOrRemote(repositories, inputString, false, "new.branch.dialog.error.branch.clashes.with.remote");
    }

    private static final ValidationInfo conflictsWithLocalOrRemote(Collection<? extends GitRepository> repositories, String inputString, boolean local, @PropertyKey(resourceBundle="messages.GitBundle") String message) {
        List<GitRepository> reposWithConflictingBranch = GitBranchValidatorKt.getReposWithConflictingBranch(repositories, inputString, local);
        if (reposWithConflictingBranch.isEmpty()) {
            return null;
        }
        String string = GitBundle.message(message, inputString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(message, inputString)");
        String errorText = string;
        if (repositories.size() > reposWithConflictingBranch.size()) {
            errorText = errorText + GitBranchValidatorKt.getAdditionalDescription(reposWithConflictingBranch);
            if (local) {
                return new ValidationInfo(errorText).asWarning().withOKEnabled();
            }
        }
        return new ValidationInfo(errorText);
    }

    private static final String getAdditionalDescription(List<? extends GitRepository> repositories) {
        return " " + (repositories.size() > 1 ? GitBundle.message("common.suffix.in.several.repositories", repositories.size()) : GitBundle.message("common.suffix.in.one.repository", DvcsUtil.getShortRepositoryName((Repository)((Repository)CollectionsKt.first(repositories)))));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<GitRepository> getReposWithConflictingBranch(Collection<? extends GitRepository> repositories, String inputString, boolean local) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = repositories;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitRepository repository = (GitRepository)element$iv$iv;
            boolean bl = false;
            if (!(GitBranchValidatorKt.findConflictingBranch(inputString, repository, local) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final GitBranch findConflictingBranch(String inputString, GitRepository repository, boolean local) {
        GitBranchesCollection gitBranchesCollection = repository.getBranches();
        boolean bl = false;
        boolean bl2 = false;
        GitBranchesCollection $this$run = gitBranchesCollection;
        boolean bl3 = false;
        return local ? (GitBranch)$this$run.findLocalBranch(inputString) : (GitBranch)$this$run.findRemoteBranch(inputString);
    }
}

