/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.vfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.util.LocalTimeCounter;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.index.vfs.GitIndexFileSystem;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.util.GitFileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0003JKLB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0013\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\"H\u0016\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u000fH\u0016J\b\u0010+\u001a\u00020\u000fH\u0016J\b\u0010,\u001a\u00020\u0018H\u0016J\"\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010 2\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u000fH\u0016J\n\u00102\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u00103\u001a\u00020\u0018H\u0016J\b\u00104\u001a\u00020\u0018H\u0016J\b\u00105\u001a\u00020\u0018H\u0016J\u0013\u00106\u001a\b\u0018\u000107R\u00020\u0000H\u0000\u00a2\u0006\u0002\b8J\b\u00109\u001a\u00020\u000fH\u0016J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u001dH\u0016J\b\u0010=\u001a\u00020\u001dH\u0016J\b\u0010>\u001a\u00020\u001dH\u0016J\n\u0010?\u001a\u0004\u0018\u00010\u000bH\u0002J\"\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020\u001d2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\r\u0010F\u001a\u00070\u0018\u00a2\u0006\u0002\bGH\u0016J\"\u0010H\u001a\u00020A2\b\u0010/\u001a\u0004\u0018\u00010 2\u0006\u0010I\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u000fH\u0002R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006M"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "root", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;)V", "cachedData", "Ljava/util/concurrent/atomic/AtomicReference;", "Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "modificationStamp", "", "refresher", "Lgit4idea/index/vfs/GitIndexFileSystemRefresher;", "getRefresher", "()Lgit4idea/index/vfs/GitIndexFileSystemRefresher;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "calculateLength", "hash", "", "contentToByteArrayImpl", "", "contentsToByteArray", "enforcePresentableName", "", "equals", "other", "", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getFileSystem", "Lgit4idea/index/vfs/GitIndexFileSystem;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getInputStream", "Ljava/io/InputStream;", "getLength", "getModificationStamp", "getName", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "newModificationStamp", "newTimeStamp", "getParent", "getPath", "getPresentableName", "getPresentablePath", "getRefresh", "Lgit4idea/index/vfs/GitIndexVirtualFile$Refresh;", "getRefresh$intellij_vcs_git", "getTimeStamp", "hashCode", "", "isDirectory", "isValid", "isWritable", "readCachedData", "refresh", "", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "toString", "Lorg/jetbrains/annotations/NonNls;", "write", "newContent", "CachedData", "Companion", "Refresh", "intellij.vcs.git"})
public final class GitIndexVirtualFile
extends VirtualFile
implements VirtualFilePathWrapper {
    private final AtomicReference<CachedData> cachedData;
    private volatile long modificationStamp;
    private final Project project;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final FilePath filePath;
    private static final Logger LOG;
    public static final char SEPARATOR = ':';
    public static final Companion Companion;

    private final GitIndexFileSystemRefresher getRefresher() {
        return GitIndexFileSystemRefresher.Companion.getInstance(this.project);
    }

    @NotNull
    public GitIndexFileSystem getFileSystem() {
        return GitIndexFileSystem.Companion.getInstance();
    }

    @Nullable
    public VirtualFile getParent() {
        return null;
    }

    @NotNull
    public VirtualFile[] getChildren() {
        Intrinsics.checkNotNullExpressionValue((Object)VirtualFile.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return VirtualFile.EMPTY_ARRAY;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return this.cachedData.get() != null && !this.project.isDisposed();
    }

    @NotNull
    public String getName() {
        String string = this.filePath.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath.name");
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = GitBundle.message("stage.vfs.presentable.file.name", this.filePath.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"stage\u2026ile.name\", filePath.name)");
        return string;
    }

    @NotNull
    public String getPath() {
        return GitIndexVirtualFile.Companion.encode(this.project, this.root, this.filePath);
    }

    @NotNull
    public String getPresentablePath() {
        String string = this.filePath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath.path");
        return string;
    }

    public boolean enforcePresentableName() {
        return true;
    }

    public long getLength() {
        CachedData cachedData = this.cachedData.get();
        return cachedData != null ? cachedData.getLength() : 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    @NotNull
    public FileType getFileType() {
        VirtualFile virtualFile = this.filePath.getVirtualFile();
        if (virtualFile == null || (virtualFile = virtualFile.getFileType()) == null) {
            FileType fileType = super.getFileType();
            virtualFile = fileType;
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"super.getFileType()");
        }
        return virtualFile;
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
        this.getRefresher().refresh$intellij_vcs_git(CollectionsKt.listOf((Object)((Object)this)), asynchronous, postRunnable);
    }

    @Nullable
    public final Refresh getRefresh$intellij_vcs_git() {
        CachedData newCachedData = this.readCachedData();
        CachedData oldCachedData = this.cachedData.get();
        if (Intrinsics.areEqual((Object)oldCachedData, (Object)newCachedData) ^ true) {
            LOG.debug("Preparing refresh for " + (Object)((Object)this));
            return new Refresh(oldCachedData, newCachedData, this.modificationStamp);
        }
        return null;
    }

    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream(this, requestor, newModificationStamp){
            final /* synthetic */ GitIndexVirtualFile this$0;
            final /* synthetic */ Object $requestor;
            final /* synthetic */ long $newModificationStamp;

            public void close() {
                byte[] byArray = this.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray()");
                GitIndexVirtualFile.access$write(this.this$0, this.$requestor, byArray, this.$newModificationStamp);
            }
            {
                this.this$0 = this$0;
                this.$requestor = $captured_local_variable$1;
                this.$newModificationStamp = $captured_local_variable$2;
            }
        };
        OutputStream outputStream3 = VfsUtilCore.outputStreamAddingBOM((OutputStream)outputStream2, (VirtualFile)this);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream3, (String)"VfsUtilCore.outputStream\u2026ngBOM(outputStream, this)");
        return outputStream3;
    }

    private final void write(Object requestor, byte[] newContent, long newModificationStamp) {
        try {
            long newModStamp = newModificationStamp > 0L ? newModificationStamp : LocalTimeCounter.currentTime();
            this.getRefresher().changeContent$intellij_vcs_git(this, requestor, this.modificationStamp, (Function0<Unit>)((Function0)new Function0<Unit>(this, newContent, newModStamp){
                final /* synthetic */ GitIndexVirtualFile this$0;
                final /* synthetic */ byte[] $newContent;
                final /* synthetic */ long $newModStamp;

                public final void invoke() {
                    CachedData oldCachedData = (CachedData)GitIndexVirtualFile.access$getCachedData$p(this.this$0).get();
                    if (Intrinsics.areEqual((Object)oldCachedData, (Object)GitIndexVirtualFile.access$readCachedData(this.this$0)) ^ true) {
                        GitIndexVirtualFile.access$getLOG$cp().warn("Skipping write for " + (Object)((Object)this.this$0) + " as it is not up to date");
                        return;
                    }
                    CachedData cachedData = oldCachedData;
                    boolean isExecutable = cachedData != null ? cachedData.isExecutable() : false;
                    Hash hash = GitIndexUtil.write(GitIndexVirtualFile.access$getProject$p(this.this$0), this.this$0.getRoot(), this.this$0.getFilePath(), new ByteArrayInputStream(this.$newContent), isExecutable);
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"GitIndexUtil.write(proje\u2026ewContent), isExecutable)");
                    Hash newHash = hash;
                    GitIndexVirtualFile.access$getLOG$cp().debug("Written " + (Object)((Object)this.this$0) + ". newHash=" + newHash);
                    GitIndexVirtualFile.access$setModificationStamp$p(this.this$0, this.$newModStamp);
                    CachedData cachedData2 = oldCachedData;
                    if (Intrinsics.areEqual((Object)(cachedData2 != null ? cachedData2.getHash() : null), (Object)newHash) ^ true) {
                        AtomicReference atomicReference = GitIndexVirtualFile.access$getCachedData$p(this.this$0);
                        String string = newHash.asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newHash.asString()");
                        atomicReference.compareAndSet(oldCachedData, new CachedData(newHash, GitIndexVirtualFile.access$calculateLength(this.this$0, string), isExecutable));
                    }
                }
                {
                    this.this$0 = gitIndexVirtualFile;
                    this.$newContent = byArray;
                    this.$newModStamp = l;
                    super(0);
                }
            }));
        }
        catch (Exception e) {
            throw (Throwable)new IOException(e);
        }
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = VfsUtilCore.byteStreamSkippingBOM((byte[])this.contentsToByteArray(), (VirtualFile)this);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"VfsUtilCore.byteStreamSk\u2026tentsToByteArray(), this)");
        return inputStream;
    }

    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        try {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isDispatchThread()) {
                Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<byte[], IOException>(this){
                    final /* synthetic */ GitIndexVirtualFile this$0;

                    public final byte[] compute() {
                        return GitIndexVirtualFile.access$contentToByteArrayImpl(this.this$0);
                    }
                    {
                        this.this$0 = gitIndexVirtualFile;
                    }
                }, GitBundle.message("stage.vfs.read.process", this.getName()), false, this.project);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ProgressManager.getInsta\u2026\", name), false, project)");
                return (byte[])object;
            }
            return this.contentToByteArrayImpl();
        }
        catch (Exception e) {
            throw (Throwable)new IOException(e);
        }
    }

    private final byte[] contentToByteArrayImpl() {
        byte[] byArray;
        try {
            byte[] byArray2 = GitFileUtils.getFileContent(this.project, this.root, "", VcsFileUtil.relativePath((VirtualFile)this.root, (FilePath)this.filePath));
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"GitFileUtils.getFileCont\u2026tivePath(root, filePath))");
            byArray = byArray2;
        }
        catch (VcsException e) {
            throw (Throwable)new IOException(e);
        }
        return byArray;
    }

    private final CachedData readCachedData() {
        List<GitIndexUtil.StagedFile> list2 = GitIndexUtil.listStaged(this.project, this.root, CollectionsKt.listOf((Object)this.filePath));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"GitIndexUtil.listStaged(\u2026, root, listOf(filePath))");
        GitIndexUtil.StagedFile stagedFile = (GitIndexUtil.StagedFile)CollectionsKt.singleOrNull(list2);
        if (stagedFile == null) {
            return null;
        }
        GitIndexUtil.StagedFile stagedFile2 = stagedFile;
        Hash hash = HashImpl.build((String)stagedFile2.getBlobHash());
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"HashImpl.build(stagedFile.blobHash)");
        String string = stagedFile2.getBlobHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stagedFile.blobHash");
        return new CachedData(hash, this.calculateLength(string), stagedFile2.isExecutable());
    }

    private final long calculateLength(String hash) throws VcsException {
        String output;
        GitLineHandler h2 = new GitLineHandler(this.project, this.root, GitCommand.CAT_FILE);
        h2.setSilent(true);
        h2.addParameters("-s");
        h2.addParameters(hash);
        h2.endOptions();
        String string = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Git.getInstance().runCommand(h).getOutputOrThrow()");
        String string2 = output = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        Long l = Long.valueOf(((Object)StringsKt.trim((CharSequence)string3)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"java.lang.Long.valueOf(output.trim())");
        return l;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type git4idea.index.vfs.GitIndexVirtualFile");
        }
        GitIndexVirtualFile cfr_ignored_0 = (GitIndexVirtualFile)((Object)object2);
        if (Intrinsics.areEqual((Object)this.project, (Object)((GitIndexVirtualFile)((Object)other)).project) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.root, (Object)((GitIndexVirtualFile)((Object)other)).root) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.filePath, (Object)((GitIndexVirtualFile)((Object)other)).filePath) ^ true);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.root, this.filePath);
    }

    @NotNull
    public String toString() {
        return "GitIndexVirtualFile: [" + this.root.getName() + "]/" + VcsFileUtil.relativePath((VirtualFile)this.root, (FilePath)this.filePath);
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    @NotNull
    public final FilePath getFilePath() {
        return this.filePath;
    }

    public GitIndexVirtualFile(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        this.project = project;
        this.root = root;
        this.filePath = filePath;
        this.cachedData = new AtomicReference();
        this.modificationStamp = LocalTimeCounter.currentTime();
        Runnable task2 = new Runnable(this){
            final /* synthetic */ GitIndexVirtualFile this$0;

            public final void run() {
                GitIndexVirtualFile.access$getCachedData$p(this.this$0).compareAndSet(null, GitIndexVirtualFile.access$readCachedData(this.this$0));
            }
            {
                this.this$0 = gitIndexVirtualFile;
            }
        };
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(task2, GitBundle.message("stage.vfs.read.process", this.getName()), false, this.project);
        } else {
            task2.run();
        }
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GitIndexVirtualFile.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(GitIn\u2026xVirtualFile::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$write(GitIndexVirtualFile $this, Object requestor, byte[] newContent, long newModificationStamp) {
        $this.write(requestor, newContent, newModificationStamp);
    }

    public static final /* synthetic */ CachedData access$readCachedData(GitIndexVirtualFile $this) {
        return $this.readCachedData();
    }

    public static final /* synthetic */ Project access$getProject$p(GitIndexVirtualFile $this) {
        return $this.project;
    }

    public static final /* synthetic */ long access$getModificationStamp$p(GitIndexVirtualFile $this) {
        return $this.modificationStamp;
    }

    public static final /* synthetic */ void access$setModificationStamp$p(GitIndexVirtualFile $this, long l) {
        $this.modificationStamp = l;
    }

    public static final /* synthetic */ long access$calculateLength(GitIndexVirtualFile $this, String hash) {
        return $this.calculateLength(hash);
    }

    public static final /* synthetic */ byte[] access$contentToByteArrayImpl(GitIndexVirtualFile $this) {
        return $this.contentToByteArrayImpl();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B#\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFile$Refresh;", "", "oldCachedData", "Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;", "newCachedData", "oldModificationStamp", "", "(Lgit4idea/index/vfs/GitIndexVirtualFile;Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;J)V", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "getEvent", "()Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "run", "", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
    public final class Refresh {
        @NotNull
        private final VFileContentChangeEvent event;
        private final CachedData oldCachedData;
        private final CachedData newCachedData;

        @NotNull
        public final VFileContentChangeEvent getEvent() {
            return this.event;
        }

        public final boolean run() {
            LOG.debug("Refreshing " + (Object)((Object)GitIndexVirtualFile.this));
            return GitIndexVirtualFile.this.cachedData.compareAndSet(this.oldCachedData, this.newCachedData);
        }

        @NotNull
        public String toString() {
            return "GitIndexVirtualFile.Refresh: " + (Object)((Object)GitIndexVirtualFile.this);
        }

        public Refresh(@Nullable CachedData oldCachedData, CachedData newCachedData, long oldModificationStamp) {
            this.oldCachedData = oldCachedData;
            this.newCachedData = newCachedData;
            CachedData cachedData = this.oldCachedData;
            CachedData cachedData2 = this.newCachedData;
            this.event = new VFileContentChangeEvent(null, (VirtualFile)GitIndexVirtualFile.this, oldModificationStamp, -1L, 0L, 0L, cachedData != null ? cachedData.getLength() : 0L, cachedData2 != null ? cachedData2.getLength() : 0L, true);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;", "", "hash", "Lcom/intellij/vcs/log/Hash;", "length", "", "isExecutable", "", "(Lcom/intellij/vcs/log/Hash;JZ)V", "getHash", "()Lcom/intellij/vcs/log/Hash;", "()Z", "getLength", "()J", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    public static final class CachedData {
        @NotNull
        private final Hash hash;
        private final long length;
        private final boolean isExecutable;

        @NotNull
        public final Hash getHash() {
            return this.hash;
        }

        public final long getLength() {
            return this.length;
        }

        public final boolean isExecutable() {
            return this.isExecutable;
        }

        public CachedData(@NotNull Hash hash, long length, boolean isExecutable) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            this.hash = hash;
            this.length = length;
            this.isExecutable = isExecutable;
        }

        public /* synthetic */ CachedData(Hash hash, long l, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(hash, l, bl);
        }

        @NotNull
        public final Hash component1() {
            return this.hash;
        }

        public final long component2() {
            return this.length;
        }

        public final boolean component3() {
            return this.isExecutable;
        }

        @NotNull
        public final CachedData copy(@NotNull Hash hash, long length, boolean isExecutable) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return new CachedData(hash, length, isExecutable);
        }

        public static /* synthetic */ CachedData copy$default(CachedData cachedData, Hash hash, long l, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                hash = cachedData.hash;
            }
            if ((n & 2) != 0) {
                l = cachedData.length;
            }
            if ((n & 4) != 0) {
                bl = cachedData.isExecutable;
            }
            return cachedData.copy(hash, l, bl);
        }

        @NotNull
        public String toString() {
            return "CachedData(hash=" + this.hash + ", length=" + this.length + ", isExecutable=" + this.isExecutable + ")";
        }

        public int hashCode() {
            Hash hash = this.hash;
            int n = ((hash != null ? hash.hashCode() : 0) * 31 + Long.hashCode(this.length)) * 31;
            int n2 = this.isExecutable ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CachedData)) break block3;
                    CachedData cachedData = (CachedData)object;
                    if (!Intrinsics.areEqual((Object)this.hash, (Object)cachedData.hash) || this.length != cachedData.length || this.isExecutable != cachedData.isExecutable) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/index/vfs/GitIndexVirtualFile$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "SEPARATOR", "", "decode", "Lkotlin/Triple;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/vcs/FilePath;", "path", "", "encode", "project", "root", "filePath", "extractPresentableUrl", "intellij.vcs.git"})
    public static final class Companion {
        private final String encode(Project project, VirtualFile root, FilePath filePath) {
            return StringUtil.escapeChar((String)project.getLocationHash(), (char)':') + ':' + StringUtil.escapeChar((String)root.getPath(), (char)':') + ':' + StringUtil.escapeChar((String)filePath.getPath(), (char)':');
        }

        @Nullable
        public final Triple<Project, VirtualFile, FilePath> decode(@NotNull String path) {
            Project project;
            List components;
            block4: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                components = StringsKt.split$default((CharSequence)path, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
                if (components.size() != 3) {
                    return null;
                }
                String string = StringUtil.unescapeChar((String)((String)components.get(0)), (char)':');
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.unescapeChar(components[0], SEPARATOR)");
                String locationHash = string;
                ProjectManager projectManager = ProjectManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
                Project[] projectArray = projectManager.getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
                Project[] $this$firstOrNull$iv = projectArray;
                boolean $i$f$firstOrNull = false;
                Project[] projectArray2 = $this$firstOrNull$iv;
                int n = projectArray2.length;
                for (int j = 0; j < n; ++j) {
                    Project element$iv;
                    Project it = element$iv = projectArray2[j];
                    boolean bl = false;
                    Project project2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"it");
                    if (!Intrinsics.areEqual((Object)project2.getLocationHash(), (Object)locationHash)) continue;
                    project = element$iv;
                    break block4;
                }
                project = null;
            }
            if (project == null) {
                return null;
            }
            Project project3 = project;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(StringUtil.unescapeChar((String)((String)components.get(1)), (char)':'));
            if (virtualFile == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026EPARATOR)) ?: return null");
            VirtualFile root = virtualFile;
            FilePath filePath = VcsUtil.getFilePath((String)StringUtil.unescapeChar((String)((String)components.get(2)), (char)':'));
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"VcsUtil.getFilePath(Stri\u2026omponents[2], SEPARATOR))");
            FilePath filePath2 = filePath;
            return new Triple((Object)project3, (Object)root, (Object)filePath2);
        }

        @NotNull
        public final String extractPresentableUrl(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return StringsKt.replace$default((String)StringsKt.substringAfterLast$default((String)path, (char)':', null, (int)2, null), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

