/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.soap;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.soap.JiraSoapTask;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraLegacyApi
extends JiraRemoteApi {
    private static final Logger LOG = Logger.getInstance(JiraLegacyApi.class);
    @NonNls
    private static final String RSS_SEARCH_PATH = "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml";
    public static final String RSS_ISSUE_PATH = "/si/jira.issueviews:issue-xml/";

    public JiraLegacyApi(@NotNull JiraRepository repository) {
        if (repository == null) {
            JiraLegacyApi.$$$reportNull$$$0(0);
        }
        super(repository);
    }

    @Override
    @NotNull
    public List<Task> findTasks(@NotNull String query, int max) throws Exception {
        if (query == null) {
            JiraLegacyApi.$$$reportNull$$$0(1);
        }
        GetMethod method = new GetMethod(this.myRepository.getUrl() + RSS_SEARCH_PATH);
        method.setQueryString(new NameValuePair[]{new NameValuePair("tempMax", String.valueOf(max)), new NameValuePair("assignee", TaskUtil.encodeUrl((String)this.myRepository.getUsername())), new NameValuePair("reset", "true"), new NameValuePair("sorter/field", "updated"), new NameValuePair("sorter/order", "DESC"), new NameValuePair("pager/start", "0")});
        List<Task> list = this.processRSS(method);
        if (list == null) {
            JiraLegacyApi.$$$reportNull$$$0(2);
        }
        return list;
    }

    private List<Task> processRSS(@NotNull GetMethod method) throws Exception {
        int code;
        if (method == null) {
            JiraLegacyApi.$$$reportNull$$$0(3);
        }
        if ((code = this.myRepository.getHttpClient().executeMethod((HttpMethod)method)) != 200) {
            throw new Exception(TaskBundle.message((String)"failure.http.error", (Object[])new Object[]{code, method.getStatusText()}));
        }
        Element root = new SAXBuilder(false).build(method.getResponseBodyAsStream()).getRootElement();
        Element channel = root.getChild("channel");
        if (channel != null) {
            List children = channel.getChildren("item");
            LOG.debug("Total issues in JIRA RSS feed: " + children.size());
            return ContainerUtil.map((Collection)children, element -> new JiraSoapTask((Element)element, (TaskRepository)this.myRepository));
        }
        LOG.warn("JIRA channel not found");
        return ContainerUtil.emptyList();
    }

    @Override
    @Nullable
    public Task findTask(@NotNull String key) throws Exception {
        if (key == null) {
            JiraLegacyApi.$$$reportNull$$$0(4);
        }
        try {
            List<Task> tasks = this.processRSS(new GetMethod(this.myRepository.getUrl() + RSS_ISSUE_PATH + key + "/" + key + ".xml"));
            return tasks.isEmpty() ? null : tasks.get(0);
        }
        catch (Exception e) {
            LOG.warn("Cannot get issue " + key + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    @NotNull
    public final JiraRemoteApi.ApiType getType() {
        JiraRemoteApi.ApiType apiType = JiraRemoteApi.ApiType.LEGACY;
        if (apiType == null) {
            JiraLegacyApi.$$$reportNull$$$0(5);
        }
        return apiType;
    }

    @Override
    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        if (task == null) {
            JiraLegacyApi.$$$reportNull$$$0(6);
        }
        Set<CustomTaskState> set = Collections.emptySet();
        if (set == null) {
            JiraLegacyApi.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Override
    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        if (task == null) {
            JiraLegacyApi.$$$reportNull$$$0(8);
        }
        if (state == null) {
            JiraLegacyApi.$$$reportNull$$$0(9);
        }
        throw new Exception(TaskBundle.message((String)"jira.failure.no.state.update", (Object[])new Object[0]));
    }

    @Override
    public void updateTimeSpend(@NotNull LocalTask task, @NotNull String timeSpent, String comment) throws Exception {
        if (task == null) {
            JiraLegacyApi.$$$reportNull$$$0(10);
        }
        if (timeSpent == null) {
            JiraLegacyApi.$$$reportNull$$$0(11);
        }
        throw new Exception(TaskBundle.message((String)"jira.failure.no.time.spent", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/jira/soap/JiraLegacyApi";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeSpent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/jira/soap/JiraLegacyApi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findTasks";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTaskStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTasks";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processRSS";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTask";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTaskStates";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTaskState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateTimeSpend";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

