/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.thumbnail.ThumbnailManager;
import org.intellij.images.thumbnail.ThumbnailView;

final class ThumbnailSelectInTarget
implements SelectInTarget {
    ThumbnailSelectInTarget() {
    }

    public boolean canSelect(SelectInContext context) {
        VirtualFile virtualFile = context.getVirtualFile();
        return ImageFileTypeManager.getInstance().isImage(virtualFile) && virtualFile.getParent() != null;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        VirtualFile virtualFile = context.getVirtualFile();
        VirtualFile parent = virtualFile.getParent();
        if (parent != null) {
            Project project = context.getProject();
            ThumbnailView thumbnailView = ThumbnailManager.getManager(project).getThumbnailView();
            thumbnailView.setRoot(parent);
            thumbnailView.setVisible(true);
            thumbnailView.setSelected(virtualFile, true);
            thumbnailView.scrollToSelection();
        }
    }

    public String toString() {
        return ImagesBundle.message("thumbnails.toolwindow.name", new Object[0]);
    }

    public String getToolWindowId() {
        return "Thumbnails";
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 10.0f;
    }
}

