/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.StatisticsStringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogBuild
implements Comparable<EventLogBuild> {
    public static final int SNAPSHOT_VALUE = Integer.MAX_VALUE;
    private final int[] myComponents;

    public EventLogBuild(int ... components) {
        this.myComponents = components;
    }

    public int[] getComponents() {
        return (int[])this.myComponents.clone();
    }

    @Nullable
    public static EventLogBuild fromString(@Nullable String version) {
        if (version == null || StatisticsStringUtil.isEmptyOrSpaces(version)) {
            return null;
        }
        String versionWithoutCode = EventLogBuild.removeProductCode(version);
        int separator = versionWithoutCode.indexOf(46);
        if (separator > 0) {
            List<String> components = StatisticsStringUtil.split(versionWithoutCode, '.');
            return new EventLogBuild(EventLogBuild.toIntArray(components));
        }
        return new EventLogBuild(EventLogBuild.tryParseInt(versionWithoutCode), 0);
    }

    private static int[] toIntArray(List<String> components) {
        int componentsSize = components.size();
        int size = componentsSize != 1 ? componentsSize : 2;
        int[] array = new int[size];
        for (int i = 0; i < componentsSize; ++i) {
            String component = components.get(i);
            array[i] = EventLogBuild.tryParseInt(component);
        }
        if (componentsSize < size) {
            array[componentsSize] = 0;
        }
        return array;
    }

    @NotNull
    private static String removeProductCode(@NotNull String version) {
        String code;
        int productSeparator;
        if (version == null) {
            EventLogBuild.$$$reportNull$$$0(0);
        }
        if ((productSeparator = (code = version).indexOf(45)) > 0) {
            code = code.substring(productSeparator + 1);
        }
        String string = code;
        if (string == null) {
            EventLogBuild.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static int tryParseInt(@NotNull String version) {
        if (version == null) {
            EventLogBuild.$$$reportNull$$$0(2);
        }
        try {
            return Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public int compareTo(@NotNull EventLogBuild o) {
        if (o == null) {
            EventLogBuild.$$$reportNull$$$0(3);
        }
        int[] c1 = this.myComponents;
        int[] c2 = o.myComponents;
        for (int i = 0; i < Math.min(c1.length, c2.length); ++i) {
            if (c1[i] == c2[i] && c1[i] == Integer.MAX_VALUE) {
                return 0;
            }
            if (c1[i] == Integer.MAX_VALUE) {
                return 1;
            }
            if (c2[i] == Integer.MAX_VALUE) {
                return -1;
            }
            int result = c1[i] - c2[i];
            if (result == 0) continue;
            return result;
        }
        return c1.length - c2.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventLogBuild number = (EventLogBuild)o;
        return Arrays.equals(this.myComponents, number.myComponents);
    }

    public int hashCode() {
        return Arrays.hashCode(this.myComponents);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/EventLogBuild";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogBuild";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "removeProductCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeProductCode";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryParseInt";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

