/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.StringTransformer;
import java.text.Normalizer;
import java.util.Locale;
import java.util.Objects;

public final class StringTransformers {
    public static final StringTransformer IDENTIY = new IdentityTransformer();
    public static final StringTransformer NFD = new NFD();
    public static final StringTransformer NFC = new NFC();

    public StringTransformer caseInsensitive() {
        return StringTransformers.caseInsensitive(Locale.getDefault());
    }

    public static StringTransformer caseInsensitive(Locale locale) {
        Objects.requireNonNull(locale);
        return new CaseInsensitive(locale);
    }

    public static StringTransformer caseInsensitiveMacOSNative(Locale locale) {
        return new CaseInsensitiveMacOSNative(locale);
    }

    public static StringTransformer caseInsensitiveMacOSJvm(Locale locale) {
        return new CaseInsensitiveMacOSJvm(locale);
    }

    static final class IdentityTransformer
    implements StringTransformer {
        IdentityTransformer() {
        }

        @Override
        public String transform(String s) {
            return s;
        }

        @Override
        public int getRegexFlags() {
            return 0;
        }
    }

    static final class CaseInsensitive
    implements StringTransformer {
        private final Locale locale;

        CaseInsensitive(Locale locale) {
            this.locale = locale;
        }

        @Override
        public String transform(String s) {
            return s.toUpperCase(this.locale);
        }

        @Override
        public int getRegexFlags() {
            return 66;
        }
    }

    static final class CaseInsensitiveMacOSJvm
    implements StringTransformer {
        private final Locale locale;

        CaseInsensitiveMacOSJvm(Locale locale) {
            this.locale = locale;
        }

        @Override
        public String transform(String s) {
            return Normalizer.normalize(s, Normalizer.Form.NFC).toUpperCase(this.locale);
        }

        @Override
        public int getRegexFlags() {
            return 194;
        }
    }

    static final class CaseInsensitiveMacOSNative
    implements StringTransformer {
        private final Locale locale;

        CaseInsensitiveMacOSNative(Locale locale) {
            this.locale = locale;
        }

        @Override
        public String transform(String s) {
            return Normalizer.normalize(s, Normalizer.Form.NFD).toUpperCase(this.locale);
        }

        @Override
        public int getRegexFlags() {
            return 194;
        }
    }

    static final class NFC
    implements StringTransformer {
        NFC() {
        }

        @Override
        public String transform(String s) {
            return Normalizer.normalize(s, Normalizer.Form.NFC);
        }

        @Override
        public int getRegexFlags() {
            return 194;
        }
    }

    static final class NFD
    implements StringTransformer {
        NFD() {
        }

        @Override
        public String transform(String s) {
            return Normalizer.normalize(s, Normalizer.Form.NFD);
        }

        @Override
        public int getRegexFlags() {
            return 194;
        }
    }
}

