/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browser.OpeningExpander;

public class CopyOptionsDialog
extends DialogWrapper {
    private final Url myURL;
    private Url myTargetUrl;
    private CommitMessage myCommitMessage;
    private final Project myProject;
    private JTextField myNameField;
    private JBLabel myURLLabel;
    private RepositoryBrowserComponent myBrowser;
    private JBLabel myTargetURLLabel;
    private BorderLayoutPanel myMainPanel;

    public CopyOptionsDialog(Project project, RepositoryTreeNode root, RepositoryTreeNode node, boolean copy) {
        super(project, true);
        this.myProject = project;
        this.myURL = node.getURL();
        this.createUI();
        this.myTargetURLLabel.setForeground(copy ? FileStatus.ADDED.getColor() : FileStatus.MODIFIED.getColor());
        this.setOKButtonText(copy ? SvnBundle.message("button.copy", new Object[0]) : SvnBundle.message("button.move", new Object[0]));
        this.myURLLabel.setText(this.myURL.toDecodedString());
        TreeNode[] path = node.getSelfPath();
        TreeNode[] subPath = new TreeNode[path.length - 1];
        System.arraycopy(path, 1, subPath, 0, path.length - 1);
        this.myBrowser.setRepositoryURL(root.getURL(), false, new OpeningExpander.Factory(subPath, node.getParent() instanceof RepositoryTreeNode ? (RepositoryTreeNode)node.getParent() : null));
        this.myBrowser.addChangeListener(e -> this.update());
        this.myNameField.setText(this.myURL.getTail());
        this.myNameField.selectAll();
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CopyOptionsDialog.this.update();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/dialogs/browser/CopyOptionsDialog$1", "textChanged"));
            }
        });
        String lastMessage = VcsConfiguration.getInstance((Project)this.myProject).getLastNonEmptyCommitMessage();
        if (lastMessage != null) {
            this.myCommitMessage.setText(lastMessage);
            this.myCommitMessage.getEditorField().selectAll();
        }
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myBrowser);
        this.setTitle(copy ? SvnBundle.message("copy.dialog.title", new Object[0]) : SvnBundle.message("move.dialog.title", new Object[0]));
        this.init();
        this.update();
    }

    @NotNull
    public static ComboBox<String> configureRecentMessagesComponent(@NotNull Project project, @NotNull ComboBox<String> comboBox, @NotNull Consumer<? super String> messageConsumer) {
        if (project == null) {
            CopyOptionsDialog.$$$reportNull$$$0(0);
        }
        if (comboBox == null) {
            CopyOptionsDialog.$$$reportNull$$$0(1);
        }
        if (messageConsumer == null) {
            CopyOptionsDialog.$$$reportNull$$$0(2);
        }
        ArrayList messages = VcsConfiguration.getInstance((Project)project).getRecentMessages();
        Collections.reverse(messages);
        CollectionComboBoxModel model = new CollectionComboBoxModel((List)messages);
        comboBox.setModel((ComboBoxModel)model);
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", commitMessage -> CopyOptionsDialog.getPresentableCommitMessage(commitMessage)));
        comboBox.addActionListener(e -> messageConsumer.accept((String)model.getSelected()));
        ComboBox<String> comboBox2 = comboBox;
        if (comboBox2 == null) {
            CopyOptionsDialog.$$$reportNull$$$0(3);
        }
        return comboBox2;
    }

    @NlsSafe
    private static String getPresentableCommitMessage(@NotNull String commitMessage) {
        if (commitMessage == null) {
            CopyOptionsDialog.$$$reportNull$$$0(4);
        }
        return commitMessage.replace('\r', '|').replace('\n', '|');
    }

    private void createUI() {
        this.myMainPanel = JBUI.Panels.simplePanel();
        this.myBrowser = new RepositoryBrowserComponent(SvnVcs.getInstance(this.myProject));
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RepositoryBrowserDialog.MkDirAction(this.myBrowser){

            @Override
            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setText(SvnBundle.messagePointer("action.new.remote.folder.text", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/dialogs/browser/CopyOptionsDialog$2", "update"));
            }
        });
        group.add((AnAction)new RepositoryBrowserDialog.DeleteAction(this.myBrowser));
        group.add((AnAction)new RepositoryBrowserDialog.RefreshAction(this.myBrowser));
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group);
        final JPopupMenu component = popupMenu.getComponent();
        this.myBrowser.getRepositoryTree().addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                component.show(comp, x, y);
            }
        });
        Splitter splitter = new Splitter(true, 0.7f);
        splitter.setFirstComponent((JComponent)this.createBrowserPartWrapper());
        splitter.setSecondComponent((JComponent)this.createCommitMessageWrapper());
        this.myMainPanel.addToCenter((Component)splitter);
        ComboBox<String> messagesBox = CopyOptionsDialog.configureRecentMessagesComponent(this.myProject, (ComboBox<String>)new ComboBox(), message -> {
            if (message != null) {
                this.myCommitMessage.setText(message);
                this.myCommitMessage.getEditorField().selectAll();
            }
        });
        this.myMainPanel.addToBottom((Component)JBUI.Panels.simplePanel().addToTop((Component)new JBLabel(SvnBundle.message("label.recent.messages", new Object[0]))).addToBottom(messagesBox).withBorder((Border)JBUI.Borders.emptyTop((int)4)));
    }

    @NotNull
    private JPanel createCommitMessageWrapper() {
        this.myCommitMessage = new CommitMessage(this.myProject, false, false, true);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myCommitMessage);
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel((Component)this.myCommitMessage).addToTop((Component)new JBLabel(SvnBundle.message("label.commit.message", new Object[0])));
        if (borderLayoutPanel == null) {
            CopyOptionsDialog.$$$reportNull$$$0(5);
        }
        return borderLayoutPanel;
    }

    @NotNull
    private JPanel createBrowserPartWrapper() {
        JPanel wrapper = new JPanel(new GridBagLayout());
        GridBag gridBag = new GridBag().setDefaultAnchor(18).setDefaultFill(0).setDefaultInsets((Insets)JBUI.insets((int)1)).setDefaultWeightX(1.0).setDefaultWeightY(0.0);
        gridBag.nextLine().next().weightx(0.0);
        wrapper.add((Component)new JBLabel(SvnBundle.message("label.source.url", new Object[0])), gridBag);
        gridBag.next().fillCellHorizontally();
        this.myURLLabel = new JBLabel();
        this.myURLLabel.setFont(this.myURLLabel.getFont().deriveFont(1));
        wrapper.add((Component)this.myURLLabel, gridBag);
        gridBag.nextLine().next().weightx(0.0).pady(4);
        wrapper.add((Component)new JBLabel(SvnBundle.message("label.target.location", new Object[0])), gridBag);
        gridBag.nextLine().next().fillCell().weighty(1.0).coverLine(2);
        wrapper.add((Component)this.myBrowser, gridBag);
        gridBag.nextLine().next().weightx(0.0).pady(4);
        wrapper.add((Component)new JBLabel(SvnBundle.message("label.target.name", new Object[0])), gridBag);
        gridBag.next().fillCellHorizontally();
        this.myNameField = new JTextField();
        wrapper.add((Component)this.myNameField, gridBag);
        gridBag.nextLine().next().weightx(0.0).pady(2);
        wrapper.add((Component)new JBLabel(SvnBundle.message("label.target.url", new Object[0])), gridBag);
        gridBag.next().fillCellHorizontally();
        this.myTargetURLLabel = new JBLabel();
        this.myTargetURLLabel.setFont(this.myTargetURLLabel.getFont().deriveFont(1));
        wrapper.add((Component)this.myTargetURLLabel, gridBag);
        JPanel jPanel = wrapper;
        if (jPanel == null) {
            CopyOptionsDialog.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.copy.options";
    }

    public String getCommitMessage() {
        return this.myCommitMessage.getComment();
    }

    public Url getSourceURL() {
        return this.myURL;
    }

    public String getName() {
        return this.myNameField.getText();
    }

    @Nullable
    public Url getTargetURL() {
        return this.myTargetUrl;
    }

    @Nullable
    public RepositoryTreeNode getTargetParentNode() {
        return this.myBrowser.getSelectedNode();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void update() {
        this.myTargetUrl = this.buildTargetUrl();
        this.myTargetURLLabel.setText(this.myTargetUrl != null ? this.myTargetUrl.toDecodedString() : "");
        this.getOKAction().setEnabled(this.myTargetUrl != null && !this.myURL.equals(this.myTargetUrl));
    }

    @Nullable
    private Url buildTargetUrl() {
        RepositoryTreeNode locationNode = this.myBrowser.getSelectedNode();
        if (locationNode == null) {
            return null;
        }
        Url location = locationNode.getURL();
        String name = this.myNameField.getText();
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        try {
            return SvnUtil.append(location, name);
        }
        catch (SvnBindException e) {
            return null;
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageConsumer";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/browser/CopyOptionsDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/browser/CopyOptionsDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "configureRecentMessagesComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessageWrapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createBrowserPartWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configureRecentMessagesComponent";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableCommitMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

